/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Enumeration;

public class JCERSAPrivateKey
implements RSAPrivateKey,
PKCS12BagAttributeCarrier {
    public static final long serialVersionUID = 5110188922551353628L;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    public BigInteger modulus;
    public BigInteger privateExponent;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier;

    public JCERSAPrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public JCERSAPrivateKey(RSAKeyParameters rSAKeyParameters) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.modulus = rSAKeyParameters.getModulus();
        this.privateExponent = rSAKeyParameters.getExponent();
    }

    public JCERSAPrivateKey(RSAPrivateKeySpec rSAPrivateKeySpec) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.modulus = rSAPrivateKeySpec.getModulus();
        this.privateExponent = rSAPrivateKeySpec.getPrivateExponent();
    }

    public JCERSAPrivateKey(RSAPrivateKey rSAPrivateKey) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.modulus = rSAPrivateKey.getModulus();
        this.privateExponent = rSAPrivateKey.getPrivateExponent();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl2;
        this.modulus = (BigInteger)objectInputStream.readObject();
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl3 = pKCS12BagAttributeCarrierImpl2 = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl3();
        this.attrCarrier = pKCS12BagAttributeCarrierImpl3;
        pKCS12BagAttributeCarrierImpl.readObject(objectInputStream);
        this.privateExponent = (BigInteger)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        JCERSAPrivateKey jCERSAPrivateKey = this;
        objectOutputStream.writeObject(this.modulus);
        jCERSAPrivateKey.attrCarrier.writeObject(objectOutputStream);
        objectOutputStream.writeObject(jCERSAPrivateKey.privateExponent);
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        JCERSAPrivateKey jCERSAPrivateKey = serializable;
        Serializable serializable = jCERSAPrivateKey.getModulus();
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = jCERSAPrivateKey.getPrivateExponent();
        BigInteger bigInteger3 = ZERO;
        return KeyUtil.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey((BigInteger)serializable, bigInteger, bigInteger2, bigInteger3, bigInteger3, bigInteger3, bigInteger3, bigInteger3));
    }

    public boolean equals(Object object) {
        if (!(object instanceof RSAPrivateKey)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (RSAPrivateKey)object;
        return this.getModulus().equals(object.getModulus()) && this.getPrivateExponent().equals(object.getPrivateExponent());
    }

    public int hashCode() {
        return this.getModulus().hashCode() ^ this.getPrivateExponent().hashCode();
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

