/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.SignedData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PEMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CRLObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509StreamParserSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.util.StreamParsingException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.cert.CRL;
import java.util.ArrayList;
import java.util.Collection;

public class X509CRLParser
extends X509StreamParserSpi {
    private static final PEMUtil PEM_PARSER = new PEMUtil("CRL");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;

    private CRL readDERCRL(InputStream object) {
        if (((ASN1Sequence)(object = (ASN1Sequence)new ASN1InputStream((InputStream)object).readObject())).size() > 1 && ((ASN1Sequence)object).getObjectAt(0) instanceof ASN1ObjectIdentifier && ((ASN1Sequence)object).getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1Sequence)object).getObjectAt(1), true)).getCRLs();
            return this.getCRL();
        }
        return new X509CRLObject(CertificateList.getInstance(object));
    }

    private CRL getCRL() {
        ASN1Set aSN1Set = this.sData;
        if (aSN1Set != null && this.sDataObjectCount < aSN1Set.size()) {
            int n = this.sDataObjectCount;
            this.sDataObjectCount = n + 1;
            return new X509CRLObject(CertificateList.getInstance(this.sData.getObjectAt(n)));
        }
        return null;
    }

    private CRL readPEMCRL(InputStream inputStream) {
        ASN1Sequence aSN1Sequence = PEM_PARSER.readPEMObject(inputStream);
        if (aSN1Sequence != null) {
            return new X509CRLObject(CertificateList.getInstance(aSN1Sequence));
        }
        return null;
    }

    @Override
    public void engineInit(InputStream inputStream) {
        X509CRLParser x509CRLParser = this;
        x509CRLParser.currentStream = inputStream;
        x509CRLParser.sData = null;
        x509CRLParser.sDataObjectCount = 0;
        if (!inputStream.markSupported()) {
            this.currentStream = new BufferedInputStream(this.currentStream);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object engineRead() {
        try {
            ASN1Set aSN1Set = this.sData;
            if (aSN1Set != null) {
                if (this.sDataObjectCount != aSN1Set.size()) {
                    return this.getCRL();
                }
                X509CRLParser x509CRLParser = this;
                x509CRLParser.sData = null;
                x509CRLParser.sDataObjectCount = 0;
                return null;
            }
            X509CRLParser x509CRLParser = this;
            x509CRLParser.currentStream.mark(10);
            int n = x509CRLParser.currentStream.read();
            if (n == -1) {
                return null;
            }
            if (n != 48) {
                X509CRLParser x509CRLParser2 = this;
                x509CRLParser2.currentStream.reset();
                return x509CRLParser2.readPEMCRL(x509CRLParser2.currentStream);
            }
            X509CRLParser x509CRLParser3 = this;
            x509CRLParser3.currentStream.reset();
            return x509CRLParser3.readDERCRL(x509CRLParser3.currentStream);
        }
        catch (Exception exception) {
            throw new StreamParsingException(((Object)exception).toString(), exception);
        }
    }

    @Override
    public Collection engineReadAll() {
        CRL cRL;
        ArrayList<CRL> arrayList;
        ArrayList<CRL> arrayList2 = arrayList;
        arrayList = new ArrayList<CRL>();
        while ((cRL = (CRL)this.engineRead()) != null) {
            arrayList2.add(cRL);
        }
        return arrayList2;
    }
}

