/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Null;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import d.a;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PSSParameterSpec;

class X509SignatureUtil {
    private static final ASN1Null derNull = DERNull.INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSignatureParameters(Signature signature, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable == null || derNull.equals(aSN1Encodable)) return;
        Signature signature2 = signature;
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(signature2.getAlgorithm(), signature.getProvider());
        try {
            algorithmParameters.init(aSN1Encodable.toASN1Primitive().getEncoded());
            if (!signature2.getAlgorithm().endsWith("MGF1")) return;
        }
        catch (IOException iOException) {
            throw new SignatureException(b.a(iOException, b.b.a("IOException decoding parameters: ")));
        }
        try {
            signature.setParameter(algorithmParameters.getParameterSpec(PSSParameterSpec.class));
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(b.b.a("Exception extracting parameters: ").append(generalSecurityException.getMessage()).toString());
        }
    }

    public static String getSignatureName(AlgorithmIdentifier aSN1Object) {
        ASN1Encodable aSN1Encodable = ((AlgorithmIdentifier)aSN1Object).getParameters();
        if (aSN1Encodable != null && !derNull.equals(aSN1Encodable)) {
            if (((AlgorithmIdentifier)aSN1Object).getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
                aSN1Object = RSASSAPSSparams.getInstance(aSN1Encodable);
                return a.a(new StringBuilder(), X509SignatureUtil.getDigestAlgName(((RSASSAPSSparams)aSN1Object).getHashAlgorithm().getAlgorithm()), "withRSAandMGF1");
            }
            if (((AlgorithmIdentifier)aSN1Object).getAlgorithm().equals(X9ObjectIdentifiers.ecdsa_with_SHA2)) {
                aSN1Object = ASN1Sequence.getInstance(aSN1Encodable);
                return a.a(new StringBuilder(), X509SignatureUtil.getDigestAlgName(ASN1ObjectIdentifier.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(0))), "withECDSA");
            }
        }
        return ((AlgorithmIdentifier)aSN1Object).getAlgorithm().getId();
    }

    private static String getDigestAlgName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (PKCSObjectIdentifiers.md5.equals(aSN1ObjectIdentifier)) {
            return "MD5";
        }
        if (OIWObjectIdentifiers.idSHA1.equals(aSN1ObjectIdentifier)) {
            return "SHA1";
        }
        if (NISTObjectIdentifiers.id_sha224.equals(aSN1ObjectIdentifier)) {
            return "SHA224";
        }
        if (NISTObjectIdentifiers.id_sha256.equals(aSN1ObjectIdentifier)) {
            return "SHA256";
        }
        if (NISTObjectIdentifiers.id_sha384.equals(aSN1ObjectIdentifier)) {
            return "SHA384";
        }
        if (NISTObjectIdentifiers.id_sha512.equals(aSN1ObjectIdentifier)) {
            return "SHA512";
        }
        if (TeleTrusTObjectIdentifiers.ripemd128.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD128";
        }
        if (TeleTrusTObjectIdentifiers.ripemd160.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD160";
        }
        if (TeleTrusTObjectIdentifiers.ripemd256.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD256";
        }
        if (CryptoProObjectIdentifiers.gostR3411.equals(aSN1ObjectIdentifier)) {
            return "GOST3411";
        }
        return aSN1ObjectIdentifier.getId();
    }
}

