/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb.Curve25519Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb.Curve25519FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb.Curve25519Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Curve25519
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final BigInteger C_a;
    private static final BigInteger C_b;
    private static final int CURVE25519_DEFAULT_COORDS = 4;
    private static final ECFieldElement[] CURVE25519_AFFINE_ZS;
    public Curve25519Point infinity;

    public Curve25519() {
        Curve25519 curve25519 = this;
        super(q);
        curve25519.infinity = new Curve25519Point(this, null, null);
        curve25519.a = curve25519.fromBigInteger(C_a);
        curve25519.b = curve25519.fromBigInteger(C_b);
        curve25519.order = new BigInteger(1, Hex.decodeStrict("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"));
        curve25519.cofactor = BigInteger.valueOf(8L);
        curve25519.coord = 4;
    }

    static {
        Curve25519FieldElement curve25519FieldElement;
        Curve25519FieldElement curve25519FieldElement2;
        BigInteger bigInteger;
        q = Curve25519FieldElement.Q;
        BigInteger bigInteger2 = bigInteger;
        C_a = new BigInteger(1, Hex.decodeStrict("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144"));
        C_b = new BigInteger(1, Hex.decodeStrict("7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864"));
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[2];
        Curve25519FieldElement curve25519FieldElement3 = curve25519FieldElement2;
        curve25519FieldElement2 = new Curve25519FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = curve25519FieldElement3;
        curve25519FieldElement3 = curve25519FieldElement;
        curve25519FieldElement = new Curve25519FieldElement(bigInteger2);
        eCFieldElementArray[1] = curve25519FieldElement3;
        CURVE25519_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new Curve25519();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 4;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new Curve25519FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 8 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 8);
            n3 += 8;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                Curve25519FieldElement curve25519FieldElement;
                Curve25519FieldElement curve25519FieldElement2 = curve25519FieldElement;
                curve25519FieldElement = new Curve25519FieldElement(nArray2);
                return curve25519FieldElement2.Curve25519.this.createRawPoint(new Curve25519FieldElement(nArray3), curve25519FieldElement2, CURVE25519_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    int n3 = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        int[] nArray3 = nArray;
                        nArray4[i2] = nArray4[i2] ^ nArray[n22 + i2] & n3;
                        nArray2[i2] = nArray2[i2] ^ nArray3[n22 + 8 + i2] & n3;
                    }
                    n22 += 16;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = n * 8 * 2;
                for (int k = 0; k < 8; ++k) {
                    int[] nArray3 = nArray;
                    nArray4[k] = nArray3[n22 + k];
                    nArray2[k] = nArray[n22 + 8 + k];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        Curve25519Field.random(secureRandom, nArray);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        Curve25519Field.randomMult(secureRandom, nArray);
        return new Curve25519FieldElement((int[])object);
    }
}

