/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb.Curve25519Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class Curve25519FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = Nat256.toBigInteger(Curve25519Field.P);
    private static final int[] PRECOMP_POW2 = new int[]{1242472624, -991028441, -1389370248, 792926214, 1039914919, 726466713, 1338105611, 730014848};
    public int[] x;

    public Curve25519FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = Curve25519Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for Curve25519FieldElement");
    }

    public Curve25519FieldElement() {
        this.x = Nat256.create();
    }

    public Curve25519FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat256.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "Curve25519Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        Curve25519FieldElement curve25519FieldElement = object;
        Object object = Nat256.create();
        Curve25519Field.add(curve25519FieldElement.x, ((Curve25519FieldElement)eCFieldElement).x, (int[])object);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        Curve25519FieldElement curve25519FieldElement = object;
        Object object = Nat256.create();
        Curve25519Field.addOne(curve25519FieldElement.x, (int[])object);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        Curve25519FieldElement curve25519FieldElement = object;
        Object object = Nat256.create();
        Curve25519Field.subtract(curve25519FieldElement.x, ((Curve25519FieldElement)eCFieldElement).x, (int[])object);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        Curve25519FieldElement curve25519FieldElement = object;
        Object object = Nat256.create();
        Curve25519Field.multiply(curve25519FieldElement.x, ((Curve25519FieldElement)eCFieldElement).x, (int[])object);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        Curve25519Field.inv(((Curve25519FieldElement)eCFieldElement).x, nArray);
        Curve25519Field.multiply(nArray, this.x, nArray);
        return new Curve25519FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        Curve25519FieldElement curve25519FieldElement = object;
        Object object = Nat256.create();
        Curve25519Field.negate(curve25519FieldElement.x, (int[])object);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        Curve25519FieldElement curve25519FieldElement = object;
        Object object = Nat256.create();
        Curve25519Field.square(curve25519FieldElement.x, (int[])object);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        Curve25519FieldElement curve25519FieldElement = object;
        Object object = Nat256.create();
        Curve25519Field.inv(curve25519FieldElement.x, (int[])object);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = ((Curve25519FieldElement)this).x;
        if (!Nat256.isZero(((Curve25519FieldElement)this).x) && !Nat256.isOne(nArray)) {
            int[] nArray2;
            int[] nArray3 = Nat256.create();
            Object object = this = (Object)nArray3;
            Curve25519Field.square(nArray, (int[])this);
            Curve25519Field.multiply((int[])object, nArray, (int[])this);
            Curve25519Field.square((int[])object, (int[])object);
            Curve25519Field.multiply(nArray3, nArray, (int[])this);
            int[] nArray4 = Nat256.create();
            Curve25519Field.square((int[])this, nArray4);
            Curve25519Field.multiply(nArray4, nArray, nArray4);
            int[] nArray5 = nArray2 = Nat256.create();
            int[] nArray6 = nArray4;
            int[] nArray7 = nArray2;
            Object object2 = this;
            Curve25519Field.squareN(nArray4, 3, nArray2);
            Curve25519Field.multiply(nArray2, (int[])this, nArray2);
            Curve25519Field.squareN(nArray2, 4, (int[])this);
            Curve25519Field.multiply((int[])object2, nArray4, (int[])this);
            Curve25519Field.squareN((int[])object2, 4, nArray2);
            Curve25519Field.multiply(nArray7, nArray4, nArray2);
            Curve25519Field.squareN(nArray7, 15, nArray4);
            Curve25519Field.multiply(nArray6, nArray2, nArray4);
            Curve25519Field.squareN(nArray6, 30, nArray2);
            Curve25519Field.multiply(nArray5, nArray4, nArray2);
            Curve25519Field.squareN(nArray5, 60, nArray4);
            Curve25519Field.multiply(nArray4, nArray2, nArray4);
            Curve25519Field.squareN(nArray4, 11, nArray2);
            Curve25519Field.multiply(nArray2, (int[])this, nArray2);
            Curve25519Field.squareN(nArray2, 120, (int[])this);
            Curve25519Field.multiply(nArray3, nArray4, (int[])this);
            Curve25519Field.square(nArray3, nArray3);
            Curve25519Field.square(nArray3, nArray4);
            if (Nat256.eq(nArray, nArray4)) {
                return new Curve25519FieldElement((int[])this);
            }
            Curve25519Field.multiply((int[])this, PRECOMP_POW2, (int[])this);
            Curve25519Field.square((int[])this, nArray4);
            if (Nat256.eq(nArray, nArray4)) {
                return new Curve25519FieldElement((int[])this);
            }
            return null;
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object == curve25519FieldElement2) {
            return true;
        }
        if (!(object instanceof Curve25519FieldElement)) {
            return false;
        }
        Curve25519FieldElement curve25519FieldElement = curve25519FieldElement2;
        Curve25519FieldElement curve25519FieldElement2 = (Curve25519FieldElement)object;
        return Nat256.eq(curve25519FieldElement.x, curve25519FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 8);
    }
}

