/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP128R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP128R1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP128R1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat128;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP128R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP128R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP128R1_AFFINE_ZS;
    public SecP128R1Point infinity;

    public SecP128R1Curve() {
        SecP128R1Curve secP128R1Curve = this;
        super(q);
        secP128R1Curve.infinity = new SecP128R1Point(this, null, null);
        secP128R1Curve.a = secP128R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC")));
        secP128R1Curve.b = secP128R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("E87579C11079F43DD824993C2CEE5ED3")));
        secP128R1Curve.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFE0000000075A30D1B9038A115"));
        secP128R1Curve.cofactor = BigInteger.valueOf(1L);
        secP128R1Curve.coord = 2;
    }

    static {
        SecP128R1FieldElement secP128R1FieldElement;
        q = SecP128R1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP128R1FieldElement secP128R1FieldElement2 = secP128R1FieldElement;
        secP128R1FieldElement = new SecP128R1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP128R1FieldElement2;
        SECP128R1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP128R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP128R1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP128R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP128R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 4 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 4);
            n3 += 4;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP128R1FieldElement secP128R1FieldElement;
                SecP128R1FieldElement secP128R1FieldElement2 = secP128R1FieldElement;
                secP128R1FieldElement = new SecP128R1FieldElement(nArray2);
                return secP128R1FieldElement2.SecP128R1Curve.this.createRawPoint(new SecP128R1FieldElement(nArray3), secP128R1FieldElement2, SECP128R1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray4 = Nat128.create();
                int[] nArray2 = Nat128.create();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    int n3 = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        int[] nArray3 = nArray;
                        nArray4[i2] = nArray4[i2] ^ nArray[n22 + i2] & n3;
                        nArray2[i2] = nArray2[i2] ^ nArray3[n22 + 4 + i2] & n3;
                    }
                    n22 += 8;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray4 = Nat128.create();
                int[] nArray2 = Nat128.create();
                int n22 = n * 4 * 2;
                for (int k = 0; k < 4; ++k) {
                    int[] nArray3 = nArray;
                    nArray4[k] = nArray3[n22 + k];
                    nArray2[k] = nArray[n22 + 4 + k];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat128.create();
        Object object = nArray;
        SecP128R1Field.random(secureRandom, nArray);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat128.create();
        Object object = nArray;
        SecP128R1Field.randomMult(secureRandom, nArray);
        return new SecP128R1FieldElement((int[])object);
    }
}

