/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP160R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat160;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF"));
    public int[] x;

    public SecP160R1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP160R1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP160R1FieldElement");
    }

    public SecP160R1FieldElement() {
        this.x = Nat160.create();
    }

    public SecP160R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat160.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat160.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat160.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat160.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP160R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP160R1FieldElement secP160R1FieldElement = object;
        Object object = Nat160.create();
        SecP160R1Field.add(secP160R1FieldElement.x, ((SecP160R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP160R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP160R1FieldElement secP160R1FieldElement = object;
        Object object = Nat160.create();
        SecP160R1Field.addOne(secP160R1FieldElement.x, (int[])object);
        return new SecP160R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP160R1FieldElement secP160R1FieldElement = object;
        Object object = Nat160.create();
        SecP160R1Field.subtract(secP160R1FieldElement.x, ((SecP160R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP160R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP160R1FieldElement secP160R1FieldElement = object;
        Object object = Nat160.create();
        SecP160R1Field.multiply(secP160R1FieldElement.x, ((SecP160R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP160R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat160.create();
        SecP160R1Field.inv(((SecP160R1FieldElement)eCFieldElement).x, nArray);
        SecP160R1Field.multiply(nArray, this.x, nArray);
        return new SecP160R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP160R1FieldElement secP160R1FieldElement = object;
        Object object = Nat160.create();
        SecP160R1Field.negate(secP160R1FieldElement.x, (int[])object);
        return new SecP160R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP160R1FieldElement secP160R1FieldElement = object;
        Object object = Nat160.create();
        SecP160R1Field.square(secP160R1FieldElement.x, (int[])object);
        return new SecP160R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP160R1FieldElement secP160R1FieldElement = object;
        Object object = Nat160.create();
        SecP160R1Field.inv(secP160R1FieldElement.x, (int[])object);
        return new SecP160R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = ((SecP160R1FieldElement)object).x;
        if (!Nat160.isZero(((SecP160R1FieldElement)object).x) && !Nat160.isOne(nArray)) {
            int[] nArray2;
            int[] nArray3 = Nat160.create();
            Object object = nArray3;
            SecP160R1Field.square(nArray, (int[])object);
            SecP160R1Field.multiply(nArray3, nArray, (int[])object);
            int[] nArray4 = nArray2 = Nat160.create();
            Object object2 = object;
            int[] nArray5 = nArray2;
            Object object3 = object;
            int[] nArray6 = nArray2;
            Object object4 = object;
            SecP160R1Field.squareN((int[])object4, 2, nArray2);
            SecP160R1Field.multiply(nArray6, (int[])object4, nArray2);
            SecP160R1Field.squareN(nArray6, 4, (int[])object);
            SecP160R1Field.multiply((int[])object3, nArray2, (int[])object);
            SecP160R1Field.squareN((int[])object3, 8, nArray2);
            SecP160R1Field.multiply(nArray5, (int[])object3, nArray2);
            SecP160R1Field.squareN(nArray5, 16, (int[])object);
            SecP160R1Field.multiply((int[])object2, nArray2, (int[])object);
            SecP160R1Field.squareN((int[])object2, 32, nArray2);
            SecP160R1Field.multiply(nArray4, (int[])object2, nArray2);
            SecP160R1Field.squareN(nArray4, 64, (int[])object);
            SecP160R1Field.multiply((int[])object, nArray2, (int[])object);
            SecP160R1Field.square((int[])object, nArray2);
            SecP160R1Field.multiply(nArray2, nArray, nArray2);
            SecP160R1Field.squareN(nArray2, 29, nArray2);
            SecP160R1Field.square(nArray2, (int[])object);
            if (Nat160.eq(nArray, nArray3)) {
                SecP160R1FieldElement secP160R1FieldElement;
                object = secP160R1FieldElement;
                secP160R1FieldElement = new SecP160R1FieldElement(nArray2);
            } else {
                object = null;
            }
            return object;
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == secP160R1FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP160R1FieldElement)) {
            return false;
        }
        SecP160R1FieldElement secP160R1FieldElement = secP160R1FieldElement2;
        SecP160R1FieldElement secP160R1FieldElement2 = (SecP160R1FieldElement)object;
        return Nat160.eq(secP160R1FieldElement.x, secP160R1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 5);
    }
}

