/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP224K1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP224K1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP224K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat224;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP224K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP224K1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP224K1_AFFINE_ZS;
    public SecP224K1Point infinity;

    public SecP224K1Curve() {
        SecP224K1Curve secP224K1Curve = this;
        super(q);
        secP224K1Curve.infinity = new SecP224K1Point(this, null, null);
        secP224K1Curve.a = secP224K1Curve.fromBigInteger(ECConstants.ZERO);
        secP224K1Curve.b = secP224K1Curve.fromBigInteger(BigInteger.valueOf(5L));
        secP224K1Curve.order = new BigInteger(1, Hex.decodeStrict("010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7"));
        secP224K1Curve.cofactor = BigInteger.valueOf(1L);
        secP224K1Curve.coord = 2;
    }

    static {
        SecP224K1FieldElement secP224K1FieldElement;
        q = SecP224K1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP224K1FieldElement secP224K1FieldElement2 = secP224K1FieldElement;
        secP224K1FieldElement = new SecP224K1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP224K1FieldElement2;
        SECP224K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP224K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP224K1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP224K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP224K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 7 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat224.copy(((SecP224K1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat224.copy(((SecP224K1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 7);
            n3 += 7;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP224K1FieldElement secP224K1FieldElement;
                SecP224K1FieldElement secP224K1FieldElement2 = secP224K1FieldElement;
                secP224K1FieldElement = new SecP224K1FieldElement(nArray2);
                return secP224K1FieldElement2.SecP224K1Curve.this.createRawPoint(new SecP224K1FieldElement(nArray3), secP224K1FieldElement2, SECP224K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                int[] nArray4 = Nat224.create();
                int[] nArray2 = Nat224.create();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    int n3 = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 7; ++i2) {
                        int[] nArray3 = nArray;
                        nArray4[i2] = nArray4[i2] ^ nArray[n22 + i2] & n3;
                        nArray2[i2] = nArray2[i2] ^ nArray3[n22 + 7 + i2] & n3;
                    }
                    n22 += 14;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                int[] nArray4 = Nat224.create();
                int[] nArray2 = Nat224.create();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    int n3 = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 7; ++i2) {
                        int[] nArray3 = nArray;
                        nArray4[i2] = nArray4[i2] ^ nArray[n22 + i2] & n3;
                        nArray2[i2] = nArray2[i2] ^ nArray3[n22 + 7 + i2] & n3;
                    }
                    n22 += 14;
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat224.create();
        Object object = nArray;
        SecP224K1Field.random(secureRandom, nArray);
        return new SecP224K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat224.create();
        Object object = nArray;
        SecP224K1Field.randomMult(secureRandom, nArray);
        return new SecP224K1FieldElement((int[])object);
    }
}

