/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP256K1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP256K1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F"));
    public int[] x;

    public SecP256K1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP256K1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP256K1FieldElement");
    }

    public SecP256K1FieldElement() {
        this.x = Nat256.create();
    }

    public SecP256K1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat256.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP256K1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP256K1FieldElement secP256K1FieldElement = object;
        Object object = Nat256.create();
        SecP256K1Field.add(secP256K1FieldElement.x, ((SecP256K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP256K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP256K1FieldElement secP256K1FieldElement = object;
        Object object = Nat256.create();
        SecP256K1Field.addOne(secP256K1FieldElement.x, (int[])object);
        return new SecP256K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP256K1FieldElement secP256K1FieldElement = object;
        Object object = Nat256.create();
        SecP256K1Field.subtract(secP256K1FieldElement.x, ((SecP256K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP256K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP256K1FieldElement secP256K1FieldElement = object;
        Object object = Nat256.create();
        SecP256K1Field.multiply(secP256K1FieldElement.x, ((SecP256K1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP256K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256K1Field.inv(((SecP256K1FieldElement)eCFieldElement).x, nArray);
        SecP256K1Field.multiply(nArray, this.x, nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP256K1FieldElement secP256K1FieldElement = object;
        Object object = Nat256.create();
        SecP256K1Field.negate(secP256K1FieldElement.x, (int[])object);
        return new SecP256K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP256K1FieldElement secP256K1FieldElement = object;
        Object object = Nat256.create();
        SecP256K1Field.square(secP256K1FieldElement.x, (int[])object);
        return new SecP256K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP256K1FieldElement secP256K1FieldElement = object;
        Object object = Nat256.create();
        SecP256K1Field.inv(secP256K1FieldElement.x, (int[])object);
        return new SecP256K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = ((SecP256K1FieldElement)object).x;
        if (!Nat256.isZero(((SecP256K1FieldElement)object).x) && !Nat256.isOne(nArray)) {
            int[] nArray2 = nArray;
            int[] nArray3 = Nat256.create();
            Object object = nArray3;
            SecP256K1Field.square(nArray, (int[])object);
            SecP256K1Field.multiply(nArray3, nArray, (int[])object);
            int[] nArray4 = Nat256.create();
            SecP256K1Field.square((int[])object, nArray4);
            SecP256K1Field.multiply(nArray4, nArray, nArray4);
            nArray = Nat256.create();
            Object object2 = object;
            Object object3 = object;
            int[] nArray5 = nArray;
            int[] nArray6 = nArray;
            int[] nArray7 = nArray4;
            SecP256K1Field.squareN(nArray4, 3, nArray);
            SecP256K1Field.multiply(nArray, nArray4, nArray);
            SecP256K1Field.squareN(nArray, 3, nArray);
            SecP256K1Field.multiply(nArray, nArray4, nArray);
            SecP256K1Field.squareN(nArray, 2, nArray);
            SecP256K1Field.multiply(nArray, (int[])object, nArray);
            int[] nArray8 = Nat256.create();
            object = nArray8;
            SecP256K1Field.squareN(nArray, 11, (int[])object);
            SecP256K1Field.multiply(nArray8, nArray, (int[])object);
            SecP256K1Field.squareN(nArray8, 22, nArray);
            SecP256K1Field.multiply(nArray, nArray8, nArray);
            nArray4 = Nat256.create();
            SecP256K1Field.squareN(nArray, 44, nArray4);
            SecP256K1Field.multiply(nArray4, nArray, nArray4);
            int[] nArray9 = Nat256.create();
            SecP256K1Field.squareN(nArray4, 88, nArray9);
            SecP256K1Field.multiply(nArray9, nArray4, nArray9);
            SecP256K1Field.squareN(nArray9, 44, nArray4);
            SecP256K1Field.multiply(nArray4, nArray, nArray4);
            SecP256K1Field.squareN(nArray4, 3, nArray);
            SecP256K1Field.multiply(nArray5, nArray7, nArray);
            SecP256K1Field.squareN(nArray6, 23, nArray);
            SecP256K1Field.multiply(nArray5, (int[])object, nArray);
            SecP256K1Field.squareN(nArray6, 6, nArray);
            SecP256K1Field.multiply(nArray, (int[])object3, nArray);
            SecP256K1Field.squareN(nArray, 2, nArray);
            SecP256K1Field.square(nArray, (int[])object2);
            if (Nat256.eq(nArray2, nArray3)) {
                SecP256K1FieldElement secP256K1FieldElement;
                object = secP256K1FieldElement;
                secP256K1FieldElement = new SecP256K1FieldElement(nArray);
            } else {
                object = null;
            }
            return object;
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == secP256K1FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP256K1FieldElement)) {
            return false;
        }
        SecP256K1FieldElement secP256K1FieldElement = secP256K1FieldElement2;
        SecP256K1FieldElement secP256K1FieldElement2 = (SecP256K1FieldElement)object;
        return Nat256.eq(secP256K1FieldElement.x, secP256K1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 8);
    }
}

