/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT113Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat128;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT113FieldElement
extends ECFieldElement.AbstractF2m {
    public long[] x;

    public SecT113FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.bitLength() <= 113) {
            this.x = SecT113Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecT113FieldElement");
    }

    public SecT113FieldElement() {
        this.x = Nat128.create64();
    }

    public SecT113FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat128.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat128.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat128.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT113Field";
    }

    @Override
    public int getFieldSize() {
        return 113;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecT113FieldElement secT113FieldElement = object;
        Object object = Nat128.create64();
        SecT113Field.add(secT113FieldElement.x, ((SecT113FieldElement)eCFieldElement).x, (long[])object);
        return new SecT113FieldElement((long[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecT113FieldElement secT113FieldElement = object;
        Object object = Nat128.create64();
        SecT113Field.addOne(secT113FieldElement.x, (long[])object);
        return new SecT113FieldElement((long[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecT113FieldElement secT113FieldElement = object;
        Object object = Nat128.create64();
        SecT113Field.multiply(secT113FieldElement.x, ((SecT113FieldElement)eCFieldElement).x, (long[])object);
        return new SecT113FieldElement((long[])object);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
        Object object4 = ((SecT113FieldElement)object4).x;
        object = ((SecT113FieldElement)object).x;
        object2 = ((SecT113FieldElement)object2).x;
        object3 = ((SecT113FieldElement)object3).x;
        long[] lArray = Nat128.createExt64();
        SecT113Field.multiplyAddToExt((long[])object4, (long[])object, lArray);
        SecT113Field.multiplyAddToExt((long[])object2, (long[])object3, lArray);
        long[] lArray2 = Nat128.create64();
        object4 = lArray2;
        SecT113Field.reduce(lArray, lArray2);
        return new SecT113FieldElement((long[])object4);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        SecT113FieldElement secT113FieldElement = object;
        Object object = Nat128.create64();
        SecT113Field.square(secT113FieldElement.x, (long[])object);
        return new SecT113FieldElement((long[])object);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
        Object object3 = ((SecT113FieldElement)object3).x;
        object = ((SecT113FieldElement)object).x;
        object2 = ((SecT113FieldElement)object2).x;
        long[] lArray = Nat128.createExt64();
        SecT113Field.squareAddToExt((long[])object3, lArray);
        SecT113Field.multiplyAddToExt((long[])object, (long[])object2, lArray);
        long[] lArray2 = Nat128.create64();
        object3 = lArray2;
        SecT113Field.reduce(lArray, lArray2);
        return new SecT113FieldElement((long[])object3);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return object;
        }
        SecT113FieldElement secT113FieldElement = object;
        Object object = Nat128.create64();
        SecT113Field.squareN(secT113FieldElement.x, n, (long[])object);
        return new SecT113FieldElement((long[])object);
    }

    @Override
    public ECFieldElement halfTrace() {
        SecT113FieldElement secT113FieldElement = object;
        Object object = Nat128.create64();
        SecT113Field.halfTrace(secT113FieldElement.x, (long[])object);
        return new SecT113FieldElement((long[])object);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT113Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        SecT113FieldElement secT113FieldElement = object;
        Object object = Nat128.create64();
        SecT113Field.invert(secT113FieldElement.x, (long[])object);
        return new SecT113FieldElement((long[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        SecT113FieldElement secT113FieldElement = object;
        Object object = Nat128.create64();
        SecT113Field.sqrt(secT113FieldElement.x, (long[])object);
        return new SecT113FieldElement((long[])object);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 113;
    }

    public int getK1() {
        return 9;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == secT113FieldElement2) {
            return true;
        }
        if (!(object instanceof SecT113FieldElement)) {
            return false;
        }
        SecT113FieldElement secT113FieldElement = secT113FieldElement2;
        SecT113FieldElement secT113FieldElement2 = (SecT113FieldElement)object;
        return Nat128.eq64(secT113FieldElement.x, secT113FieldElement2.x);
    }

    public int hashCode() {
        return Arrays.hashCode(this.x, 0, 2) ^ 0x1B971;
    }
}

