/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT193FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT193R2Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT193R2Curve
extends ECCurve.AbstractF2m {
    private static final int SECT193R2_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT193R2_AFFINE_ZS;
    public SecT193R2Point infinity;

    public SecT193R2Curve() {
        SecT193R2Curve secT193R2Curve = this;
        super(193, 15, 0, 0);
        secT193R2Curve.infinity = new SecT193R2Point(this, null, null);
        secT193R2Curve.a = secT193R2Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("0163F35A5137C2CE3EA6ED8667190B0BC43ECD69977702709B")));
        secT193R2Curve.b = secT193R2Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("00C9BB9E8927D4D64C377E2AB2856A5B16E3EFB7F61D4316AE")));
        secT193R2Curve.order = new BigInteger(1, Hex.decodeStrict("010000000000000000000000015AAB561B005413CCD4EE99D5"));
        secT193R2Curve.cofactor = BigInteger.valueOf(2L);
        secT193R2Curve.coord = 6;
    }

    static {
        SecT193FieldElement secT193FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT193FieldElement secT193FieldElement2 = secT193FieldElement;
        secT193FieldElement = new SecT193FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT193FieldElement2;
        SECT193R2_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT193R2Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 6;
    }

    @Override
    public int getFieldSize() {
        return 193;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT193FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT193R2Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT193R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 193;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 15;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final long[] lArray = new long[n2 * 4 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat256.copy64(((SecT193FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat256.copy64(((SecT193FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 4);
            n3 += 4;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT193FieldElement secT193FieldElement;
                SecT193FieldElement secT193FieldElement2 = secT193FieldElement;
                secT193FieldElement = new SecT193FieldElement(lArray2);
                return secT193FieldElement2.SecT193R2Curve.this.createRawPoint(new SecT193FieldElement(lArray3), secT193FieldElement2, SECT193R2_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                long[] lArray4 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    long l = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        long[] lArray3 = lArray;
                        lArray4[i2] = lArray4[i2] ^ lArray[n22 + i2] & l;
                        lArray2[i2] = lArray2[i2] ^ lArray3[n22 + 4 + i2] & l;
                    }
                    n22 += 8;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                long[] lArray4 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n22 = n * 4 * 2;
                for (int k = 0; k < 4; ++k) {
                    long[] lArray3 = lArray;
                    lArray4[k] = lArray4[k] ^ lArray[n22 + k];
                    lArray2[k] = lArray2[k] ^ lArray3[n22 + 4 + k];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

