/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WTauNafMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT239FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT239K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT239K1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT239K1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT239K1_AFFINE_ZS;
    public SecT239K1Point infinity;

    public SecT239K1Curve() {
        SecT239K1Curve secT239K1Curve = this;
        super(239, 158, 0, 0);
        secT239K1Curve.infinity = new SecT239K1Point(this, null, null);
        secT239K1Curve.a = secT239K1Curve.fromBigInteger(BigInteger.valueOf(0L));
        secT239K1Curve.b = secT239K1Curve.fromBigInteger(BigInteger.valueOf(1L));
        secT239K1Curve.order = new BigInteger(1, Hex.decodeStrict("2000000000000000000000000000005A79FEC67CB6E91F1C1DA800E478A5"));
        secT239K1Curve.cofactor = BigInteger.valueOf(4L);
        secT239K1Curve.coord = 6;
    }

    static {
        SecT239FieldElement secT239FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT239FieldElement secT239FieldElement2 = secT239FieldElement;
        secT239FieldElement = new SecT239FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT239FieldElement2;
        SECT239K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT239K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 6;
    }

    @Override
    public ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 239;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT239FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT239K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT239K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 239;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 158;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final long[] lArray = new long[n2 * 4 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat256.copy64(((SecT239FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat256.copy64(((SecT239FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 4);
            n3 += 4;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT239FieldElement secT239FieldElement;
                SecT239FieldElement secT239FieldElement2 = secT239FieldElement;
                secT239FieldElement = new SecT239FieldElement(lArray2);
                return secT239FieldElement2.SecT239K1Curve.this.createRawPoint(new SecT239FieldElement(lArray3), secT239FieldElement2, SECT239K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                long[] lArray4 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    long l = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        long[] lArray3 = lArray;
                        lArray4[i2] = lArray4[i2] ^ lArray[n22 + i2] & l;
                        lArray2[i2] = lArray2[i2] ^ lArray3[n22 + 4 + i2] & l;
                    }
                    n22 += 8;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                long[] lArray4 = Nat256.create64();
                long[] lArray2 = Nat256.create64();
                int n22 = n * 4 * 2;
                for (int k = 0; k < 4; ++k) {
                    long[] lArray3 = lArray;
                    lArray4[k] = lArray3[n22 + k];
                    lArray2[k] = lArray[n22 + 4 + k];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

