/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WTauNafMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT571K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat576;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT571K1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT571K1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT571K1_AFFINE_ZS;
    public SecT571K1Point infinity;

    public SecT571K1Curve() {
        SecT571K1Curve secT571K1Curve = this;
        super(571, 2, 5, 10);
        secT571K1Curve.infinity = new SecT571K1Point(this, null, null);
        secT571K1Curve.a = secT571K1Curve.fromBigInteger(BigInteger.valueOf(0L));
        secT571K1Curve.b = secT571K1Curve.fromBigInteger(BigInteger.valueOf(1L));
        secT571K1Curve.order = new BigInteger(1, Hex.decodeStrict("020000000000000000000000000000000000000000000000000000000000000000000000131850E1F19A63E4B391A8DB917F4138B630D84BE5D639381E91DEB45CFE778F637C1001"));
        secT571K1Curve.cofactor = BigInteger.valueOf(4L);
        secT571K1Curve.coord = 6;
    }

    static {
        SecT571FieldElement secT571FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT571FieldElement secT571FieldElement2 = secT571FieldElement;
        secT571FieldElement = new SecT571FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT571FieldElement2;
        SECT571K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT571K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 6;
    }

    @Override
    public ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 571;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT571FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT571K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT571K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final long[] lArray = new long[n2 * 9 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 9);
            n3 += 9;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT571FieldElement secT571FieldElement;
                SecT571FieldElement secT571FieldElement2 = secT571FieldElement;
                secT571FieldElement = new SecT571FieldElement(lArray2);
                return secT571FieldElement2.SecT571K1Curve.this.createRawPoint(new SecT571FieldElement(lArray3), secT571FieldElement2, SECT571K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                long[] lArray4 = Nat576.create64();
                long[] lArray2 = Nat576.create64();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    long l = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 9; ++i2) {
                        long[] lArray3 = lArray;
                        lArray4[i2] = lArray4[i2] ^ lArray[n22 + i2] & l;
                        lArray2[i2] = lArray2[i2] ^ lArray3[n22 + 9 + i2] & l;
                    }
                    n22 += 18;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                long[] lArray4 = Nat576.create64();
                long[] lArray2 = Nat576.create64();
                int n22 = n * 9 * 2;
                for (int k = 0; k < 9; ++k) {
                    long[] lArray3 = lArray;
                    lArray4[k] = lArray3[n22 + k];
                    lArray2[k] = lArray[n22 + 9 + k];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

