/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecT571R1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat576;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT571R1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT571R1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT571R1_AFFINE_ZS;
    public static final SecT571FieldElement SecT571R1_B;
    public static final SecT571FieldElement SecT571R1_B_SQRT;
    public SecT571R1Point infinity;

    public SecT571R1Curve() {
        SecT571R1Curve secT571R1Curve = this;
        super(571, 2, 5, 10);
        secT571R1Curve.infinity = new SecT571R1Point(this, null, null);
        secT571R1Curve.a = secT571R1Curve.fromBigInteger(BigInteger.valueOf(1L));
        secT571R1Curve.b = SecT571R1_B;
        secT571R1Curve.order = new BigInteger(1, Hex.decodeStrict("03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE661CE18FF55987308059B186823851EC7DD9CA1161DE93D5174D66E8382E9BB2FE84E47"));
        secT571R1Curve.cofactor = BigInteger.valueOf(2L);
        secT571R1Curve.coord = 6;
    }

    static {
        SecT571FieldElement secT571FieldElement;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecT571FieldElement secT571FieldElement2 = secT571FieldElement;
        secT571FieldElement = new SecT571FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secT571FieldElement2;
        SECT571R1_AFFINE_ZS = eCFieldElementArray;
        SecT571R1_B = new SecT571FieldElement(new BigInteger(1, Hex.decodeStrict("02F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E294AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727A")));
        SecT571R1_B_SQRT = (SecT571FieldElement)SecT571R1_B.sqrt();
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecT571R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        return n == 6;
    }

    @Override
    public int getFieldSize() {
        return 571;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT571FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT571R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT571R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final long[] lArray = new long[n2 * 9 * 2];
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            ECPoint eCPoint = eCPointArray[n + k];
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 9);
            n3 += 9;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                SecT571FieldElement secT571FieldElement;
                SecT571FieldElement secT571FieldElement2 = secT571FieldElement;
                secT571FieldElement = new SecT571FieldElement(lArray2);
                return secT571FieldElement2.SecT571R1Curve.this.createRawPoint(new SecT571FieldElement(lArray3), secT571FieldElement2, SECT571R1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n2;
            }

            @Override
            public ECPoint lookup(int n) {
                long[] lArray4 = Nat576.create64();
                long[] lArray2 = Nat576.create64();
                int n22 = 0;
                for (int k = 0; k < n2; ++k) {
                    long l = (k ^ n) - 1 >> 31;
                    for (int i2 = 0; i2 < 9; ++i2) {
                        long[] lArray3 = lArray;
                        lArray4[i2] = lArray4[i2] ^ lArray[n22 + i2] & l;
                        lArray2[i2] = lArray2[i2] ^ lArray3[n22 + 9 + i2] & l;
                    }
                    n22 += 18;
                }
                return this.createPoint(lArray4, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n) {
                long[] lArray4 = Nat576.create64();
                long[] lArray2 = Nat576.create64();
                int n22 = n * 9 * 2;
                for (int k = 0; k < 9; ++k) {
                    long[] lArray3 = lArray;
                    lArray4[k] = lArray3[n22 + k];
                    lArray2[k] = lArray[n22 + 9 + k];
                }
                return this.createPoint(lArray4, lArray2);
            }
        };
    }
}

