/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X448Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed448;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public abstract class X448 {
    public static final int POINT_SIZE = 56;
    public static final int SCALAR_SIZE = 56;
    private static final int C_A = 156326;
    private static final int C_A24 = 39082;

    public static boolean calculateAgreement(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3) {
        X448.scalarMult(byArray, n, byArray2, n2, byArray3, n3);
        return Arrays.areAllZeroes(byArray3, n3, 56) ^ true;
    }

    private static int decode32(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        n = n + 1;
        return n2 | (byArray[n] & 0xFF) << 8 | (byArray[++n] & 0xFF) << 16 | byArray[n + 1] << 24;
    }

    private static void decodeScalar(byte[] byArray, int n, int[] nArray) {
        for (int k = 0; k < 14; ++k) {
            nArray[k] = X448.decode32(byArray, k * 4 + n);
        }
        int[] nArray2 = nArray;
        nArray2[0] = nArray[0] & 0xFFFFFFFC;
        nArray2[13] = nArray[13] | Integer.MIN_VALUE;
    }

    public static void generatePrivateKey(SecureRandom secureRandom, byte[] byArray) {
        byte[] byArray2 = byArray;
        secureRandom.nextBytes(byArray);
        byArray2[0] = (byte)(byArray[0] & 0xFC);
        byArray2[55] = (byte)(byArray[55] | 0x80);
    }

    public static void generatePublicKey(byte[] byArray, int n, byte[] byArray2, int n2) {
        X448.scalarMultBase(byArray, n, byArray2, n2);
    }

    private static void pointDouble(int[] nArray, int[] nArray2) {
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        X448Field.add(nArray, nArray2, nArray3);
        X448Field.sub(nArray, nArray2, nArray4);
        X448Field.sqr(nArray3, nArray3);
        X448Field.sqr(nArray4, nArray4);
        X448Field.mul(nArray3, nArray4, nArray);
        X448Field.sub(nArray3, nArray4, nArray3);
        X448Field.mul(nArray3, 39082, nArray2);
        X448Field.add(nArray2, nArray4, nArray2);
        X448Field.mul(nArray2, nArray3, nArray2);
    }

    public static void precompute() {
        Ed448.precompute();
    }

    public static void scalarMult(byte[] objectArray, int n, byte[] objectArray2, int n2, byte[] byArray, int n3) {
        byte[] byArray2 = objectArray;
        objectArray = new int[14];
        X448.decodeScalar(byArray2, n, objectArray);
        int[] nArray = X448Field.create();
        X448Field.decode(objectArray2, n2, nArray);
        objectArray2 = X448Field.create();
        X448Field.copy(nArray, 0, objectArray2, 0);
        int[] nArray2 = X448Field.create();
        int[] nArray3 = nArray2;
        nArray2[0] = 1;
        int[] nArray4 = X448Field.create();
        int[] nArray5 = nArray4;
        nArray4[0] = 1;
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        int[] nArray8 = X448Field.create();
        int n4 = 447;
        int n5 = 1;
        do {
            Object[] objectArray3 = objectArray2;
            X448Field.add(nArray5, nArray6, nArray7);
            X448Field.sub(nArray5, nArray6, nArray5);
            X448Field.add(objectArray2, nArray3, nArray6);
            X448Field.sub(objectArray2, nArray3, objectArray2);
            X448Field.mul(nArray7, objectArray2, nArray7);
            X448Field.mul(nArray5, nArray6, nArray5);
            X448Field.sqr(nArray6, nArray6);
            X448Field.sqr(objectArray3, objectArray3);
            X448Field.sub(nArray6, objectArray2, nArray8);
            X448Field.mul(nArray8, 39082, nArray3);
            X448Field.add(nArray3, objectArray2, nArray3);
            X448Field.mul(nArray3, nArray8, nArray3);
            X448Field.mul((int[])objectArray2, nArray6, (int[])objectArray2);
            X448Field.sub(nArray7, nArray5, nArray6);
            X448Field.add(nArray7, nArray5, nArray5);
            X448Field.sqr(nArray5, nArray5);
            X448Field.sqr(nArray6, nArray6);
            X448Field.mul(nArray6, nArray, nArray6);
            int n6 = n5;
            int n7 = n4 += -1;
            n5 = n7 >>> 5;
            int n8 = n7 & 0x1F;
            n5 = objectArray[n5] >>> n8 & 1;
            int n9 = n6 ^ n5;
            X448Field.cswap(n9, objectArray2, nArray5);
            X448Field.cswap(n9, nArray3, nArray6);
        } while (n4 >= 2);
        for (int k = 0; k < 2; ++k) {
            X448.pointDouble(objectArray2, nArray3);
        }
        Object[] objectArray4 = objectArray2;
        X448Field.inv(nArray3, nArray3);
        X448Field.mul((int[])objectArray4, nArray3, (int[])objectArray2);
        X448Field.normalize(objectArray4);
        X448Field.encode((int[])objectArray2, byArray, n3);
    }

    public static void scalarMultBase(byte[] byArray, int n, byte[] objectArray, int n2) {
        int[] nArray = X448Field.create();
        byte[] byArray2 = objectArray;
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        objectArray = X448Field.create();
        Ed448.scalarMultBaseXY(Friend.INSTANCE, byArray, n, nArray, objectArray);
        X448Field.inv(nArray3, nArray2);
        X448Field.mul(nArray2, objectArray, nArray);
        X448Field.sqr(nArray2, nArray3);
        X448Field.normalize(nArray3);
        X448Field.encode(nArray, byArray2, n2);
    }

    public static class F
    extends X448Field {
        private F() {
        }
    }

    public static class Friend {
        private static final Friend INSTANCE = new Friend();

        private Friend() {
        }
    }
}

