/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;

public abstract class Mont256 {
    private static final long M = 0xFFFFFFFFL;

    public static int inverse32(int n) {
        int n2 = n;
        n = (2 - n2 * n2) * n;
        n = (2 - n2 * n) * n;
        n = (2 - n2 * n) * n;
        return (2 - n2 * n) * n;
    }

    public static void multAdd(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
        int n2 = 0;
        long l = (long)nArray2[0] & 0xFFFFFFFFL;
        for (int k = 0; k < 8; ++k) {
            long l2 = (long)nArray3[0] & 0xFFFFFFFFL;
            long l3 = (long)nArray[k] & 0xFFFFFFFFL;
            long l4 = l3 * l;
            long l5 = (l4 & 0xFFFFFFFFL) + l2;
            l2 = (long)((int)l5 * n) & 0xFFFFFFFFL;
            long l6 = l2 * ((long)nArray4[0] & 0xFFFFFFFFL);
            l4 = (l5 + (l6 & 0xFFFFFFFFL) >>> 32) + (l4 >>> 32) + (l6 >>> 32);
            for (int i2 = 1; i2 < 8; ++i2) {
                long l7 = l3 * ((long)nArray2[i2] & 0xFFFFFFFFL);
                long l8 = l2 * ((long)nArray4[i2] & 0xFFFFFFFFL);
                l4 = (l7 & 0xFFFFFFFFL) + (l8 & 0xFFFFFFFFL) + ((long)nArray3[i2] & 0xFFFFFFFFL) + l4;
                int n3 = i2 - 1;
                nArray3[n3] = (int)l4;
                l4 = (l4 >>> 32) + (l7 >>> 32) + (l8 >>> 32);
            }
            l2 = l4 + ((long)n2 & 0xFFFFFFFFL);
            nArray3[7] = (int)l2;
            n2 = (int)(l2 >>> 32);
        }
        if (n2 != 0 || Nat256.gte(nArray3, nArray4)) {
            Nat256.sub(nArray3, nArray4, nArray3);
        }
    }

    public static void multAddXF(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = 0;
        long l = (long)nArray2[0] & 0xFFFFFFFFL;
        for (int k = 0; k < 8; ++k) {
            long l2 = (long)nArray[k] & 0xFFFFFFFFL;
            long l3 = l2 * l + ((long)nArray3[0] & 0xFFFFFFFFL);
            long l4 = l3 & 0xFFFFFFFFL;
            long l5 = (l3 >>> 32) + l4;
            for (int i2 = 1; i2 < 8; ++i2) {
                long l6 = l2 * ((long)nArray2[i2] & 0xFFFFFFFFL);
                long l7 = l4 * ((long)nArray4[i2] & 0xFFFFFFFFL);
                l5 = (l6 & 0xFFFFFFFFL) + (l7 & 0xFFFFFFFFL) + ((long)nArray3[i2] & 0xFFFFFFFFL) + l5;
                int n2 = i2 - 1;
                nArray3[n2] = (int)l5;
                l5 = (l5 >>> 32) + (l6 >>> 32) + (l7 >>> 32);
            }
            l2 = l5 + ((long)n & 0xFFFFFFFFL);
            nArray3[7] = (int)l2;
            n = (int)(l2 >>> 32);
        }
        if (n != 0 || Nat256.gte(nArray3, nArray4)) {
            Nat256.sub(nArray3, nArray4, nArray3);
        }
    }

    public static void reduce(int[] nArray, int[] nArray2, int n) {
        for (int k = 0; k < 8; ++k) {
            int n2 = nArray[0];
            long l = (long)(n2 * n) & 0xFFFFFFFFL;
            long l2 = l * ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) >>> 32;
            for (n2 = 1; n2 < 8; ++n2) {
                l2 = l * ((long)nArray2[n2] & 0xFFFFFFFFL) + ((long)nArray[n2] & 0xFFFFFFFFL) + l2;
                int n3 = n2 - 1;
                nArray[n3] = (int)l2;
                l2 >>>= 32;
            }
            nArray[7] = (int)l2;
        }
        if (Nat256.gte(nArray, nArray2)) {
            Nat256.sub(nArray, nArray2, nArray);
        }
    }

    public static void reduceXF(int[] nArray, int[] nArray2) {
        for (int k = 0; k < 8; ++k) {
            long l = (long)nArray[0] & 0xFFFFFFFFL;
            long l2 = l;
            for (int i2 = 1; i2 < 8; ++i2) {
                l2 = l * ((long)nArray2[i2] & 0xFFFFFFFFL) + ((long)nArray[i2] & 0xFFFFFFFFL) + l2;
                int n = i2 - 1;
                nArray[n] = (int)l2;
                l2 >>>= 32;
            }
            nArray[7] = (int)l2;
        }
        if (Nat256.gte(nArray, nArray2)) {
            Nat256.sub(nArray, nArray2, nArray);
        }
    }
}

