/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;

public class XMSSMTPrivateKey
extends ASN1Object {
    private final int version;
    private final long index;
    private final long maxIndex;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final byte[] bdsState;

    public XMSSMTPrivateKey(long l, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        XMSSMTPrivateKey xMSSMTPrivateKey = this;
        this.version = 0;
        this.index = l;
        this.secretKeySeed = Arrays.clone(byArray);
        this.secretKeyPRF = Arrays.clone(byArray2);
        this.publicSeed = Arrays.clone(byArray3);
        this.root = Arrays.clone(byArray4);
        xMSSMTPrivateKey.bdsState = Arrays.clone(byArray5);
        xMSSMTPrivateKey.maxIndex = -1L;
    }

    public XMSSMTPrivateKey(long l, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, long l2) {
        this.version = 1;
        this.index = l;
        this.secretKeySeed = Arrays.clone(byArray);
        this.secretKeyPRF = Arrays.clone(byArray2);
        this.publicSeed = Arrays.clone(byArray3);
        this.root = Arrays.clone(byArray4);
        this.bdsState = Arrays.clone(byArray5);
        this.maxIndex = l2;
    }

    private XMSSMTPrivateKey(ASN1Sequence aSN1Sequence) {
        block8: {
            block7: {
                ASN1Primitive aSN1Primitive;
                block5: {
                    block6: {
                        aSN1Primitive = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
                        if (!((ASN1Integer)aSN1Primitive).hasValue(BigIntegers.ZERO) && !((ASN1Integer)aSN1Primitive).hasValue(BigIntegers.ONE)) {
                            throw new IllegalArgumentException("unknown version of sequence");
                        }
                        this.version = ((ASN1Integer)aSN1Primitive).intValueExact();
                        if (aSN1Sequence.size() != 2 && aSN1Sequence.size() != 3) {
                            throw new IllegalArgumentException("key sequence wrong size");
                        }
                        aSN1Primitive = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
                        this.index = ASN1Integer.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(0)).longValueExact();
                        this.secretKeySeed = a.a((ASN1Sequence)aSN1Primitive, 1);
                        this.secretKeyPRF = a.a((ASN1Sequence)aSN1Primitive, 2);
                        this.publicSeed = a.a((ASN1Sequence)aSN1Primitive, 3);
                        this.root = a.a((ASN1Sequence)aSN1Primitive, 4);
                        if (((ASN1Sequence)aSN1Primitive).size() != 6) break block5;
                        if (((ASN1TaggedObject)(aSN1Primitive = ASN1TaggedObject.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(5)))).getTagNo() != 0) break block6;
                        this.maxIndex = ASN1Integer.getInstance((ASN1TaggedObject)aSN1Primitive, false).longValueExact();
                        break block7;
                    }
                    throw new IllegalArgumentException("unknown tag in XMSSPrivateKey");
                }
                if (((ASN1Sequence)aSN1Primitive).size() != 5) break block8;
                this.maxIndex = -1L;
            }
            this.bdsState = (byte[])(aSN1Sequence.size() == 3 ? Arrays.clone(ASN1OctetString.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(2)), true).getOctets()) : null);
            return;
        }
        throw new IllegalArgumentException("keySeq should be 5 or 6 in length");
    }

    public static XMSSMTPrivateKey getInstance(Object object) {
        if (object instanceof XMSSMTPrivateKey) {
            return (XMSSMTPrivateKey)object;
        }
        if (object != null) {
            return new XMSSMTPrivateKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    public long getIndex() {
        return this.index;
    }

    public long getMaxIndex() {
        return this.maxIndex;
    }

    public byte[] getSecretKeySeed() {
        return Arrays.clone(this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return Arrays.clone(this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.publicSeed);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.root);
    }

    public byte[] getBdsState() {
        return Arrays.clone(this.bdsState);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DEROctetString dEROctetString;
        ASN1EncodableVector aSN1EncodableVector;
        Object object;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
        aSN1EncodableVector2 = new ASN1EncodableVector();
        if (this.maxIndex >= 0L) {
            ASN1Integer aSN1Integer;
            object = aSN1Integer;
            aSN1Integer = new ASN1Integer(1L);
            aSN1EncodableVector3.add((ASN1Encodable)object);
        } else {
            ASN1Integer aSN1Integer;
            object = aSN1Integer;
            aSN1Integer = new ASN1Integer(0L);
            aSN1EncodableVector3.add((ASN1Encodable)object);
        }
        object = aSN1EncodableVector;
        new ASN1EncodableVector().add(new ASN1Integer(this.index));
        ((ASN1EncodableVector)object).add(new DEROctetString(this.secretKeySeed));
        ((ASN1EncodableVector)object).add(new DEROctetString(this.secretKeyPRF));
        ((ASN1EncodableVector)object).add(new DEROctetString(this.publicSeed));
        ((ASN1EncodableVector)object).add(new DEROctetString(this.root));
        long l = this.maxIndex;
        if (l >= 0L) {
            ASN1Integer aSN1Integer;
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            ASN1Integer aSN1Integer2 = aSN1Integer;
            aSN1Integer = new ASN1Integer(l);
            dERTaggedObject = new DERTaggedObject(false, 0, aSN1Integer2);
            ((ASN1EncodableVector)object).add(dERTaggedObject2);
        }
        ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector3;
        aSN1EncodableVector4.add(new DERSequence((ASN1EncodableVector)object));
        object = dEROctetString;
        dEROctetString = new DEROctetString(this.bdsState);
        aSN1EncodableVector4.add(new DERTaggedObject(true, 0, (ASN1Encodable)object));
        return new DERSequence(aSN1EncodableVector3);
    }
}

