/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.EncapsulatedSecretExtractor;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;

public class CMCEKEMExtractor
implements EncapsulatedSecretExtractor {
    private CMCEEngine engine;
    private CMCEKeyParameters key;

    public CMCEKEMExtractor(CMCEPrivateKeyParameters cMCEPrivateKeyParameters) {
        this.key = cMCEPrivateKeyParameters;
        this.initCipher(cMCEPrivateKeyParameters.getParameters());
    }

    private void initCipher(CMCEParameters cipherParameters) {
        this.engine = ((CMCEParameters)cipherParameters).getEngine();
        cipherParameters = (CMCEPrivateKeyParameters)this.key;
        if (((CMCEPrivateKeyParameters)cipherParameters).getPrivateKey().length < this.engine.getPrivateKeySize()) {
            this.key = new CMCEPrivateKeyParameters(((CMCEKeyParameters)cipherParameters).getParameters(), this.engine.decompress_private_key(((CMCEPrivateKeyParameters)cipherParameters).getPrivateKey()));
        }
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        return this.extractSecret(byArray, this.engine.getDefaultSessionKeySize());
    }

    public byte[] extractSecret(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n / 8];
        this.engine.kem_dec(byArray2, byArray, ((CMCEPrivateKeyParameters)this.key).getPrivateKey());
        return byArray2;
    }

    public int getInputSize() {
        return this.engine.getCipherTextSize();
    }
}

