/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo.FrodoMatrixGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.security.SecureRandom;

class FrodoEngine {
    private static final int nbar = 8;
    private static final int mbar = 8;
    private static final int len_seedA = 128;
    private static final int len_z = 128;
    private static final int len_chi = 16;
    private static final int len_seedA_bytes = 16;
    private static final int len_z_bytes = 16;
    private static final int len_chi_bytes = 2;
    private final int D;
    private final int q;
    private final int n;
    private final int B;
    private final int len_sk_bytes;
    private final int len_pk_bytes;
    private final int len_ct_bytes;
    private final short[] T_chi;
    private final int len_mu;
    private final int len_seedSE;
    private final int len_s;
    private final int len_k;
    private final int len_pkh;
    private final int len_ss;
    private final int len_mu_bytes;
    private final int len_seedSE_bytes;
    private final int len_s_bytes;
    private final int len_k_bytes;
    private final int len_pkh_bytes;
    private final int len_ss_bytes;
    private final Xof digest;
    private final FrodoMatrixGenerator gen;

    public FrodoEngine(int n, int n2, int n3, short[] sArray, Xof xof, FrodoMatrixGenerator frodoMatrixGenerator) {
        int n4;
        int n5 = n;
        FrodoEngine frodoEngine = this;
        this.n = n;
        frodoEngine.D = n2;
        frodoEngine.q = 1 << n2;
        this.B = n3;
        this.len_mu = n3 = n3 * 8 * 8;
        this.len_seedSE = n3;
        this.len_s = n3;
        this.len_k = n3;
        this.len_pkh = n3;
        this.len_ss = n3;
        this.len_mu_bytes = n3 / 8;
        this.len_seedSE_bytes = n3 / 8;
        int n6 = n3 / 8;
        FrodoEngine frodoEngine2 = this;
        int n7 = n2;
        this.len_s_bytes = n6;
        this.len_k_bytes = n3 / 8;
        this.len_pkh_bytes = n4 = n3 / 8;
        this.len_ss_bytes = n3 / 8;
        n = n7 * n * 8 / 8;
        frodoEngine2.len_ct_bytes = n7 * 8 * 8 / 8 + n;
        frodoEngine2.len_pk_bytes = n += 16;
        n = n6 + n;
        this.len_sk_bytes = n5 * 2 * 8 + n4 + n;
        this.T_chi = sArray;
        this.digest = xof;
        this.gen = frodoMatrixGenerator;
    }

    private short sample(short s) {
        int n = s & 0xFFFF;
        s = (short)n;
        short s2 = (short)(n >>> 1);
        short s3 = 0;
        int n2 = 0;
        while (true) {
            short[] sArray = this.T_chi;
            if (n2 >= this.T_chi.length) break;
            if (s2 > sArray[n2]) {
                s3 = (short)(s3 + 1);
            }
            ++n2;
        }
        if (s % 2 == 1) {
            s3 = (short)(s3 * -1 & 0xFFFF);
        }
        return s3;
    }

    private short[] sample_matrix(short[] sArray, int n, int n2, int n3) {
        short[] sArray2 = new short[n2 * n3];
        for (int k = 0; k < n2; ++k) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = k * n3 + i2;
                sArray2[n4] = this.sample(sArray[n4 + n]);
            }
        }
        return sArray2;
    }

    private short[] matrix_transpose(short[] sArray, int n, int n2) {
        Object object = new short[n * n2];
        for (int k = 0; k < n2; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                int n3 = k * n + i2;
                object[n3] = sArray[i2 * n2 + k];
            }
        }
        return object;
    }

    private short[] matrix_mul(short[] sArray, int n, int n2, short[] sArray2, int n3, int n4) {
        short[] sArray3 = new short[n * n4];
        for (int k = 0; k < n; ++k) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5;
                for (n5 = 0; n5 < n2; ++n5) {
                    int n6 = k * n4 + i2;
                    int n7 = sArray3[n6] & 0xFFFF;
                    sArray3[n6] = (short)((sArray[k * n2 + n5] & 0xFFFF) * (sArray2[n5 * n4 + i2] & 0xFFFF) + n7 & 0xFFFF);
                }
                n5 = k * n4 + i2;
                sArray3[n5] = (short)((sArray3[n5] & 0xFFFF) % this.q & 0xFFFF);
            }
        }
        return sArray3;
    }

    private short[] matrix_add(short[] sArray, short[] sArray2, int n, int n2) {
        short[] sArray3 = new short[n * n2];
        for (int k = 0; k < n; ++k) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = k * n2 + i2;
                sArray3[n3] = (short)(((sArray[n3] & 0xFFFF) + (sArray2[n3] & 0xFFFF)) % this.q);
            }
        }
        return sArray3;
    }

    private byte[] pack(short[] sArray) {
        int n = sArray.length;
        int n2 = this.D * n / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n3 < n2 && (n4 < n || n4 == n && n6 > 0)) {
            int n7 = 0;
            while (n7 < 8) {
                int n8 = n6;
                int n9 = 8 - n7;
                n6 = Math.min(n9, n6);
                short s = (short)((1 << n6) - 1);
                int n10 = n8 - n6;
                int n11 = n7;
                n7 = (byte)(n5 >> n10 & s);
                byArray[n3] = (byte)(byArray[n3] + (n7 << n9 - n6));
                n7 = (byte)(n11 + n6);
                byte by = (byte)n10;
                n6 = by;
                if (by != 0) continue;
                if (n4 >= n) break;
                int n12 = n4;
                n5 = sArray[n4];
                n4 = (byte)this.D;
                n6 = (short)(n12 + 1);
                int n13 = n4;
                n4 = n6;
                n6 = n13;
            }
            if (n7 != 8) continue;
            n3 = (short)(n3 + 1);
        }
        return byArray;
    }

    private short[] unpack(byte[] byArray, int n, int n2) {
        short[] sArray = new short[n *= n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n3 < n && (n4 < byArray.length || n4 == byArray.length && n6 > 0)) {
            int n7;
            int n8 = 0;
            while (n8 < (n7 = this.D)) {
                int n9 = n6;
                n7 = Math.min(n7 - n8, n6);
                short s = (short)((1 << n7) - 1 & 0xFFFF);
                n6 = (byte)((n5 & 0xFF) >>> (n6 & 0xFF) - n7 & (s & 0xFFFF) & 0xFF);
                sArray[n3] = (short)((sArray[n3] & 0xFFFF) + ((n6 & 0xFF) << this.D - (n8 & 0xFF) - n7) & 0xFFFF);
                n8 = (byte)(n8 + n7);
                byte by = (byte)(n9 - n7);
                n6 = by;
                n5 = (byte)(n5 & ~(s << n6));
                if (by != 0) continue;
                if (n4 >= byArray.length) break;
                int n10 = n4;
                n4 = byArray[n4];
                n5 = 8;
                n6 = (short)(n10 + 1);
                int n11 = n4;
                n4 = n6;
                n6 = n5;
                n5 = n11;
            }
            if (n8 != this.D) continue;
            n3 = (short)(n3 + 1);
        }
        return sArray;
    }

    private short[] encode(byte[] byArray) {
        int n = 0;
        int n2 = 1;
        short[] sArray = new short[64];
        for (int k = 0; k < 8; ++k) {
            for (int i2 = 0; i2 < 8; ++i2) {
                int n3;
                int n4 = 0;
                for (int i3 = 0; i3 < (n3 = this.B); ++i3) {
                    if ((byArray[n] & n2) == n2) {
                        n4 += 1 << i3;
                    }
                    byte by = (byte)(n2 << 1);
                    n2 = by;
                    if (by != 0) continue;
                    n2 = 1;
                    ++n;
                }
                sArray[k * 8 + i2] = (short)(this.q / (1 << n3) * n4);
            }
        }
        return sArray;
    }

    private short[] matrix_sub(short[] sArray, short[] sArray2, int n, int n2) {
        short[] sArray3 = new short[n * n2];
        for (int k = 0; k < n; ++k) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = k * n2 + i2;
                sArray3[n3] = (short)((sArray[n3] - sArray2[n3] & 0xFFFF) % this.q);
            }
        }
        return sArray3;
    }

    private byte[] decode(short[] sArray) {
        int n = 0;
        int n2 = 8;
        int n3 = 8;
        int n4 = this.B;
        int n5 = n4;
        n5 = (short)((1 << n5) - 1);
        short s = (short)((1 << this.D) - 1);
        byte[] byArray = new byte[n4 * n2];
        for (int k = 0; k < n3; ++k) {
            int n6;
            int n7;
            long l = 0L;
            for (n7 = 0; n7 < n2; ++n7) {
                int n8 = this.D;
                int n9 = this.B;
                l |= (long)((short)((sArray[n] & s) + (1 << n8 - n9 - 1) >> n8 - n9) & n5) << n9 * n7;
                ++n;
            }
            for (n7 = 0; n7 < (n6 = this.B); ++n7) {
                n6 = k * n6 + n7;
                byArray[n6] = (byte)(l >> n7 * 8 & 0xFFL);
            }
        }
        return byArray;
    }

    private short ctverify(short[] sArray, short[] sArray2, short[] sArray3, short[] sArray4) {
        int n = 0;
        for (int n2 = 0; n2 < sArray.length; n2 = (int)((short)(n2 + 1))) {
            n = (short)(n | sArray[n2] ^ sArray3[n2]);
        }
        for (int n3 = 0; n3 < sArray2.length; n3 = (int)((short)(n3 + 1))) {
            n = (short)(n | sArray2[n3] ^ sArray4[n3]);
        }
        if (n == 0) {
            return 0;
        }
        return -1;
    }

    private byte[] ctselect(byte[] byArray, byte[] byArray2, short s) {
        Object object = new byte[byArray.length];
        for (int k = 0; k < byArray.length; ++k) {
            object[k] = (byte)(~s & byArray[k] & 0xFF | s & byArray2[k] & 0xFF);
        }
        return object;
    }

    public int getCipherTextSize() {
        return this.len_ct_bytes;
    }

    public int getSessionKeySize() {
        return this.len_ss_bytes;
    }

    public int getPrivateKeySize() {
        return this.len_sk_bytes;
    }

    public int getPublicKeySize() {
        return this.len_pk_bytes;
    }

    public void kem_keypair(byte[] byArray, byte[] byArray2, SecureRandom object) {
        FrodoEngine frodoEngine = this;
        byte[] byArray3 = new byte[frodoEngine.len_s_bytes + this.len_seedSE_bytes + 16];
        byte[] byArray4 = byArray3;
        ((SecureRandom)object).nextBytes(byArray4);
        object = Arrays.copyOfRange(byArray4, 0, this.len_s_bytes);
        int n = this.len_s_bytes;
        byArray4 = Arrays.copyOfRange(byArray4, n, n + this.len_seedSE_bytes);
        int n2 = this.len_s_bytes;
        int n3 = this.len_seedSE_bytes;
        int n4 = n2 + n3;
        Object[] objectArray = Arrays.copyOfRange(byArray3, n4, n2 + n3 + 16);
        byte[] byArray5 = new byte[16];
        frodoEngine.digest.update((byte[])objectArray, 0, objectArray.length);
        frodoEngine.digest.doFinal(byArray5, 0, 16);
        objectArray = frodoEngine.gen.genMatrix(byArray5);
        int n5 = frodoEngine.n * 2 * 8 * 2;
        byte[] byArray6 = new byte[n5];
        frodoEngine.digest.update((byte)95);
        frodoEngine.digest.update(byArray4, 0, byArray4.length);
        frodoEngine.digest.doFinal(byArray6, 0, n5);
        int n6 = frodoEngine.n * 2 * 8;
        short[] sArray = new short[n6];
        for (int k = 0; k < n6; ++k) {
            sArray[k] = Pack.littleEndianToShort(byArray6, k * 2);
        }
        FrodoEngine frodoEngine2 = this;
        FrodoEngine frodoEngine3 = this;
        FrodoEngine frodoEngine4 = this;
        FrodoEngine frodoEngine5 = this;
        int n7 = this.n;
        short[] sArray2 = frodoEngine5.sample_matrix(sArray, 0, 8, n7);
        n6 = frodoEngine5.n;
        short[] sArray3 = frodoEngine5.matrix_transpose(sArray2, 8, n6);
        int n8 = frodoEngine5.n;
        Object[] objectArray2 = frodoEngine4.sample_matrix(sArray, n8 * 8, n8, 8);
        int n9 = frodoEngine4.n;
        sArray3 = frodoEngine3.matrix_mul((short[])objectArray, n9, n9, sArray3, n9, 8);
        int n10 = frodoEngine3.n;
        int n11 = this.len_pk_bytes;
        System.arraycopy(Arrays.concatenate(byArray5, frodoEngine3.pack(frodoEngine3.matrix_add(sArray3, (short[])objectArray2, n10, 8))), 0, byArray, 0, n11);
        n11 = frodoEngine2.len_pkh_bytes;
        objectArray2 = new byte[n11];
        frodoEngine2.digest.update(byArray, 0, byArray.length);
        frodoEngine2.digest.doFinal((byte[])objectArray2, 0, n11);
        int n12 = this.len_s_bytes + this.len_pk_bytes;
        System.arraycopy(Arrays.concatenate((byte[])object, byArray), 0, byArray2, 0, n12);
        for (n12 = 0; n12 < 8; ++n12) {
            for (n11 = 0; n11 < (n10 = this.n); ++n11) {
                byte[] byArray7 = Pack.shortToLittleEndian(sArray2[n12 * n10 + n11]);
                FrodoEngine frodoEngine6 = this;
                n10 = frodoEngine6.len_s_bytes + this.len_pk_bytes;
                n10 = n12 * frodoEngine6.n * 2 + n10;
                n10 = n11 * 2 + n10;
                System.arraycopy(byArray7, 0, byArray2, n10, 2);
            }
        }
        int n13 = this.len_pkh_bytes;
        n12 = this.len_sk_bytes - n13;
        System.arraycopy(objectArray2, 0, byArray2, n12, n13);
    }

    public void kem_enc(byte[] byArray, byte[] byArray2, byte[] byArray3, SecureRandom object) {
        int n;
        FrodoEngine frodoEngine = this;
        SecureRandom secureRandom = object;
        object = Arrays.copyOfRange(byArray3, 0, 16);
        Object[] objectArray = Arrays.copyOfRange(byArray3, 16, this.len_pk_bytes);
        byte[] byArray4 = new byte[this.len_mu_bytes];
        secureRandom.nextBytes(byArray4);
        byte[] byArray5 = new byte[frodoEngine.len_pkh_bytes];
        frodoEngine.digest.update(byArray3, 0, this.len_pk_bytes);
        frodoEngine.digest.doFinal(byArray5, 0, this.len_pkh_bytes);
        byte[] byArray6 = new byte[frodoEngine.len_seedSE + this.len_k];
        byArray3 = byArray6;
        FrodoEngine frodoEngine2 = this;
        frodoEngine2.digest.update(byArray5, 0, this.len_pkh_bytes);
        frodoEngine2.digest.update(byArray4, 0, this.len_mu_bytes);
        frodoEngine2.digest.doFinal(byArray3, 0, this.len_seedSE_bytes + this.len_k_bytes);
        byArray3 = Arrays.copyOfRange(byArray3, 0, frodoEngine2.len_seedSE_bytes);
        int n2 = this.len_seedSE_bytes;
        byArray5 = Arrays.copyOfRange(byArray6, n2, n2 + this.len_k_bytes);
        int n3 = (frodoEngine.n * 16 + 64) * 2;
        FrodoEngine frodoEngine3 = this;
        byte[] byArray7 = new byte[n3];
        frodoEngine3.digest.update((byte)-106);
        frodoEngine3.digest.update(byArray3, 0, byArray3.length);
        frodoEngine3.digest.doFinal(byArray7, 0, n3);
        int n4 = n3 / 2;
        short[] sArray = new short[n4];
        for (n = 0; n < n4; ++n) {
            sArray[n] = Pack.littleEndianToShort(byArray7, n * 2);
        }
        FrodoEngine frodoEngine4 = this;
        FrodoEngine frodoEngine5 = this;
        n4 = this.n;
        Object[] objectArray2 = frodoEngine5.sample_matrix(sArray, 0, 8, n4);
        int n5 = frodoEngine5.n;
        short[] sArray2 = frodoEngine4.sample_matrix(sArray, n5 * 8, 8, n5);
        object = frodoEngine4.gen.genMatrix((byte[])object);
        int n6 = n = frodoEngine4.n;
        object = frodoEngine4.matrix_mul((short[])objectArray2, 8, n, (short[])object, n6, n6);
        n = frodoEngine4.n;
        byte[] byArray8 = frodoEngine4.pack(frodoEngine4.matrix_add((short[])object, sArray2, 8, n));
        object = byArray8;
        FrodoEngine frodoEngine6 = this;
        FrodoEngine frodoEngine7 = this;
        short[] sArray3 = objectArray2;
        FrodoEngine frodoEngine8 = this;
        FrodoEngine frodoEngine9 = this;
        objectArray2 = frodoEngine9.sample_matrix(sArray, this.n * 16, 8, 8);
        objectArray = frodoEngine8.unpack((byte[])objectArray, frodoEngine9.n, 8);
        int n7 = frodoEngine8.n;
        objectArray2 = frodoEngine7.matrix_add(frodoEngine7.matrix_mul(sArray3, 8, n7, (short[])objectArray, n7, 8), (short[])objectArray2, 8, 8);
        byte[] byArray9 = frodoEngine6.pack(frodoEngine6.matrix_add((short[])objectArray2, frodoEngine6.encode(byArray4), 8, 8));
        objectArray2 = byArray9;
        int n8 = this.len_ct_bytes;
        System.arraycopy(Arrays.concatenate(byArray8, byArray9), 0, byArray, 0, n8);
        Object object2 = object;
        frodoEngine4.digest.update((byte[])object2, 0, ((Object)object2).length);
        frodoEngine4.digest.update((byte[])objectArray2, 0, objectArray2.length);
        frodoEngine4.digest.update(byArray5, 0, this.len_k_bytes);
        frodoEngine4.digest.doFinal(byArray2, 0, this.len_s_bytes);
    }

    public void kem_dec(byte[] byArray, byte[] byArray2, byte[] objectArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.n * 8 * this.D / 8 + 0;
        byte[] byArray3 = Arrays.copyOfRange(byArray2, 0, n5);
        byte[] byArray4 = Arrays.copyOfRange(byArray2, n5, this.D * 64 / 8 + n5);
        int n6 = this.len_s_bytes + 0;
        Object[] objectArray2 = Arrays.copyOfRange(objectArray, 0, n6);
        int n7 = n6;
        n6 = n7 + 16;
        byte[] byArray5 = Arrays.copyOfRange(objectArray, n7, n6);
        int n8 = n6;
        n6 = this.D * this.n * 8 / 8 + n6;
        byte[] byArray6 = Arrays.copyOfRange(objectArray, n8, n6);
        int n9 = n6;
        n6 = this.n * 8 * 16 / 8 + n6;
        Object[] objectArray3 = Arrays.copyOfRange(objectArray, n9, n6);
        short[] sArray = new short[this.n * 8];
        for (n4 = 0; n4 < 8; ++n4) {
            int n10;
            for (n3 = 0; n3 < (n10 = this.n); ++n3) {
                int n11 = n10;
                n10 = n4 * n10 + n3;
                n2 = n4 * n11 * 2;
                sArray[n10] = Pack.littleEndianToShort(objectArray3, n3 * 2 + n2);
            }
        }
        FrodoEngine frodoEngine = this;
        byte[] byArray7 = objectArray;
        int n12 = n6;
        FrodoEngine frodoEngine2 = this;
        objectArray = frodoEngine2.matrix_transpose(sArray, 8, this.n);
        byte[] byArray8 = Arrays.copyOfRange(byArray7, n12, n12 + frodoEngine2.len_pkh_bytes);
        objectArray3 = this.unpack(byArray3, 8, this.n);
        sArray = frodoEngine.unpack(byArray4, 8, 8);
        n4 = frodoEngine.n;
        objectArray = frodoEngine.decode(frodoEngine.matrix_sub(sArray, frodoEngine.matrix_mul((short[])objectArray3, 8, n4, (short[])objectArray, n4, 8), 8, 8));
        byte[] byArray9 = new byte[frodoEngine.len_seedSE_bytes + this.len_k_bytes];
        FrodoEngine frodoEngine3 = this;
        frodoEngine3.digest.update(byArray8, 0, this.len_pkh_bytes);
        frodoEngine3.digest.update((byte[])objectArray, 0, this.len_mu_bytes);
        frodoEngine3.digest.doFinal(byArray9, 0, this.len_seedSE_bytes + this.len_k_bytes);
        int n13 = frodoEngine3.len_seedSE_bytes;
        byArray8 = Arrays.copyOfRange(byArray9, n13, n13 + this.len_k_bytes);
        n3 = (frodoEngine.n * 16 + 64) * 2;
        byte[] byArray10 = new byte[n3];
        frodoEngine.digest.update((byte)-106);
        frodoEngine.digest.update(byArray9, 0, this.len_seedSE_bytes);
        frodoEngine.digest.doFinal(byArray10, 0, n3);
        int n14 = frodoEngine.n * 16 + 64;
        short[] sArray2 = new short[n14];
        for (n2 = 0; n2 < n14; ++n2) {
            sArray2[n2] = Pack.littleEndianToShort(byArray10, n2 * 2);
        }
        FrodoEngine frodoEngine4 = this;
        byte[] byArray11 = objectArray2;
        FrodoEngine frodoEngine5 = this;
        FrodoEngine frodoEngine6 = this;
        FrodoEngine frodoEngine7 = this;
        FrodoEngine frodoEngine8 = this;
        FrodoEngine frodoEngine9 = this;
        int n15 = this.n;
        Object[] objectArray4 = frodoEngine9.sample_matrix(sArray2, 0, 8, n15);
        int n16 = frodoEngine9.n;
        short[] sArray3 = frodoEngine8.sample_matrix(sArray2, n16 * 8, 8, n16);
        objectArray2 = frodoEngine8.gen.genMatrix(byArray5);
        int n17 = n = frodoEngine8.n;
        objectArray2 = frodoEngine8.matrix_mul((short[])objectArray4, 8, n, (short[])objectArray2, n17, n17);
        n = frodoEngine8.n;
        sArray3 = frodoEngine8.matrix_add((short[])objectArray2, sArray3, 8, n);
        objectArray2 = frodoEngine7.sample_matrix(sArray2, frodoEngine8.n * 16, 8, 8);
        short[] sArray4 = frodoEngine6.unpack(byArray6, frodoEngine7.n, 8);
        int n18 = frodoEngine6.n;
        objectArray4 = frodoEngine6.matrix_add(frodoEngine6.matrix_mul((short[])objectArray4, 8, n18, sArray4, n18, 8), (short[])objectArray2, 8, 8);
        objectArray4 = frodoEngine4.ctselect(byArray8, byArray11, this.ctverify((short[])objectArray3, sArray, sArray3, frodoEngine5.matrix_add((short[])objectArray4, frodoEngine5.encode((byte[])objectArray), 8, 8)));
        frodoEngine4.digest.update(byArray3, 0, byArray3.length);
        frodoEngine4.digest.update(byArray4, 0, byArray4.length);
        frodoEngine4.digest.update((byte[])objectArray4, 0, objectArray4.length);
        frodoEngine4.digest.doFinal(byArray, 0, this.len_ss_bytes);
    }
}

