/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LmsUtils;
import java.security.SecureRandom;

public class HSSKeyGenerationParameters
extends KeyGenerationParameters {
    private final LMSParameters[] lmsParameters;

    public HSSKeyGenerationParameters(LMSParameters[] lMSParametersArray, SecureRandom secureRandom) {
        super(secureRandom, LmsUtils.calculateStrength(lMSParametersArray[0]));
        if (lMSParametersArray.length != 0 && lMSParametersArray.length <= 8) {
            this.lmsParameters = lMSParametersArray;
            return;
        }
        throw new IllegalArgumentException("lmsParameters length should be between 1 and 8 inclusive");
    }

    public int getDepth() {
        return this.lmsParameters.length;
    }

    public LMSParameters[] getLmsParameters() {
        return this.lmsParameters;
    }
}

