/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSException;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LmsUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.SeedDerive;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

class LM_OTS {
    private static final short D_PBLC = -32640;
    private static final int ITER_K = 20;
    private static final int ITER_PREV = 23;
    private static final int ITER_J = 22;
    public static final int SEED_RANDOMISER_INDEX = -3;
    public static final int SEED_LEN = 32;
    public static final int MAX_HASH = 32;
    public static final short D_MESG = -32383;

    public static int coef(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n3 * n2 / 8;
        n = 8 / n2;
        n = n2 * (~n3 & n - 1);
        int n5 = n4;
        n4 = (1 << n2) - 1;
        return byArray[n5] >>> n & n4;
    }

    public static int cksm(byte[] byArray, int n, LMOtsParameters lMOtsParameters) {
        int n2 = 0;
        int n3 = (1 << lMOtsParameters.getW()) - 1;
        for (int k = 0; k < n * 8 / lMOtsParameters.getW(); ++k) {
            n2 = n2 + n3 - LM_OTS.coef(byArray, k, lMOtsParameters.getW());
        }
        return n2 << lMOtsParameters.getLs();
    }

    public static LMOtsPublicKey lms_ots_generatePublicKey(LMOtsPrivateKey object) {
        LMOtsPrivateKey lMOtsPrivateKey = object;
        byte[] byArray = lMOtsPrivateKey.getI();
        int n = lMOtsPrivateKey.getQ();
        byte[] byArray2 = lMOtsPrivateKey.getMasterSecret();
        byArray = LM_OTS.lms_ots_generatePublicKey(((LMOtsPrivateKey)object).getParameter(), byArray, n, byArray2);
        LMOtsPrivateKey lMOtsPrivateKey2 = object;
        object = lMOtsPrivateKey2.getParameter();
        byte[] byArray3 = lMOtsPrivateKey2.getI();
        int n2 = lMOtsPrivateKey2.getQ();
        return new LMOtsPublicKey((LMOtsParameters)object, byArray3, n2, byArray);
    }

    public static byte[] lms_ots_generatePublicKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n, byte[] byArray2) {
        SeedDerive seedDerive;
        LMOtsParameters lMOtsParameters2 = lMOtsParameters;
        Digest digest = DigestUtil.getDigest(lMOtsParameters2.getDigestOID());
        byte[] byArray3 = Composer.compose().bytes(byArray).u32str(n).u16str(-32640).padUntil(0, 22).build();
        digest.update(byArray3, 0, byArray3.length);
        Digest digest2 = DigestUtil.getDigest(lMOtsParameters2.getDigestOID());
        byte[] byArray4 = Composer.compose().bytes(byArray).u32str(n).padUntil(0, digest2.getDigestSize() + 23).build();
        SeedDerive seedDerive2 = seedDerive;
        seedDerive2(byArray, byArray2, DigestUtil.getDigest(lMOtsParameters.getDigestOID()));
        seedDerive.setQ(n);
        seedDerive.setJ(0);
        int n2 = lMOtsParameters2.getP();
        int n3 = lMOtsParameters2.getN();
        n = (1 << lMOtsParameters2.getW()) - 1;
        for (int k = 0; k < n2; ++k) {
            int n4 = k < n2 - 1 ? 1 : 0;
            seedDerive2.deriveSeed(byArray4, n4 != 0, 23);
            Pack.shortToBigEndian((short)k, byArray4, 20);
            for (n4 = 0; n4 < n; ++n4) {
                Digest digest3 = digest2;
                byArray4[22] = (byte)n4;
                int n5 = byArray4.length;
                digest3.update(byArray4, 0, n5);
                digest3.doFinal(byArray4, 23);
            }
            digest.update(byArray4, 23, n3);
        }
        byte[] byArray5 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray5, 0);
        return byArray5;
    }

    public static LMOtsSignature lm_ots_generate_signature(LMSigParameters object, LMOtsPrivateKey lMOtsPrivateKey, byte[][] byArray, byte[] byArray2, boolean bl) {
        byte[] byArray3 = new byte[34];
        if (!bl) {
            LMSContext lMSContext = lMOtsPrivateKey.getSignatureContext((LMSigParameters)object, byArray);
            object = lMSContext;
            LmsUtils.byteArray(byArray2, 0, byArray2.length, (Digest)object);
            object = lMSContext.getC();
            byArray3 = lMSContext.getQ();
        } else {
            object = new byte[32];
            int n = lMOtsPrivateKey.getParameter().getN();
            System.arraycopy(byArray2, 0, byArray3, 0, n);
        }
        return LM_OTS.lm_ots_generate_signature(lMOtsPrivateKey, byArray3, (byte[])object);
    }

    public static LMOtsSignature lm_ots_generate_signature(LMOtsPrivateKey lMOtsPrivateKey, byte[] byArray, byte[] byArray2) {
        LMOtsPrivateKey lMOtsPrivateKey2 = lMOtsPrivateKey;
        LMOtsParameters lMOtsParameters = lMOtsPrivateKey2.getParameter();
        int n = lMOtsParameters.getN();
        int n2 = lMOtsParameters.getP();
        int n3 = lMOtsParameters.getW();
        byte[] byArray3 = new byte[n2 * n];
        Digest digest = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        SeedDerive seedDerive = lMOtsPrivateKey2.getDerivationFunction();
        int n4 = LM_OTS.cksm(byArray, n, lMOtsParameters);
        int n5 = n4;
        byArray[n] = (byte)(n5 >>> 8 & 0xFF);
        n5 = n + 1;
        byArray[n5] = (byte)n4;
        int n6 = n + 23;
        byte[] byArray4 = Composer.compose().bytes(lMOtsPrivateKey.getI()).u32str(lMOtsPrivateKey.getQ()).padUntil(0, n6).build();
        seedDerive.setJ(0);
        for (int k = 0; k < n2; ++k) {
            Pack.shortToBigEndian((short)k, byArray4, 20);
            int n7 = k < n2 - 1 ? 1 : 0;
            seedDerive.deriveSeed(byArray4, n7 != 0, 23);
            n7 = LM_OTS.coef(byArray, k, n3);
            for (int i2 = 0; i2 < n7; ++i2) {
                Digest digest2 = digest;
                byArray4[22] = (byte)i2;
                digest2.update(byArray4, 0, n6);
                digest2.doFinal(byArray4, 23);
            }
            n7 = n * k;
            System.arraycopy(byArray4, 23, byArray3, n7, n);
        }
        return new LMOtsSignature(lMOtsParameters, byArray2, byArray3);
    }

    public static boolean lm_ots_validate_signature(LMOtsPublicKey lMOtsPublicKey, LMOtsSignature lMOtsSignature, byte[] byArray, boolean bl) {
        if (lMOtsSignature.getType().equals(lMOtsPublicKey.getParameter())) {
            return Arrays.areEqual(LM_OTS.lm_ots_validate_signature_calculate(lMOtsPublicKey, lMOtsSignature, byArray), lMOtsPublicKey.getK());
        }
        throw new LMSException("public key and signature ots types do not match");
    }

    public static byte[] lm_ots_validate_signature_calculate(LMOtsPublicKey object, LMOtsSignature lMOtsSignature, byte[] byArray) {
        object = ((LMOtsPublicKey)object).createOtsContext(lMOtsSignature);
        LmsUtils.byteArray(byArray, (Digest)object);
        return LM_OTS.lm_ots_validate_signature_calculate((LMSContext)object);
    }

    public static byte[] lm_ots_validate_signature_calculate(LMSContext lMSContext) {
        LMSContext lMSContext2 = lMSContext;
        LMOtsPublicKey lMOtsPublicKey = lMSContext2.getPublicKey();
        Object object = lMOtsPublicKey.getParameter();
        Object object2 = lMSContext2.getSignature();
        object2 = object2 instanceof LMSSignature ? ((LMSSignature)object2).getOtsSignature() : (LMOtsSignature)object2;
        LMOtsParameters lMOtsParameters = object;
        LMOtsPublicKey lMOtsPublicKey2 = lMOtsPublicKey;
        LMOtsParameters lMOtsParameters2 = object;
        int n = lMOtsParameters2.getN();
        int n2 = lMOtsParameters2.getW();
        int n3 = lMOtsParameters2.getP();
        byte[] byArray = lMSContext.getQ();
        byte[] byArray2 = byArray;
        int n4 = LM_OTS.cksm(byArray, n, (LMOtsParameters)object);
        int n5 = n4;
        byArray2[n] = (byte)(n5 >>> 8 & 0xFF);
        n5 = n + 1;
        byArray[n5] = (byte)n4;
        byte[] byArray3 = lMOtsPublicKey2.getI();
        int n6 = lMOtsPublicKey2.getQ();
        object = DigestUtil.getDigest(((LMOtsParameters)object).getDigestOID());
        LmsUtils.byteArray(byArray3, (Digest)object);
        LmsUtils.u32str(n6, (Digest)object);
        LmsUtils.u16str((short)-32640, (Digest)object);
        int n7 = n + 23;
        byte[] byArray4 = Composer.compose().bytes(byArray3).u32str(n6).padUntil(0, n7).build();
        int n8 = (1 << n2) - 1;
        byte[] byArray5 = ((LMOtsSignature)object2).getY();
        Digest digest = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        for (int k = 0; k < n3; ++k) {
            Pack.shortToBigEndian((short)k, byArray4, 20);
            System.arraycopy(byArray5, k * n, byArray4, 23, n);
            for (int i2 = LM_OTS.coef(byArray2, k, n2); i2 < n8; ++i2) {
                Digest digest2 = digest;
                byArray4[22] = (byte)i2;
                digest2.update(byArray4, 0, n7);
                digest2.doFinal(byArray4, 23);
            }
            object.update(byArray4, 23, n);
        }
        byte[] byArray6 = new byte[n];
        object.doFinal(byArray6, 0);
        return byArray6;
    }
}

