/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA1Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageEncryptor;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.Conversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Primitives;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import java.security.SecureRandom;

public class McElieceFujisakiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.1";
    private static final String DEFAULT_PRNG_NAME = "SHA1PRNG";
    private Digest messDigest;
    private SecureRandom sr;
    private int n;
    private int k;
    private int t;
    public McElieceCCA2KeyParameters key;
    private boolean forEncryption;

    private void initCipherEncrypt(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.messDigest = Utils.getDigest(mcElieceCCA2PublicKeyParameters.getDigest());
        this.n = mcElieceCCA2PublicKeyParameters.getN();
        this.k = mcElieceCCA2PublicKeyParameters.getK();
        this.t = mcElieceCCA2PublicKeyParameters.getT();
    }

    private void initCipherDecrypt(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.messDigest = Utils.getDigest(mcElieceCCA2PrivateKeyParameters.getDigest());
        this.n = mcElieceCCA2PrivateKeyParameters.getN();
        this.t = mcElieceCCA2PrivateKeyParameters.getT();
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        ((McElieceFujisakiCipher)object).forEncryption = bl;
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                McElieceFujisakiCipher mcElieceFujisakiCipher = object;
                object = (ParametersWithRandom)cipherParameters;
                mcElieceFujisakiCipher.sr = ((ParametersWithRandom)object).getRandom();
                object = (McElieceCCA2PublicKeyParameters)((ParametersWithRandom)object).getParameters();
                mcElieceFujisakiCipher.key = object;
                mcElieceFujisakiCipher.initCipherEncrypt((McElieceCCA2PublicKeyParameters)object);
            } else {
                McElieceFujisakiCipher mcElieceFujisakiCipher = object;
                ((McElieceFujisakiCipher)object).sr = CryptoServicesRegistrar.getSecureRandom();
                object = (McElieceCCA2PublicKeyParameters)cipherParameters;
                mcElieceFujisakiCipher.key = object;
                mcElieceFujisakiCipher.initCipherEncrypt((McElieceCCA2PublicKeyParameters)object);
            }
        } else {
            McElieceFujisakiCipher mcElieceFujisakiCipher = object;
            object = (McElieceCCA2PrivateKeyParameters)cipherParameters;
            mcElieceFujisakiCipher.key = object;
            mcElieceFujisakiCipher.initCipherDecrypt((McElieceCCA2PrivateKeyParameters)object);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters mcElieceCCA2KeyParameters) {
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    @Override
    public byte[] messageEncrypt(byte[] byArray) {
        if (((McElieceFujisakiCipher)object2).forEncryption) {
            DigestRandomGenerator digestRandomGenerator;
            GF2Vector gF2Vector;
            McElieceFujisakiCipher mcElieceFujisakiCipher = object2;
            Object object = gF2Vector;
            McElieceFujisakiCipher mcElieceFujisakiCipher2 = object2;
            int n = mcElieceFujisakiCipher2.k;
            byte[] byArray2 = new GF2Vector(n, mcElieceFujisakiCipher2.sr).getEncoded();
            byte[] byArray3 = ByteUtils.concatenate(byArray2, byArray);
            mcElieceFujisakiCipher.messDigest.update(byArray3, 0, byArray3.length);
            byArray3 = new byte[mcElieceFujisakiCipher.messDigest.getDigestSize()];
            mcElieceFujisakiCipher.messDigest.doFinal(byArray3, 0);
            Object object2 = Conversions.encode(mcElieceFujisakiCipher.n, ((McElieceFujisakiCipher)object2).t, byArray3);
            object2 = McElieceCCA2Primitives.encryptionPrimitive((McElieceCCA2PublicKeyParameters)mcElieceFujisakiCipher.key, (GF2Vector)object, (GF2Vector)object2).getEncoded();
            object = digestRandomGenerator;
            ((DigestRandomGenerator)object)(new SHA1Digest());
            ((DigestRandomGenerator)object).addSeedMaterial(byArray2);
            byte[] byArray4 = new byte[byArray.length];
            object = byArray4;
            digestRandomGenerator.nextBytes(byArray4);
            for (int k = 0; k < byArray.length; ++k) {
                object[k] = (byte)(object[k] ^ byArray[k]);
            }
            return ByteUtils.concatenate((byte[])object2, (byte[])object);
        }
        throw new IllegalStateException("cipher initialised for decryption");
    }

    @Override
    public byte[] messageDecrypt(byte[] byArray) {
        if (!this.forEncryption) {
            DigestRandomGenerator digestRandomGenerator;
            McElieceFujisakiCipher mcElieceFujisakiCipher = this;
            int n = this.n + 7 >> 3;
            int n2 = byArray.length - n;
            byte[][] byArray2 = ByteUtils.split(byArray, n);
            Object object = byArray2[0];
            byte[] byArray3 = byArray2[1];
            object = GF2Vector.OS2VP(mcElieceFujisakiCipher.n, object);
            GF2Vector[] gF2VectorArray = McElieceCCA2Primitives.decryptionPrimitive((McElieceCCA2PrivateKeyParameters)mcElieceFujisakiCipher.key, (GF2Vector)object);
            object = gF2VectorArray[0].getEncoded();
            GF2Vector gF2Vector = gF2VectorArray[1];
            Object object2 = digestRandomGenerator;
            ((DigestRandomGenerator)object2)(new SHA1Digest());
            ((DigestRandomGenerator)object2).addSeedMaterial((byte[])object);
            byte[] byArray4 = new byte[n2];
            object2 = byArray4;
            digestRandomGenerator.nextBytes(byArray4);
            for (int k = 0; k < n2; ++k) {
                object2[k] = (byte)(object2[k] ^ byArray3[k]);
            }
            McElieceFujisakiCipher mcElieceFujisakiCipher2 = this;
            byte[] byArray5 = ByteUtils.concatenate(object, (byte[])object2);
            object = new byte[mcElieceFujisakiCipher2.messDigest.getDigestSize()];
            mcElieceFujisakiCipher2.messDigest.update(byArray5, 0, byArray5.length);
            mcElieceFujisakiCipher2.messDigest.doFinal((byte[])object, 0);
            if (Conversions.encode(mcElieceFujisakiCipher2.n, this.t, object).equals(gF2Vector)) {
                return object2;
            }
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        throw new IllegalStateException("cipher initialised for decryption");
    }
}

