/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA1Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageEncryptor;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.Conversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Primitives;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import java.security.SecureRandom;

public class McElieceKobaraImaiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.3";
    private static final String DEFAULT_PRNG_NAME = "SHA1PRNG";
    public static final byte[] PUBLIC_CONSTANT = "a predetermined public constant".getBytes();
    private Digest messDigest;
    private SecureRandom sr;
    public McElieceCCA2KeyParameters key;
    private int n;
    private int k;
    private int t;
    private boolean forEncryption;

    private void initCipherEncrypt(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.messDigest = Utils.getDigest(mcElieceCCA2PublicKeyParameters.getDigest());
        this.n = mcElieceCCA2PublicKeyParameters.getN();
        this.k = mcElieceCCA2PublicKeyParameters.getK();
        this.t = mcElieceCCA2PublicKeyParameters.getT();
    }

    private void initCipherDecrypt(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.messDigest = Utils.getDigest(mcElieceCCA2PrivateKeyParameters.getDigest());
        this.n = mcElieceCCA2PrivateKeyParameters.getN();
        this.k = mcElieceCCA2PrivateKeyParameters.getK();
        this.t = mcElieceCCA2PrivateKeyParameters.getT();
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        ((McElieceKobaraImaiCipher)object).forEncryption = bl;
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                McElieceKobaraImaiCipher mcElieceKobaraImaiCipher = object;
                object = (ParametersWithRandom)cipherParameters;
                mcElieceKobaraImaiCipher.sr = ((ParametersWithRandom)object).getRandom();
                object = (McElieceCCA2PublicKeyParameters)((ParametersWithRandom)object).getParameters();
                mcElieceKobaraImaiCipher.key = object;
                mcElieceKobaraImaiCipher.initCipherEncrypt((McElieceCCA2PublicKeyParameters)object);
            } else {
                McElieceKobaraImaiCipher mcElieceKobaraImaiCipher = object;
                ((McElieceKobaraImaiCipher)object).sr = CryptoServicesRegistrar.getSecureRandom();
                object = (McElieceCCA2PublicKeyParameters)cipherParameters;
                mcElieceKobaraImaiCipher.key = object;
                mcElieceKobaraImaiCipher.initCipherEncrypt((McElieceCCA2PublicKeyParameters)object);
            }
        } else {
            McElieceKobaraImaiCipher mcElieceKobaraImaiCipher = object;
            object = (McElieceCCA2PrivateKeyParameters)cipherParameters;
            mcElieceKobaraImaiCipher.key = object;
            mcElieceKobaraImaiCipher.initCipherDecrypt((McElieceCCA2PrivateKeyParameters)object);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters mcElieceCCA2KeyParameters) {
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    @Override
    public byte[] messageEncrypt(byte[] byArray) {
        if (((McElieceKobaraImaiCipher)object3).forEncryption) {
            DigestRandomGenerator digestRandomGenerator;
            int n;
            McElieceKobaraImaiCipher mcElieceKobaraImaiCipher = object3;
            int n2 = mcElieceKobaraImaiCipher.messDigest.getDigestSize();
            int n3 = mcElieceKobaraImaiCipher.k >> 3;
            int n4 = IntegerFunctions.binomial(((McElieceKobaraImaiCipher)object3).n, ((McElieceKobaraImaiCipher)object3).t).bitLength() - 1 >> 3;
            byte[] byArray2 = PUBLIC_CONSTANT;
            int n5 = n3 + n4 - n2 - PUBLIC_CONSTANT.length;
            if (byArray.length > n5) {
                n5 = byArray.length;
            }
            int n6 = n = n5 + byArray2.length;
            int n7 = n6 + n2 - n3 - n4;
            byArray2 = new byte[n6];
            int n8 = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n8);
            n8 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray2, n5, n8);
            byte[] byArray3 = new byte[n2];
            ((McElieceKobaraImaiCipher)object3).sr.nextBytes(byArray3);
            Object object = digestRandomGenerator;
            ((DigestRandomGenerator)object)(new SHA1Digest());
            ((DigestRandomGenerator)object).addSeedMaterial(byArray3);
            byte[] byArray4 = new byte[n];
            object = byArray4;
            digestRandomGenerator.nextBytes(byArray4);
            for (int k = n - 1; k >= 0; --k) {
                object[k] = (byte)(object[k] ^ byArray2[k]);
            }
            McElieceKobaraImaiCipher mcElieceKobaraImaiCipher2 = object3;
            Object object2 = new byte[mcElieceKobaraImaiCipher2.messDigest.getDigestSize()];
            mcElieceKobaraImaiCipher2.messDigest.update((byte[])object, 0, n);
            mcElieceKobaraImaiCipher2.messDigest.doFinal((byte[])object2, 0);
            for (int k = n2 - 1; k >= 0; --k) {
                object2[k] = (byte)(object2[k] ^ byArray3[k]);
            }
            object2 = ByteUtils.concatenate(object2, (byte[])object);
            byte[] byArray5 = new byte[]{};
            if (n7 > 0) {
                byArray5 = new byte[n7];
                System.arraycopy(object2, 0, byArray5, 0, n7);
            }
            McElieceKobaraImaiCipher mcElieceKobaraImaiCipher3 = object3;
            byte[] byArray6 = object2;
            byte[] byArray7 = new byte[n4];
            System.arraycopy(object2, n7, byArray7, 0, n4);
            object2 = new byte[n3];
            System.arraycopy(byArray6, n7 + n4, object2, 0, n3);
            object2 = GF2Vector.OS2VP(mcElieceKobaraImaiCipher3.k, object2);
            Object object3 = Conversions.encode(mcElieceKobaraImaiCipher3.n, ((McElieceKobaraImaiCipher)object3).t, byArray7);
            object3 = McElieceCCA2Primitives.encryptionPrimitive((McElieceCCA2PublicKeyParameters)mcElieceKobaraImaiCipher3.key, (GF2Vector)object2, (GF2Vector)object3).getEncoded();
            if (n7 > 0) {
                return ByteUtils.concatenate(byArray5, (byte[])object3);
            }
            return object3;
        }
        throw new IllegalStateException("cipher initialised for decryption");
    }

    @Override
    public byte[] messageDecrypt(byte[] object) {
        if (!this.forEncryption) {
            int n = this.n >> 3;
            if (((byte[])object).length >= n) {
                SHA1Digest sHA1Digest;
                byte[] byArray;
                McElieceKobaraImaiCipher mcElieceKobaraImaiCipher = this;
                int n2 = mcElieceKobaraImaiCipher.messDigest.getDigestSize();
                int n3 = mcElieceKobaraImaiCipher.k >> 3;
                if ((n = ((byte[])object).length - n) > 0) {
                    byte[][] byArray2 = ByteUtils.split(object, n);
                    object = byArray2[0];
                    byte[] byArray3 = byArray = byArray2[1];
                    byArray = object;
                    object = byArray3;
                } else {
                    byArray = new byte[]{};
                }
                McElieceKobaraImaiCipher mcElieceKobaraImaiCipher2 = this;
                object = GF2Vector.OS2VP(mcElieceKobaraImaiCipher2.n, object);
                GF2Vector[] gF2VectorArray = McElieceCCA2Primitives.decryptionPrimitive((McElieceCCA2PrivateKeyParameters)mcElieceKobaraImaiCipher2.key, (GF2Vector)object);
                object = gF2VectorArray[0].getEncoded();
                GF2Vector gF2Vector = gF2VectorArray[1];
                if (((byte[])object).length > n3) {
                    object = ByteUtils.subArray(object, 0, n3);
                }
                McElieceKobaraImaiCipher mcElieceKobaraImaiCipher3 = this;
                byte[] byArray4 = ByteUtils.concatenate(ByteUtils.concatenate(byArray, Conversions.decode(this.n, this.t, gF2Vector)), object);
                int n4 = byArray4.length - n2;
                byte[][] byArray5 = ByteUtils.split(byArray4, n2);
                object = byArray5[0];
                byArray = byArray5[1];
                byte[] byArray6 = new byte[mcElieceKobaraImaiCipher3.messDigest.getDigestSize()];
                mcElieceKobaraImaiCipher3.messDigest.update(byArray, 0, byArray.length);
                mcElieceKobaraImaiCipher3.messDigest.doFinal(byArray6, 0);
                for (n3 = n2 - 1; n3 >= 0; --n3) {
                    byArray6[n3] = (byte)(byArray6[n3] ^ object[n3]);
                }
                object = sHA1Digest;
                sHA1Digest = new SHA1Digest();
                DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator((Digest)object);
                digestRandomGenerator.addSeedMaterial(byArray6);
                object = new byte[n4];
                digestRandomGenerator.nextBytes((byte[])object);
                for (int k = n4 - 1; k >= 0; --k) {
                    object[k] = (byte)(object[k] ^ byArray[k]);
                }
                byte[] byArray7 = PUBLIC_CONSTANT;
                byte[][] byArray8 = ByteUtils.split(object, n4 - PUBLIC_CONSTANT.length);
                object = byArray8[0];
                if (ByteUtils.equals(byArray8[1], byArray7)) {
                    return object;
                }
                throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
            }
            throw new InvalidCipherTextException("Bad Padding: Ciphertext too short.");
        }
        throw new IllegalStateException("cipher initialised for decryption");
    }
}

