/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DEROtherInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ExchangePair;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import java.io.IOException;
import java.security.SecureRandom;

public class NHOtherInfoGenerator {
    public final DEROtherInfo.Builder otherInfoBuilder;
    public final SecureRandom random;
    public boolean used = false;

    public NHOtherInfoGenerator(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        DEROtherInfo.Builder builder;
        DEROtherInfo.Builder builder2 = builder;
        builder = new DEROtherInfo.Builder(algorithmIdentifier, byArray, byArray2);
        v1.otherInfoBuilder = builder2;
        v1.random = secureRandom;
    }

    private static byte[] getEncoded(NHPublicKeyParameters nHPublicKeyParameters) {
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
        try {
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            return new SubjectPublicKeyInfo(algorithmIdentifier2, nHPublicKeyParameters.getPubData()).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static NHPublicKeyParameters getPublicKey(byte[] object) {
        object = SubjectPublicKeyInfo.getInstance(object);
        return new NHPublicKeyParameters(((SubjectPublicKeyInfo)object).getPublicKeyData().getOctets());
    }

    public static class PartyV
    extends NHOtherInfoGenerator {
        public PartyV(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            PartyV partyV = this;
            partyV.otherInfoBuilder.withSuppPubInfo(byArray);
            return partyV;
        }

        public byte[] getSuppPrivInfoPartB(byte[] byArray) {
            ExchangePair exchangePair = new NHExchangePairGenerator(this.random).generateExchange(NHOtherInfoGenerator.getPublicKey(byArray));
            this.otherInfoBuilder.withSuppPrivInfo(exchangePair.getSharedValue());
            return NHOtherInfoGenerator.getEncoded((NHPublicKeyParameters)exchangePair.getPublicKey());
        }

        public DEROtherInfo generate() {
            if (!this.used) {
                this.used = true;
                return this.otherInfoBuilder.build();
            }
            throw new IllegalStateException("builder already used");
        }
    }

    public static class PartyU
    extends NHOtherInfoGenerator {
        private AsymmetricCipherKeyPair aKp;
        private NHAgreement agreement;

        public PartyU(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            PartyU partyU = asymmetricCipherKeyPair;
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
            partyU.agreement = new NHAgreement();
            NHKeyPairGenerator nHKeyPairGenerator = new NHKeyPairGenerator();
            nHKeyPairGenerator.init(new KeyGenerationParameters(secureRandom, 2048));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = nHKeyPairGenerator.generateKeyPair();
            partyU.aKp = asymmetricCipherKeyPair;
            partyU.agreement.init(asymmetricCipherKeyPair.getPrivate());
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            PartyU partyU = this;
            partyU.otherInfoBuilder.withSuppPubInfo(byArray);
            return partyU;
        }

        public byte[] getSuppPrivInfoPartA() {
            return NHOtherInfoGenerator.getEncoded((NHPublicKeyParameters)this.aKp.getPublic());
        }

        public DEROtherInfo generate(byte[] byArray) {
            if (!this.used) {
                PartyU partyU = this;
                partyU.used = true;
                partyU.otherInfoBuilder.withSuppPrivInfo(this.agreement.calculateAgreement(NHOtherInfoGenerator.getPublicKey(byArray)));
                return partyU.otherInfoBuilder.build();
            }
            throw new IllegalStateException("builder already used");
        }
    }
}

