/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class Layer {
    private int vi;
    private int viNext;
    private int oi;
    private short[][][] coeff_alpha;
    private short[][][] coeff_beta;
    private short[][] coeff_gamma;
    private short[] coeff_eta;

    public Layer(byte by, byte by2, short[][][] sArray, short[][][] sArray2, short[][] sArray3, short[] sArray4) {
        int n = by & 0xFF;
        by = (byte)n;
        this.vi = n;
        int n2 = by2 & 0xFF;
        by2 = (byte)n2;
        this.viNext = by2;
        this.oi = n2 - by;
        this.coeff_alpha = sArray;
        this.coeff_beta = sArray2;
        this.coeff_gamma = sArray3;
        this.coeff_eta = sArray4;
    }

    public Layer(int n, int n2, SecureRandom secureRandom) {
        int n3;
        int n4;
        Layer layer = this;
        this.vi = n;
        this.viNext = n2;
        int n5 = this.oi = (n4 = n2 - n);
        this.coeff_alpha = new short[n5][n5][n];
        this.coeff_beta = new short[n4][n][n];
        layer.coeff_gamma = new short[n4][n2];
        layer.coeff_eta = new short[n4];
        for (n = 0; n < n4; ++n) {
            for (n2 = 0; n2 < this.oi; ++n2) {
                for (n3 = 0; n3 < this.vi; ++n3) {
                    this.coeff_alpha[n][n2][n3] = (short)(secureRandom.nextInt() & 0xFF);
                }
            }
        }
        for (n = 0; n < n4; ++n) {
            for (n2 = 0; n2 < this.vi; ++n2) {
                for (n3 = 0; n3 < this.vi; ++n3) {
                    this.coeff_beta[n][n2][n3] = (short)(secureRandom.nextInt() & 0xFF);
                }
            }
        }
        for (n = 0; n < n4; ++n) {
            for (n2 = 0; n2 < this.viNext; ++n2) {
                this.coeff_gamma[n][n2] = (short)(secureRandom.nextInt() & 0xFF);
            }
        }
        for (n = 0; n < n4; ++n) {
            this.coeff_eta[n] = (short)(secureRandom.nextInt() & 0xFF);
        }
    }

    public short[][] plugInVinegars(short[] sArray) {
        int n;
        short s;
        int n2;
        int n3;
        int n4;
        int n5 = this.oi;
        short[][] sArray2 = new short[n5][n5 + 1];
        short[] sArray3 = new short[n5];
        for (n4 = 0; n4 < this.oi; ++n4) {
            for (n3 = 0; n3 < this.vi; ++n3) {
                for (n2 = 0; n2 < this.vi; ++n2) {
                    s = GF2Field.multElem(GF2Field.multElem(this.coeff_beta[n4][n3][n2], sArray[n3]), sArray[n2]);
                    sArray3[n4] = GF2Field.addElem(sArray3[n4], s);
                }
            }
        }
        for (n4 = 0; n4 < this.oi; ++n4) {
            for (n3 = 0; n3 < this.oi; ++n3) {
                for (n2 = 0; n2 < this.vi; ++n2) {
                    s = GF2Field.multElem(this.coeff_alpha[n4][n3][n2], sArray[n2]);
                    short[] sArray4 = sArray2[n4];
                    sArray4[n3] = GF2Field.addElem(sArray4[n3], s);
                }
            }
        }
        for (n4 = 0; n4 < this.oi; ++n4) {
            for (n3 = 0; n3 < this.vi; ++n3) {
                n2 = GF2Field.multElem(this.coeff_gamma[n4][n3], sArray[n3]);
                sArray3[n4] = GF2Field.addElem(sArray3[n4], (short)n2);
            }
        }
        for (n = 0; n < this.oi; ++n) {
            for (n4 = this.vi; n4 < this.viNext; ++n4) {
                short[] sArray5 = sArray2[n];
                short[] sArray6 = sArray5;
                n2 = this.vi;
                sArray5[n4 - n2] = GF2Field.addElem(this.coeff_gamma[n][n4], sArray6[n4 - n2]);
            }
        }
        for (n = 0; n < this.oi; ++n) {
            sArray3[n] = GF2Field.addElem(sArray3[n], this.coeff_eta[n]);
        }
        for (n = 0; n < (n4 = this.oi); ++n) {
            sArray2[n][n4] = sArray3[n];
        }
        return sArray2;
    }

    public int getVi() {
        return this.vi;
    }

    public int getViNext() {
        return this.viNext;
    }

    public int getOi() {
        return this.oi;
    }

    public short[][][] getCoeffAlpha() {
        return this.coeff_alpha;
    }

    public short[][][] getCoeffBeta() {
        return this.coeff_beta;
    }

    public short[][] getCoeffGamma() {
        return this.coeff_gamma;
    }

    public short[] getCoeffEta() {
        return this.coeff_eta;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Layer) {
            return this.vi == ((Layer)(object = (Layer)object)).getVi() && this.viNext == ((Layer)object).getViNext() && this.oi == ((Layer)object).getOi() && RainbowUtil.equals(this.coeff_alpha, ((Layer)object).getCoeffAlpha()) && RainbowUtil.equals(this.coeff_beta, ((Layer)object).getCoeffBeta()) && RainbowUtil.equals(this.coeff_gamma, ((Layer)object).getCoeffGamma()) && RainbowUtil.equals(this.coeff_eta, ((Layer)object).getCoeffEta());
        }
        return false;
    }

    public int hashCode() {
        Layer layer = this;
        int n = ((layer.vi * 37 + this.viNext) * 37 + this.oi) * 37;
        n = (Arrays.hashCode(layer.coeff_alpha) + n) * 37;
        n = (Arrays.hashCode(layer.coeff_beta) + n) * 37;
        n = (Arrays.hashCode(layer.coeff_gamma) + n) * 37;
        return Arrays.hashCode(layer.coeff_eta) + n;
    }
}

