/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.EncapsulatedSecretExtractor;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABEREngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;

public class SABERKEMExtractor
implements EncapsulatedSecretExtractor {
    private SABEREngine engine;
    private SABERKeyParameters key;

    public SABERKEMExtractor(SABERKeyParameters sABERKeyParameters) {
        this.key = sABERKeyParameters;
        this.initCipher(sABERKeyParameters.getParameters());
    }

    private void initCipher(SABERParameters sABERParameters) {
        this.engine = sABERParameters.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        byte[] byArray2 = new byte[this.engine.getSessionKeySize()];
        this.engine.crypto_kem_dec(byArray2, byArray, ((SABERPrivateKeyParameters)this.key).getPrivateKey());
        return byArray2;
    }

    public int getInputSize() {
        return this.engine.getCipherTextSize();
    }
}

