/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Horst;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Seed;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Tree;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Wots;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SPHINCS256Signer
implements MessageSigner {
    private final HashFunctions hashFunctions;
    private byte[] keyData;

    public SPHINCS256Signer(Digest digest, Digest digest2) {
        if (digest.getDigestSize() == 32) {
            if (digest2.getDigestSize() == 64) {
                HashFunctions hashFunctions;
                SPHINCS256Signer sPHINCS256Signer = hashFunctions2;
                HashFunctions hashFunctions2 = hashFunctions;
                hashFunctions = new HashFunctions(digest, digest2);
                sPHINCS256Signer.hashFunctions = hashFunctions2;
                return;
            }
            throw new IllegalArgumentException("2n-digest needs to produce 64 bytes of output");
        }
        throw new IllegalArgumentException("n-digest needs to produce 32 bytes of output");
    }

    public static void validate_authpath(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, byte[] byArray4, int n3) {
        int n4;
        int n5;
        int n6;
        byte[] byArray5 = new byte[64];
        if ((n & 1) != 0) {
            for (n6 = 0; n6 < 32; ++n6) {
                n5 = n6 + 32;
                byArray5[n5] = byArray2[n6];
            }
            for (n4 = 0; n4 < 32; ++n4) {
                byArray5[n4] = byArray3[n2 + n4];
            }
        } else {
            for (n6 = 0; n6 < 32; ++n6) {
                byArray5[n6] = byArray2[n6];
            }
            n4 = 0;
            while (n4 < 32) {
                int n7 = n4++;
                n6 = n7 + 32;
                byArray5[n6] = byArray3[n2 + n7];
            }
        }
        n4 = n2 + 32;
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            if (((n >>>= 1) & 1) != 0) {
                n6 = (n2 + 7) * 2 * 32;
                hashFunctions.hash_2n_n_mask(byArray5, 32, byArray5, 0, byArray4, n6);
                for (n6 = 0; n6 < 32; ++n6) {
                    byArray5[n6] = byArray3[n4 + n6];
                }
            } else {
                n6 = (n2 + 7) * 2 * 32;
                hashFunctions.hash_2n_n_mask(byArray5, 0, byArray5, 0, byArray4, n6);
                n6 = 0;
                while (n6 < 32) {
                    int n8 = n6++;
                    n5 = n8 + 32;
                    byArray5[n5] = byArray3[n4 + n8];
                }
            }
            n4 += 32;
        }
        int n9 = (n3 + 7 - 1) * 2 * 32;
        hashFunctions.hash_2n_n_mask(byArray, 0, byArray5, 0, byArray4, n9);
    }

    public static void compute_authpath_wots(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, int n, Tree.leafaddr leafaddr2, byte[] object, byte[] byArray3, int n2) {
        int n3;
        Wots wots;
        long l;
        Tree.leafaddr leafaddr3;
        Tree.leafaddr leafaddr4 = leafaddr3;
        byte[] byArray4 = new byte[2048];
        byte[] byArray5 = new byte[1024];
        byte[] byArray6 = new byte[68608];
        new Tree.leafaddr((Tree.leafaddr)leafaddr2).subleaf = 0L;
        while ((l = leafaddr4.subleaf++) < 32L) {
            Seed.get_seed(hashFunctions, byArray5, (int)(l * 32L), (byte[])object, leafaddr4);
        }
        object = wots;
        wots = new Wots();
        leafaddr4.subleaf = 0L;
        while ((l = leafaddr4.subleaf++) < 32L) {
            long l2 = l;
            int n4 = (int)(l2 * 67L * 32L);
            n3 = (int)(l2 * 32L);
            ((Wots)object).wots_pkgen(hashFunctions, byArray6, n4, byArray5, n3, byArray3, 0);
        }
        leafaddr4.subleaf = 0L;
        while ((l = leafaddr4.subleaf++) < 32L) {
            long l3 = l;
            int n5 = (int)(l3 * 32L + 1024L);
            int n6 = (int)(l3 * 67L * 32L);
            Tree.l_tree(hashFunctions, byArray4, n5, byArray6, n6, byArray3, 0);
        }
        int n7 = 0;
        for (int k = 32; k > 0; k >>>= 1) {
            for (int i2 = 0; i2 < k; i2 += 2) {
                int n8 = (k >>> 1) * 32;
                n8 = (i2 >>> 1) * 32 + n8;
                int n9 = k * 32;
                n9 = i2 * 32 + n9;
                n3 = (n7 + 7) * 2 * 32;
                hashFunctions.hash_2n_n_mask(byArray4, n8, byArray4, n9, byArray3, n3);
            }
            ++n7;
        }
        int n10 = (int)leafaddr2.subleaf;
        for (int k = 0; k < n2; ++k) {
            n7 = (32 >>> k) * 32;
            n7 = (n10 >>> k ^ 1) * 32 + n7;
            int n11 = k * 32 + n;
            System.arraycopy(byArray4, n7, byArray2, n11, 32);
        }
        System.arraycopy(byArray4, 32, byArray, 0, 32);
    }

    private void zerobytes(byte[] byArray, int n, int n2) {
        for (int k = 0; k != n2; ++k) {
            byArray[n + k] = 0;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.keyData = bl ? (cipherParameters instanceof ParametersWithRandom ? ((SPHINCSPrivateKeyParameters)((ParametersWithRandom)cipherParameters).getParameters()).getKeyData() : ((SPHINCSPrivateKeyParameters)cipherParameters).getKeyData()) : ((SPHINCSPublicKeyParameters)cipherParameters).getKeyData();
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        SPHINCS256Signer sPHINCS256Signer = hashFunctions;
        HashFunctions hashFunctions = sPHINCS256Signer.hashFunctions;
        byte[] byArray2 = sPHINCS256Signer.keyData;
        return sPHINCS256Signer.crypto_sign(hashFunctions, byArray, byArray2);
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        SPHINCS256Signer sPHINCS256Signer = hashFunctions;
        HashFunctions hashFunctions = sPHINCS256Signer.hashFunctions;
        byte[] byArray3 = sPHINCS256Signer.keyData;
        return sPHINCS256Signer.verify(hashFunctions, byArray, byArray2, byArray3);
    }

    public byte[] crypto_sign(HashFunctions hashFunctions, byte[] object, byte[] object2) {
        Wots wots;
        int n;
        Tree.leafaddr leafaddr2;
        Tree.leafaddr leafaddr3;
        int n2;
        byte[] byArray = new byte[41000];
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[64];
        int n3 = 8;
        long[] lArray = new long[8];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[1024];
        byte[] byArray7 = new byte[1088];
        for (n2 = 0; n2 < 1088; ++n2) {
            byArray7[n2] = object2[n2];
        }
        System.arraycopy(byArray7, 1056, byArray, 40968, 32);
        Digest digest = hashFunctions.getMessageHash();
        Object object3 = object2 = (Object)digest;
        object2 = new byte[object2.getDigestSize()];
        object3.update(byArray, 40968, 32);
        digest.update((byte[])object, 0, ((byte[])object).length);
        digest.doFinal((byte[])object2, 0);
        this.zerobytes(byArray, 40968, 32);
        for (n2 = 0; n2 != n3; ++n2) {
            lArray[n2] = Pack.littleEndianToLong((byte[])object2, n2 * 8);
        }
        HashFunctions hashFunctions2 = hashFunctions;
        long l = lArray[0] & 0xFFFFFFFFFFFFFFFL;
        System.arraycopy(object2, 16, byArray2, 0, 32);
        System.arraycopy(byArray2, 0, byArray, 39912, 32);
        object2 = leafaddr3;
        new Tree.leafaddr().level = 11;
        new Tree.leafaddr().subtree = 0L;
        new Tree.leafaddr().subleaf = 0L;
        System.arraycopy(byArray7, 32, byArray, 39944, 1024);
        Tree.treehash(hashFunctions2, byArray, 40968, 5, byArray7, (Tree.leafaddr)object2, byArray, 39944);
        Digest digest2 = hashFunctions2.getMessageHash();
        object2 = digest2;
        object2.update(byArray, 39912, 1088);
        object2.update((byte[])object, 0, ((byte[])object).length);
        digest2.doFinal(byArray3, 0);
        object = leafaddr2;
        object();
        object.level = 12;
        object.subleaf = (int)(l & 0x1FL);
        leafaddr2.subtree = l >>> 5;
        for (n = 0; n < 32; ++n) {
            byArray[n] = byArray2[n];
        }
        n = 32;
        System.arraycopy(byArray7, 32, byArray6, 0, 1024);
        for (int k = 0; k < 8; ++k) {
            n2 = n + k;
            byArray[n2] = (byte)(l >>> k * 8 & 0xFFL);
        }
        Seed.get_seed(hashFunctions, byArray5, 0, byArray7, (Tree.leafaddr)object);
        new Horst();
        n = 40 + Horst.horst_sign(hashFunctions, byArray, 40, byArray4, byArray5, byArray6, byArray3);
        Wots wots2 = wots;
        wots = new Wots();
        int n4 = 0;
        while (n4 < 12) {
            HashFunctions hashFunctions3 = hashFunctions;
            object.level = n4++;
            Seed.get_seed(hashFunctions3, byArray5, 0, byArray7, (Tree.leafaddr)object);
            wots2.wots_sign(hashFunctions3, byArray, n, byArray4, byArray5, byArray6);
            SPHINCS256Signer.compute_authpath_wots(hashFunctions, byArray4, byArray, n += 2144, (Tree.leafaddr)object, byArray7, byArray6, 5);
            n += 160;
            l = object.subtree;
            object.subleaf = (int)(l & 0x1FL);
            object.subtree = l >>> 5;
        }
        this.zerobytes(byArray7, 0, 1088);
        return byArray;
    }

    public boolean verify(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        long l = 0L;
        Object object = new byte[2144];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[41000];
        byte[] byArray7 = new byte[1056];
        if (byArray2.length == 41000) {
            Wots wots;
            int n;
            byte[] byArray8 = new byte[64];
            for (n = 0; n < 1056; ++n) {
                byArray7[n] = byArray3[n];
            }
            byArray3 = new byte[32];
            for (n = 0; n < 32; ++n) {
                byArray3[n] = byArray2[n];
            }
            System.arraycopy(byArray2, 0, byArray6, 0, 41000);
            Digest digest = hashFunctions.getMessageHash();
            digest.update(byArray3, 0, 32);
            digest.update(byArray7, 0, 1056);
            int n2 = byArray.length;
            digest.update(byArray, 0, n2);
            digest.doFinal(byArray8, 0);
            int n3 = 32;
            for (n2 = 0; n2 < 8; ++n2) {
                l ^= (long)(byArray6[n3 + n2] & 0xFF) << n2 * 8;
            }
            new Horst();
            Horst.horst_verify(hashFunctions, byArray5, byArray6, 40, byArray7, byArray8);
            n3 = 13352;
            Wots wots2 = wots;
            wots = new Wots();
            for (int k = 0; k < 12; ++k) {
                wots2.wots_verify(hashFunctions, (byte[])object, byArray6, n3, byArray5, byArray7);
                Tree.l_tree(hashFunctions, byArray4, 0, (byte[])object, 0, byArray7, 0);
                SPHINCS256Signer.validate_authpath(hashFunctions, byArray5, byArray4, (int)(l & 0x1FL), byArray6, n3 += 2144, byArray7, 5);
                l >>= 5;
                n3 += 160;
            }
            boolean bl = true;
            for (int k = 0; k < 32; ++k) {
                if (byArray5[k] == byArray7[k + 1024]) continue;
                bl = false;
            }
            return bl;
        }
        throw new IllegalArgumentException("signature wrong size");
    }
}

