/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import java.io.IOException;

public class SubjectPublicKeyInfoFactory {
    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter object) {
        if (object instanceof QTESLAPublicKeyParameters) {
            object = (QTESLAPublicKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(((QTESLAPublicKeyParameters)object).getSecurityCategory());
            return new SubjectPublicKeyInfo(algorithmIdentifier, ((QTESLAPublicKeyParameters)object).getPublicData());
        }
        if (object instanceof SPHINCSPublicKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (SPHINCSPublicKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(((SPHINCSKeyParameters)object).getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier2, ((SPHINCSPublicKeyParameters)object).getKeyData());
        }
        if (object instanceof NHPublicKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (NHPublicKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            return new SubjectPublicKeyInfo(algorithmIdentifier3, ((NHPublicKeyParameters)object).getPubData());
        }
        if (object instanceof LMSPublicKeyParameters) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            object = Composer.compose().u32str(1).bytes((LMSPublicKeyParameters)object).build();
            ASN1Object aSN1Object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            AlgorithmIdentifier algorithmIdentifier4 = aSN1Object;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object);
            return new SubjectPublicKeyInfo(algorithmIdentifier4, aSN1Object);
        }
        if (object instanceof HSSPublicKeyParameters) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            object = (HSSPublicKeyParameters)object;
            object = Composer.compose().u32str(((HSSPublicKeyParameters)object).getL()).bytes(((HSSPublicKeyParameters)object).getLMSPublicKey()).build();
            ASN1Object aSN1Object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            AlgorithmIdentifier algorithmIdentifier5 = aSN1Object;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object);
            return new SubjectPublicKeyInfo(algorithmIdentifier5, aSN1Object);
        }
        if (object instanceof XMSSPublicKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (XMSSPublicKeyParameters)object;
            byte[] byArray = ((XMSSPublicKeyParameters)object).getPublicSeed();
            byte[] byArray2 = ((XMSSPublicKeyParameters)object).getRoot();
            Object object2 = ((XMSSPublicKeyParameters)object).getEncoded();
            if (((byte[])object2).length > byArray.length + byArray2.length) {
                DEROctetString dEROctetString;
                AlgorithmIdentifier algorithmIdentifier6;
                object = algorithmIdentifier6;
                algorithmIdentifier6 = new AlgorithmIdentifier(IsaraObjectIdentifiers.id_alg_xmss);
                Object object3 = object;
                object = dEROctetString;
                dEROctetString = new DEROctetString((byte[])object2);
                return new SubjectPublicKeyInfo((AlgorithmIdentifier)object3, (ASN1Encodable)object);
            }
            object2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(((XMSSPublicKeyParameters)object).getParameters().getHeight(), Utils.xmssLookupTreeAlgID(((XMSSKeyParameters)object).getTreeDigest())));
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)object2, new XMSSPublicKey(byArray, byArray2));
        }
        if (object instanceof XMSSMTPublicKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (XMSSMTPublicKeyParameters)object;
            Object object4 = ((XMSSMTPublicKeyParameters)object).getPublicSeed();
            byte[] byArray = ((XMSSMTPublicKeyParameters)object).getRoot();
            byte[] byArray3 = ((XMSSMTPublicKeyParameters)object).getEncoded();
            if (byArray3.length > ((byte[])object4).length + byArray.length) {
                DEROctetString dEROctetString;
                AlgorithmIdentifier algorithmIdentifier7;
                object = algorithmIdentifier7;
                algorithmIdentifier7 = new AlgorithmIdentifier(IsaraObjectIdentifiers.id_alg_xmssmt);
                Object object5 = object;
                object = dEROctetString;
                dEROctetString = new DEROctetString(byArray3);
                return new SubjectPublicKeyInfo((AlgorithmIdentifier)object5, (ASN1Encodable)object);
            }
            object4 = algorithmIdentifier;
            Object object6 = object;
            int n = ((XMSSMTPublicKeyParameters)object6).getParameters().getLayers();
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(((XMSSMTPublicKeyParameters)object).getParameters().getHeight(), n, Utils.xmssLookupTreeAlgID(((XMSSMTKeyParameters)object6).getTreeDigest())));
            Object object7 = object;
            object = ((XMSSMTPublicKeyParameters)object7).getPublicSeed();
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)object4, new XMSSMTPublicKey((byte[])object, ((XMSSMTPublicKeyParameters)object7).getRoot()));
        }
        throw new IOException("key parameters not recognized");
    }
}

