/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public abstract class XMSSAddress {
    private final int layerAddress;
    private final long treeAddress;
    private final int type;
    private final int keyAndMask;

    public XMSSAddress(Builder builder) {
        this.layerAddress = builder.layerAddress;
        this.treeAddress = builder.treeAddress;
        this.type = builder.type;
        this.keyAndMask = builder.keyAndMask;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[32];
        XMSSAddress xMSSAddress = this;
        Pack.intToBigEndian(xMSSAddress.layerAddress, byArray, 0);
        Pack.longToBigEndian(xMSSAddress.treeAddress, byArray, 4);
        Pack.intToBigEndian(xMSSAddress.type, byArray, 12);
        Pack.intToBigEndian(xMSSAddress.keyAndMask, byArray, 28);
        return byArray;
    }

    public final int getLayerAddress() {
        return this.layerAddress;
    }

    public final long getTreeAddress() {
        return this.treeAddress;
    }

    public final int getType() {
        return this.type;
    }

    public final int getKeyAndMask() {
        return this.keyAndMask;
    }

    public static abstract class Builder<T extends Builder> {
        private final int type;
        private int layerAddress = 0;
        private long treeAddress = 0L;
        private int keyAndMask = 0;

        public Builder(int n) {
            this.type = n;
        }

        public T withLayerAddress(int n) {
            this.layerAddress = n;
            return this.getThis();
        }

        public T withTreeAddress(long l) {
            this.treeAddress = l;
            return this.getThis();
        }

        public T withKeyAndMask(int n) {
            this.keyAndMask = n;
            return this.getThis();
        }

        public abstract XMSSAddress build();

        public abstract T getThis();
    }
}

