/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public final class XMSSMT {
    private XMSSMTParameters params;
    private XMSSParameters xmssParams;
    private SecureRandom prng;
    private XMSSMTPrivateKeyParameters privateKey;
    private XMSSMTPublicKeyParameters publicKey;

    public XMSSMT(XMSSMTParameters xMSSMTParameters, SecureRandom secureRandom) {
        if (xMSSMTParameters != null) {
            XMSSMT xMSSMT = this;
            this.params = xMSSMTParameters;
            this.xmssParams = xMSSMTParameters.getXMSSParameters();
            xMSSMT.prng = secureRandom;
            xMSSMT.privateKey = new XMSSMTPrivateKeyParameters.Builder(xMSSMTParameters).build();
            xMSSMT.publicKey = new XMSSMTPublicKeyParameters.Builder(xMSSMTParameters).build();
            return;
        }
        throw new NullPointerException("params == null");
    }

    private void importState(XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters, XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters) {
        this.xmssParams.getWOTSPlus().importKeys(new byte[this.params.getTreeDigestSize()], this.privateKey.getPublicSeed());
        this.privateKey = xMSSMTPrivateKeyParameters;
        this.publicKey = xMSSMTPublicKeyParameters;
    }

    public void generateKeys() {
        XMSSMT xMSSMT = object;
        XMSSMTKeyPairGenerator xMSSMTKeyPairGenerator = new XMSSMTKeyPairGenerator();
        XMSSMT xMSSMT2 = object;
        Object object = xMSSMT2.getParams();
        xMSSMTKeyPairGenerator.init(new XMSSMTKeyGenerationParameters((XMSSMTParameters)object, xMSSMT2.prng));
        object = xMSSMTKeyPairGenerator.generateKeyPair();
        xMSSMT.privateKey = (XMSSMTPrivateKeyParameters)((AsymmetricCipherKeyPair)object).getPrivate();
        object = (XMSSMTPublicKeyParameters)((AsymmetricCipherKeyPair)object).getPublic();
        xMSSMT.publicKey = object;
        xMSSMT.importState(xMSSMT.privateKey, (XMSSMTPublicKeyParameters)object);
    }

    public void importState(byte[] object, byte[] object2) {
        if (object != null) {
            if (object2 != null) {
                XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(((XMSSMT)object3).params).withPrivateKey((byte[])object).build();
                object = xMSSMTPrivateKeyParameters;
                object2 = new XMSSMTPublicKeyParameters.Builder(((XMSSMT)object3).params).withPublicKey((byte[])object2).build();
                if (Arrays.areEqual(xMSSMTPrivateKeyParameters.getRoot(), ((XMSSMTPublicKeyParameters)object2).getRoot())) {
                    if (Arrays.areEqual(((XMSSMTPrivateKeyParameters)object).getPublicSeed(), ((XMSSMTPublicKeyParameters)object2).getPublicSeed())) {
                        XMSSMT xMSSMT = object3;
                        XMSSMT xMSSMT2 = object3;
                        Object object3 = new byte[((XMSSMT)object3).params.getTreeDigestSize()];
                        ((XMSSMT)object3).xmssParams.getWOTSPlus().importKeys((byte[])object3, ((XMSSMTPrivateKeyParameters)object).getPublicSeed());
                        xMSSMT2.privateKey = object;
                        xMSSMT.publicKey = object2;
                        return;
                    }
                    throw new IllegalStateException("public seed of private key and public key do not match");
                }
                throw new IllegalStateException("root of private key and public key do not match");
            }
            throw new NullPointerException("publicKey == null");
        }
        throw new NullPointerException("privateKey == null");
    }

    public byte[] sign(byte[] byArray) {
        if (byArray != null) {
            XMSSMTSigner xMSSMTSigner;
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner2();
            xMSSMTSigner2.init(true, ((XMSSMT)((Object)xMSSMTPrivateKeyParameters)).privateKey);
            byte[] byArray2 = xMSSMTSigner.generateSignature(byArray);
            XMSSMT xMSSMT = xMSSMTPrivateKeyParameters;
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = (XMSSMTPrivateKeyParameters)xMSSMTSigner2.getUpdatedPrivateKey();
            xMSSMT.privateKey = xMSSMTPrivateKeyParameters;
            xMSSMT.importState(xMSSMTPrivateKeyParameters, xMSSMT.publicKey);
            return byArray2;
        }
        throw new NullPointerException("message == null");
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray != null) {
            if (byArray2 != null) {
                if (byArray3 != null) {
                    XMSSMTSigner xMSSMTSigner = new XMSSMTSigner();
                    xMSSMTSigner.init(false, new XMSSMTPublicKeyParameters.Builder(this.getParams()).withPublicKey(byArray3).build());
                    return xMSSMTSigner.verifySignature(byArray, byArray2);
                }
                throw new NullPointerException("publicKey == null");
            }
            throw new NullPointerException("signature == null");
        }
        throw new NullPointerException("message == null");
    }

    public byte[] exportPrivateKey() {
        return this.privateKey.toByteArray();
    }

    public byte[] exportPublicKey() {
        return this.publicKey.toByteArray();
    }

    public XMSSMTParameters getParams() {
        return this.params;
    }

    public byte[] getPublicSeed() {
        return this.privateKey.getPublicSeed();
    }

    public XMSSParameters getXMSS() {
        return this.xmssParams;
    }
}

