/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.IOException;

public final class XMSSPrivateKeyParameters
extends XMSSKeyParameters
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSParameters params;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private volatile BDS bdsState;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMSSPrivateKeyParameters(Builder builder) {
        super(true, builder.params.getTreeDigest());
        Object object = builder.params;
        this.params = object;
        if (object == null) throw new NullPointerException("params == null");
        int n = ((XMSSParameters)object).getTreeDigestSize();
        byte[] byArray = builder.privateKey;
        if (byArray != null) {
            int n2 = Pack.bigEndianToInt(byArray, 0);
            if (!XMSSUtil.isIndexValid(((XMSSParameters)object).getHeight(), n2)) throw new IllegalArgumentException("index out of bounds");
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(byArray, 4, n);
            int n3 = 4 + n;
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(byArray, n3, n);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n3 += n, n);
            this.root = XMSSUtil.extractBytesAtOffset(byArray, n3 += n, n);
            int n4 = n3 + n;
            BDS bDS = (BDS)XMSSUtil.deserialize(XMSSUtil.extractBytesAtOffset(byArray, n4, byArray.length - n4), BDS.class);
            if (bDS.getIndex() != n2) throw new IllegalStateException("serialized BDS has wrong index");
            try {
                this.bdsState = bDS.withWOTSDigest(builder.params.getTreeDigestOID());
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
        } else {
            byArray = builder.secretKeySeed;
            if (byArray != null) {
                if (byArray.length != n) throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                this.secretKeySeed = byArray;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byte[] byArray2 = builder.secretKeyPRF;
            if (byArray2 != null) {
                if (byArray2.length != n) throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                this.secretKeyPRF = byArray2;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byArray2 = builder.publicSeed;
            if (byArray2 != null) {
                if (byArray2.length != n) throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                this.publicSeed = byArray2;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] byArray3 = builder.root;
            if (byArray3 != null) {
                if (byArray3.length != n) throw new IllegalArgumentException("size of root needs to be equal size of digest");
                this.root = byArray3;
            } else {
                this.root = new byte[n];
            }
            BDS bDS = builder.bdsState;
            if (bDS != null) {
                this.bdsState = bDS;
            } else if (builder.index < (1 << ((XMSSParameters)object).getHeight()) - 2 && byArray2 != null && byArray != null) {
                XMSSParameters xMSSParameters = object;
                object = (OTSHashAddress)new OTSHashAddress.Builder().build();
                int n5 = builder.index;
                this.bdsState = new BDS(xMSSParameters, byArray2, byArray, (OTSHashAddress)object, n5);
            } else {
                int n6 = (1 << ((XMSSParameters)object).getHeight()) - 1;
                this.bdsState = new BDS((XMSSParameters)object, n6, builder.index);
            }
            if (builder.maxIndex < 0 || builder.maxIndex == this.bdsState.getMaxIndex()) return;
            throw new IllegalArgumentException("maxIndex set but not reflected in state");
        }
    }

    public /* synthetic */ XMSSPrivateKeyParameters(Builder builder, 1 var2_2) {
        this(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsagesRemaining() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            int n = xMSSPrivateKeyParameters.bdsState.getMaxIndex() - this.getIndex();
            // ** MonitorExit[this] (shouldn't be in output)
            return n + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncoded() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            // ** MonitorExit[this] (shouldn't be in output)
            return xMSSPrivateKeyParameters.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMSSPrivateKeyParameters rollKey() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            if (xMSSPrivateKeyParameters.bdsState.getIndex() < this.bdsState.getMaxIndex()) {
                XMSSPrivateKeyParameters xMSSPrivateKeyParameters2 = this;
                byte[] byArray = xMSSPrivateKeyParameters2.publicSeed;
                byte[] byArray2 = xMSSPrivateKeyParameters2.secretKeySeed;
                this.bdsState = this.bdsState.getNextState(byArray, byArray2, (OTSHashAddress)new OTSHashAddress.Builder().build());
            } else {
                XMSSPrivateKeyParameters xMSSPrivateKeyParameters3 = this;
                int n = xMSSPrivateKeyParameters3.bdsState.getMaxIndex();
                this.bdsState = new BDS(this.params, n, xMSSPrivateKeyParameters3.bdsState.getMaxIndex() + 1);
            }
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters4 = this;
            // ** MonitorExit[v3] (shouldn't be in output)
            return xMSSPrivateKeyParameters4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMSSPrivateKeyParameters getNextKey() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            // ** MonitorExit[this] (shouldn't be in output)
            return xMSSPrivateKeyParameters.extractKeyShard(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public XMSSPrivateKeyParameters extractKeyShard(int n) {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters;
        block8: {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters2;
            byte[] byArray;
            if (n < 1) throw new IllegalArgumentException("cannot ask for a shard with 0 keys");
            // MONITORENTER : this
            long l = n;
            if (l > this.getUsagesRemaining()) throw new IllegalArgumentException("usageCount exceeds usages remaining");
            xMSSPrivateKeyParameters = new Builder(this.params).withSecretKeySeed(this.secretKeySeed).withSecretKeyPRF(this.secretKeyPRF).withPublicSeed(this.publicSeed).withRoot(this.root).withIndex(this.getIndex()).withBDSState(this.bdsState.withMaxIndex(this.bdsState.getIndex() + n - 1, this.params.getTreeDigestOID())).build();
            if (l == this.getUsagesRemaining()) {
                XMSSPrivateKeyParameters xMSSPrivateKeyParameters3 = this;
                int n2 = xMSSPrivateKeyParameters3.bdsState.getMaxIndex();
                this.bdsState = new BDS(this.params, n2, xMSSPrivateKeyParameters3.getIndex() + n);
                break block8;
            }
            OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().build();
            for (int n3 = 0; n3 != n; this.bdsState = this.bdsState.getNextState(byArray, xMSSPrivateKeyParameters2.secretKeySeed, oTSHashAddress), ++n3) {
                xMSSPrivateKeyParameters2 = this;
                byArray = xMSSPrivateKeyParameters2.publicSeed;
            }
        }
        // MONITOREXIT : this
        return xMSSPrivateKeyParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            int n;
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters2;
            byte[] byArray;
            int n2 = xMSSPrivateKeyParameters.params.getTreeDigestSize();
            {
                byArray = new byte[n2 + 4 + n2 + n2 + n2];
                xMSSPrivateKeyParameters2 = this;
                n = 0;
            }
            {
                Pack.intToBigEndian(xMSSPrivateKeyParameters2.bdsState.getIndex(), byArray, n);
                n = 4;
            }
            {
                XMSSUtil.copyBytesAtOffset(byArray, this.secretKeySeed, n);
                n = 4 + n2;
            }
            {
                XMSSUtil.copyBytesAtOffset(byArray, this.secretKeyPRF, n);
            }
            {
                byte[] byArray2;
                XMSSUtil.copyBytesAtOffset(byArray, this.publicSeed, n += n2);
                n2 = n + n2;
                XMSSUtil.copyBytesAtOffset(byArray, xMSSPrivateKeyParameters2.root, n2);
                try {
                    byArray2 = Arrays.concatenate(byArray, XMSSUtil.serialize(this.bdsState));
                }
                catch (IOException iOException) {
                    throw new RuntimeException("error serializing bds state: " + iOException.getMessage());
                }
                return byArray2;
            }
        }
    }

    public int getIndex() {
        return this.bdsState.getIndex();
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public BDS getBDSState() {
        return this.bdsState;
    }

    public XMSSParameters getParameters() {
        return this.params;
    }

    public static class Builder {
        private final XMSSParameters params;
        private int index = 0;
        private int maxIndex = -1;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private BDS bdsState = null;
        private byte[] privateKey = null;

        public Builder(XMSSParameters xMSSParameters) {
            this.params = xMSSParameters;
        }

        public Builder withIndex(int n) {
            this.index = n;
            return this;
        }

        public Builder withMaxIndex(int n) {
            this.maxIndex = n;
            return this;
        }

        public Builder withSecretKeySeed(byte[] byArray) {
            this.secretKeySeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] byArray) {
            this.secretKeyPRF = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withBDSState(BDS bDS) {
            this.bdsState = bDS;
            return this;
        }

        public Builder withPrivateKey(byte[] byArray) {
            this.privateKey = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public XMSSPrivateKeyParameters build() {
            return new XMSSPrivateKeyParameters(this, null);
        }
    }
}

