/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.frodo;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.FrodoKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.FrodoParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCFrodoPrivateKey
implements PrivateKey,
FrodoKey {
    private static final long serialVersionUID = 1L;
    private transient FrodoPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCFrodoPrivateKey(FrodoPrivateKeyParameters frodoPrivateKeyParameters) {
        this.params = frodoPrivateKeyParameters;
    }

    public BCFrodoPrivateKey(PrivateKeyInfo privateKeyInfo) {
        BCFrodoPrivateKey bCFrodoPrivateKey = this;
        bCFrodoPrivateKey.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (FrodoPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(PrivateKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    public boolean equals(Object object) {
        if (object == bCFrodoPrivateKey2) {
            return true;
        }
        if (object instanceof BCFrodoPrivateKey) {
            BCFrodoPrivateKey bCFrodoPrivateKey = bCFrodoPrivateKey2;
            BCFrodoPrivateKey bCFrodoPrivateKey2 = (BCFrodoPrivateKey)object;
            return Arrays.areEqual(bCFrodoPrivateKey.params.getEncoded(), bCFrodoPrivateKey2.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "Frodo";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public FrodoParameterSpec getParameterSpec() {
        return FrodoParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public FrodoPrivateKeyParameters getKeyParams() {
        return this.params;
    }
}

