/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.frodo;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.frodo.FrodoPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.FrodoKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.FrodoParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCFrodoPublicKey
implements PublicKey,
FrodoKey {
    private static final long serialVersionUID = 1L;
    private transient FrodoPublicKeyParameters params;

    public BCFrodoPublicKey(FrodoPublicKeyParameters frodoPublicKeyParameters) {
        this.params = frodoPublicKeyParameters;
    }

    public BCFrodoPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        BCFrodoPublicKey bCFrodoPublicKey = this;
        bCFrodoPublicKey.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.params = (FrodoPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(SubjectPublicKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    public boolean equals(Object object) {
        if (object == bCFrodoPublicKey2) {
            return true;
        }
        if (object instanceof BCFrodoPublicKey) {
            BCFrodoPublicKey bCFrodoPublicKey = bCFrodoPublicKey2;
            BCFrodoPublicKey bCFrodoPublicKey2 = (BCFrodoPublicKey)object;
            return Arrays.areEqual(bCFrodoPublicKey.params.getEncoded(), bCFrodoPublicKey2.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "Frodo";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public FrodoParameterSpec getParameterSpec() {
        return FrodoParameterSpec.fromName(this.params.getParameters().getName());
    }

    public FrodoPublicKeyParameters getKeyParams() {
        return this.params;
    }
}

