/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.NullDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContextBasedSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.lms.BCLMSPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.lms.BCLMSPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.lms.DigestUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class LMSSignatureSpi
extends Signature {
    private Digest digest;
    private MessageSigner signer;
    private SecureRandom random;
    private LMSContextBasedSigner lmOtsSigner;
    private LMSContextBasedVerifier lmOtsVerifier;

    public LMSSignatureSpi(String string) {
        super(string);
    }

    public LMSSignatureSpi(String string, Digest digest) {
        super(string);
        this.digest = digest;
    }

    private Digest getSigner() {
        try {
            return this.lmOtsSigner.generateLMSContext();
        }
        catch (ExhaustedPrivateKeyException exhaustedPrivateKeyException) {
            throw new SignatureException(exhaustedPrivateKeyException.getMessage(), exhaustedPrivateKeyException);
        }
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        if (publicKey instanceof BCLMSPublicKey) {
            this.digest = new NullDigest();
            this.digest.reset();
            this.lmOtsVerifier = (LMSContextBasedVerifier)((Object)((BCLMSPublicKey)publicKey).getKeyParams());
            return;
        }
        throw new InvalidKeyException("unknown public key passed to XMSS");
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        if (object instanceof BCLMSPrivateKey) {
            object = (LMSContextBasedSigner)((Object)((BCLMSPrivateKey)object).getKeyParams());
            this.lmOtsSigner = object;
            if (object.getUsagesRemaining() != 0L) {
                this.digest = null;
                return;
            }
            throw new InvalidKeyException("private key exhausted");
        }
        throw new InvalidKeyException("unknown private key passed to LMS");
    }

    @Override
    public void engineUpdate(byte by) {
        if (this.digest == null) {
            this.digest = this.getSigner();
        }
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.digest == null) {
            this.digest = this.getSigner();
        }
        this.digest.update(byArray, n, n2);
    }

    @Override
    public byte[] engineSign() {
        if (this.digest == null) {
            this.digest = this.getSigner();
        }
        try {
            this.digest = null;
            return this.lmOtsSigner.generateSignature((LMSContext)this.digest);
        }
        catch (Exception exception) {
            if (exception instanceof IllegalStateException) {
                throw new SignatureException(exception.getMessage(), exception);
            }
            throw new SignatureException(((Object)exception).toString(), exception);
        }
    }

    @Override
    public boolean engineVerify(byte[] object) {
        LMSSignatureSpi lMSSignatureSpi = this;
        LMSContext lMSContext = lMSSignatureSpi.lmOtsVerifier.generateLMSContext((byte[])object);
        object = lMSContext;
        byte[] byArray = DigestUtil.getDigestResult(this.digest);
        lMSContext.update(byArray, 0, byArray.length);
        return lMSSignatureSpi.lmOtsVerifier.verify((LMSContext)object);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class generic
    extends LMSSignatureSpi {
        public generic() {
            NullDigest nullDigest;
            generic generic2 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            super("LMS", nullDigest2);
        }
    }
}

