/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.QTESLAKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCqTESLAPrivateKey
implements PrivateKey,
QTESLAKey {
    private static final long serialVersionUID = 1L;
    private transient QTESLAPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCqTESLAPrivateKey(QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters) {
        this.keyParams = qTESLAPrivateKeyParameters;
    }

    public BCqTESLAPrivateKey(PrivateKeyInfo privateKeyInfo) {
        BCqTESLAPrivateKey bCqTESLAPrivateKey = this;
        bCqTESLAPrivateKey.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) {
        this.attributes = privateKeyInfo.getAttributes();
        this.keyParams = (QTESLAPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(PrivateKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return QTESLASecurityCategory.getName(this.keyParams.getSecurityCategory());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public QTESLAParameterSpec getParams() {
        return new QTESLAParameterSpec(this.getAlgorithm());
    }

    @Override
    public byte[] getEncoded() {
        try {
            return PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCqTESLAPrivateKey) {
            object = (BCqTESLAPrivateKey)object;
            return this.keyParams.getSecurityCategory() == ((BCqTESLAPrivateKey)object).keyParams.getSecurityCategory() && Arrays.areEqual(this.keyParams.getSecret(), ((BCqTESLAPrivateKey)object).keyParams.getSecret());
        }
        return false;
    }

    public int hashCode() {
        BCqTESLAPrivateKey bCqTESLAPrivateKey = this;
        int n = bCqTESLAPrivateKey.keyParams.getSecurityCategory();
        return Arrays.hashCode(bCqTESLAPrivateKey.keyParams.getSecret()) * 37 + n;
    }

    public CipherParameters getKeyParams() {
        return this.keyParams;
    }
}

