/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.rainbow;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.RainbowPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.RainbowPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.Layer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.RainbowPrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.RainbowPublicKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RainbowKeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof RainbowPrivateKeySpec) {
            return new BCRainbowPrivateKey((RainbowPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return this.generatePrivate(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(((PKCS8EncodedKeySpec)keySpec).getEncoded())));
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(((Object)exception).toString());
            }
        }
        throw new InvalidKeySpecException(b.a("Unsupported key specification: ").append(keySpec.getClass()).append(".").toString());
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) {
        if (keySpec instanceof RainbowPublicKeySpec) {
            return new BCRainbowPublicKey((RainbowPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                return this.generatePublic(SubjectPublicKeyInfo.getInstance(((X509EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(((Object)exception).toString());
            }
        }
        throw new InvalidKeySpecException("Unknown key specification: " + keySpec + ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final KeySpec engineGetKeySpec(Key object, Class object2) {
        if (object instanceof BCRainbowPrivateKey) {
            if (PKCS8EncodedKeySpec.class.isAssignableFrom((Class<?>)object2)) {
                return new PKCS8EncodedKeySpec(object.getEncoded());
            }
            if (!RainbowPrivateKeySpec.class.isAssignableFrom((Class<?>)object2)) throw new InvalidKeySpecException("Unknown key specification: " + object2 + ".");
            Object object3 = object4 = (BCRainbowPrivateKey)object;
            Object object4 = ((BCRainbowPrivateKey)object3).getInvA1();
            object = ((BCRainbowPrivateKey)object3).getB1();
            object2 = ((BCRainbowPrivateKey)object3).getInvA2();
            short[] sArray = ((BCRainbowPrivateKey)object3).getB2();
            int[] nArray = ((BCRainbowPrivateKey)object3).getVi();
            Layer[] layerArray = ((BCRainbowPrivateKey)object3).getLayers();
            return new RainbowPrivateKeySpec((short[][])object4, (short[])object, (short[][])object2, sArray, nArray, layerArray);
        }
        if (!(object instanceof BCRainbowPublicKey)) throw new InvalidKeySpecException(b.a("Unsupported key type: ").append(object.getClass()).append(".").toString());
        if (X509EncodedKeySpec.class.isAssignableFrom((Class<?>)object2)) {
            return new X509EncodedKeySpec(object.getEncoded());
        }
        if (!RainbowPublicKeySpec.class.isAssignableFrom((Class<?>)object2)) throw new InvalidKeySpecException("Unknown key specification: " + object2 + ".");
        Object object5 = object4 = (BCRainbowPublicKey)object;
        int n = ((BCRainbowPublicKey)object5).getDocLength();
        object = ((BCRainbowPublicKey)object5).getCoeffQuadratic();
        object2 = ((BCRainbowPublicKey)object5).getCoeffSingular();
        short[] sArray = ((BCRainbowPublicKey)object5).getCoeffScalar();
        return new RainbowPublicKeySpec(n, (short[][])object, (short[][])object2, sArray);
    }

    @Override
    public final Key engineTranslateKey(Key key) {
        if (!(key instanceof BCRainbowPrivateKey) && !(key instanceof BCRainbowPublicKey)) {
            throw new InvalidKeyException("Unsupported key type");
        }
        return key;
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo object) {
        Object object2 = object3 = RainbowPrivateKey.getInstance(((PrivateKeyInfo)object).parsePrivateKey());
        Object object3 = ((RainbowPrivateKey)object2).getInvA1();
        object = ((RainbowPrivateKey)object2).getB1();
        short[][] sArray = ((RainbowPrivateKey)object2).getInvA2();
        short[] sArray2 = ((RainbowPrivateKey)object2).getB2();
        int[] nArray = ((RainbowPrivateKey)object2).getVi();
        Layer[] layerArray = ((RainbowPrivateKey)object2).getLayers();
        return new BCRainbowPrivateKey((short[][])object3, (short[])object, sArray, sArray2, nArray, layerArray);
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo object) {
        Object object2 = this = RainbowPublicKey.getInstance(((SubjectPublicKeyInfo)object).parsePublicKey());
        int n = ((RainbowPublicKey)object2).getDocLength();
        object = ((RainbowPublicKey)object2).getCoeffQuadratic();
        short[][] sArray = ((RainbowPublicKey)object2).getCoeffSingular();
        short[] sArray2 = ((RainbowPublicKey)object2).getCoeffScalar();
        return new BCRainbowPublicKey(n, (short[][])object, sArray, sArray2);
    }
}

