/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.util.CipherSpiExt;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public abstract class AsymmetricBlockCipher
extends CipherSpiExt {
    public AlgorithmParameterSpec paramSpec;
    public ByteArrayOutputStream buf;
    public int maxPlainTextSize;
    public int cipherTextSize;

    public AsymmetricBlockCipher() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.buf = byteArrayOutputStream2;
    }

    @Override
    public final int getBlockSize() {
        return this.opMode == 1 ? this.maxPlainTextSize : this.cipherTextSize;
    }

    @Override
    public final byte[] getIV() {
        return null;
    }

    @Override
    public final int getOutputSize(int n) {
        if (this.buf.size() + n > this.getBlockSize()) {
            return 0;
        }
        return this.opMode == 1 ? this.cipherTextSize : this.maxPlainTextSize;
    }

    @Override
    public final AlgorithmParameterSpec getParameters() {
        return this.paramSpec;
    }

    public final void initEncrypt(Key key) {
        AsymmetricBlockCipher asymmetricBlockCipher = secureRandom;
        try {
            SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
        asymmetricBlockCipher.initEncrypt(key, null, secureRandom);
    }

    public final void initEncrypt(Key key, SecureRandom secureRandom) {
        try {
            this.initEncrypt(key, null, secureRandom);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    public final void initEncrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        AsymmetricBlockCipher asymmetricBlockCipher = secureRandom;
        SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
        asymmetricBlockCipher.initEncrypt(key, algorithmParameterSpec, secureRandom);
    }

    @Override
    public final void initEncrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        this.opMode = 1;
        this.initCipherEncrypt(key, algorithmParameterSpec, secureRandom);
    }

    public final void initDecrypt(Key key) {
        try {
            this.initDecrypt(key, null);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException("This cipher needs algorithm parameters for initialization (cannot be null).");
        }
    }

    @Override
    public final void initDecrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        this.opMode = 2;
        this.initCipherDecrypt(key, algorithmParameterSpec);
    }

    @Override
    public final byte[] update(byte[] byArray, int n, int n2) {
        if (n2 != 0) {
            this.buf.write(byArray, n, n2);
        }
        return new byte[0];
    }

    @Override
    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.update(byArray, n, n2);
        return 0;
    }

    @Override
    public final byte[] doFinal(byte[] byArray, int n, int n2) {
        AsymmetricBlockCipher asymmetricBlockCipher = this;
        this.checkLength(n2);
        asymmetricBlockCipher.update(byArray, n, n2);
        byArray = asymmetricBlockCipher.buf.toByteArray();
        asymmetricBlockCipher.buf.reset();
        n = asymmetricBlockCipher.opMode;
        if (n != 1) {
            if (n != 2) {
                return null;
            }
            return this.messageDecrypt(byArray);
        }
        return this.messageEncrypt(byArray);
    }

    @Override
    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray2.length >= this.getOutputSize(n2)) {
            byte[] byArray3 = this.doFinal(byArray, n, n2);
            int n4 = byArray3.length;
            System.arraycopy(byArray3, 0, byArray2, n3, n4);
            return byArray3.length;
        }
        throw new ShortBufferException("Output buffer too short.");
    }

    @Override
    public final void setMode(String string) {
    }

    @Override
    public final void setPadding(String string) {
    }

    public void checkLength(int n) {
        AsymmetricBlockCipher asymmetricBlockCipher = this;
        n = asymmetricBlockCipher.buf.size() + n;
        int n2 = asymmetricBlockCipher.opMode;
        if (n2 == 1) {
            if (n > this.maxPlainTextSize) {
                throw new IllegalBlockSizeException(b.a(new StringBuilder().append("The length of the plaintext (").append(n).append(" bytes) is not supported by the cipher (max. "), this.maxPlainTextSize, " bytes)."));
            }
        } else if (n2 == 2 && n != this.cipherTextSize) {
            throw new IllegalBlockSizeException(b.b.a("Illegal ciphertext length (expected ").append(this.cipherTextSize).append(" bytes, was ").append(n).append(" bytes).").toString());
        }
    }

    public abstract void initCipherEncrypt(Key var1, AlgorithmParameterSpec var2, SecureRandom var3);

    public abstract void initCipherDecrypt(Key var1, AlgorithmParameterSpec var2);

    public abstract byte[] messageEncrypt(byte[] var1);

    public abstract byte[] messageDecrypt(byte[] var1);
}

