/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.RandUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GF2Vector
extends Vector {
    private int[] v;

    public GF2Vector(int n) {
        if (n >= 0) {
            this.length = n;
            this.v = new int[n + 31 >> 5];
            return;
        }
        throw new ArithmeticException("Negative length.");
    }

    public GF2Vector(int n, SecureRandom secureRandom) {
        int n2;
        this.length = n;
        this.v = new int[n + 31 >> 5];
        for (int k = n2 = (v920403) - 1; k >= 0; --k) {
            this.v[k] = secureRandom.nextInt();
        }
        if ((n &= 0x1F) != 0) {
            this.v[n2] = this.v[n2] & (1 << n) - 1;
        }
    }

    public GF2Vector(int n, int n2, SecureRandom secureRandom) {
        if (n2 <= n) {
            this.length = n;
            this.v = new int[n + 31 >> 5];
            int[] nArray = new int[n];
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3++;
                nArray[n4] = n4;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                int n5 = RandUtils.nextInt(secureRandom, n);
                this.setBit(nArray[n5]);
                nArray[n5] = nArray[n += -1];
            }
            return;
        }
        throw new ArithmeticException("The hamming weight is greater than the length of vector.");
    }

    public GF2Vector(int n, int[] nArray) {
        if (n >= 0) {
            ((Vector)object).length = n;
            int n2 = n + 31 >> 5;
            if (nArray.length == n2) {
                GF2Vector gF2Vector = object;
                int[] nArray2 = IntUtils.clone(nArray);
                Object object = nArray2;
                gF2Vector.v = nArray2;
                if ((n &= 0x1F) != 0) {
                    Object object2 = object;
                    int n3 = n2 - 1;
                    object2[n3] = object2[n3] & (1 << n) - 1;
                }
                return;
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("negative length");
    }

    public GF2Vector(GF2Vector gF2Vector) {
        this.length = gF2Vector.length;
        this.v = IntUtils.clone(gF2Vector.v);
    }

    public GF2Vector(int[] nArray, int n) {
        this.v = nArray;
        this.length = n;
    }

    public static GF2Vector OS2VP(int n, byte[] byArray) {
        if (n >= 0) {
            int n2 = n + 7 >> 3;
            if (byArray.length <= n2) {
                return new GF2Vector(n, LittleEndianConversions.toIntArray(byArray));
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("negative length");
    }

    @Override
    public byte[] getEncoded() {
        GF2Vector gF2Vector = this;
        int n = gF2Vector.length + 7 >> 3;
        return LittleEndianConversions.toByteArray(gF2Vector.v, n);
    }

    public int[] getVecArray() {
        return this.v;
    }

    public int getHammingWeight() {
        int n = 0;
        int n2 = 0;
        while (true) {
            int[] nArray = this.v;
            if (n2 >= this.v.length) break;
            int n3 = nArray[n2];
            for (int k = 0; k < 32; ++k) {
                if ((n3 & 1) != 0) {
                    ++n;
                }
                n3 >>>= 1;
            }
            ++n2;
        }
        return n;
    }

    @Override
    public boolean isZero() {
        for (int k = this.v.length - 1; k >= 0; --k) {
            if (this.v[k] == 0) continue;
            return false;
        }
        return true;
    }

    public int getBit(int n) {
        if (n < this.length) {
            int n2 = n;
            int n3 = n2 >> 5;
            n = n2 & 0x1F;
            return (this.v[n3] & 1 << n) >>> n;
        }
        throw new IndexOutOfBoundsException();
    }

    public void setBit(int n) {
        if (n < this.length) {
            int n2 = n >> 5;
            this.v[n2] = this.v[n2] | 1 << (n & 0x1F);
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Vector add(Vector object) {
        if (object instanceof GF2Vector) {
            object = (GF2Vector)object;
            if (this.length == ((Vector)object).length) {
                object = IntUtils.clone(((GF2Vector)object).v);
                for (int k = (v920695).length - 1; k >= 0; --k) {
                    object[k] = object[k] ^ this.v[k];
                }
                return new GF2Vector(this.length, (int[])object);
            }
            throw new ArithmeticException("length mismatch");
        }
        throw new ArithmeticException("vector is not defined over GF(2)");
    }

    @Override
    public Vector multiply(Permutation object) {
        int n = this.length;
        if (n == ((Object)(object = (Object)((Permutation)object).getVector())).length) {
            GF2Vector gF2Vector;
            GF2Vector gF2Vector2 = gF2Vector;
            gF2Vector = new GF2Vector(n);
            for (n = 0; n < ((Object)object).length; ++n) {
                Object object2 = object[n];
                if ((this.v[object2 >> 5] & 1 << (object2 & 0x1F)) == 0) continue;
                int n2 = n >> 5;
                object2 = n2;
                gF2Vector2.v[object2] = gF2Vector2.v[n2] | 1 << (n & 0x1F);
            }
            return gF2Vector2;
        }
        throw new ArithmeticException("length mismatch");
    }

    public GF2Vector extractVector(int[] nArray) {
        int n = nArray.length;
        if (nArray[n - 1] <= this.length) {
            GF2Vector gF2Vector;
            GF2Vector gF2Vector2 = gF2Vector;
            gF2Vector = new GF2Vector(n);
            for (int k = 0; k < n; ++k) {
                int n2 = nArray[k];
                if ((this.v[n2 >> 5] & 1 << (n2 & 0x1F)) == 0) continue;
                n2 = k >> 5;
                gF2Vector2.v[n2] = gF2Vector2.v[n2] | 1 << (k & 0x1F);
            }
            return gF2Vector2;
        }
        throw new ArithmeticException("invalid index set");
    }

    public GF2Vector extractLeftVector(int n) {
        int n2 = this.length;
        if (n <= n2) {
            GF2Vector gF2Vector;
            if (n == n2) {
                return new GF2Vector(this);
            }
            int n3 = n;
            GF2Vector gF2Vector2 = gF2Vector;
            gF2Vector = new GF2Vector(n);
            n = n3 >> 5;
            int n4 = n3 & 0x1F;
            System.arraycopy(this.v, 0, gF2Vector2.v, 0, n);
            if (n4 != 0) {
                gF2Vector2.v[n] = this.v[n] & (1 << n4) - 1;
            }
            return gF2Vector2;
        }
        throw new ArithmeticException("invalid length");
    }

    public GF2Vector extractRightVector(int n) {
        int n2 = ((Vector)object).length;
        if (n <= n2) {
            GF2Vector gF2Vector;
            if (n == n2) {
                return new GF2Vector((GF2Vector)object);
            }
            GF2Vector gF2Vector2 = gF2Vector;
            gF2Vector = new GF2Vector(n);
            int n3 = ((Vector)object).length;
            int n4 = n3 - n >> 5;
            int n5 = n3 - n & 0x1F;
            n = n + 31 >> 5;
            if (n5 != 0) {
                int n6;
                int n7;
                for (n7 = 0; n7 < (n6 = n - 1); ++n7) {
                    int[] nArray = ((GF2Vector)object).v;
                    gF2Vector2.v[n7] = ((GF2Vector)object).v[n4++] >>> n5 | nArray[n4] << 32 - n5;
                }
                GF2Vector gF2Vector3 = object;
                Object object = gF2Vector2.v;
                int[] nArray = gF2Vector3.v;
                n7 = n4 + 1;
                n4 = nArray[n4] >>> n5;
                object[n6] = n4;
                if (n7 < nArray.length) {
                    object[n6] = n4 | nArray[n7] << 32 - n5;
                }
            } else {
                System.arraycopy(((GF2Vector)object).v, n4, gF2Vector2.v, 0, n);
            }
            return gF2Vector2;
        }
        throw new ArithmeticException("invalid length");
    }

    public GF2mVector toExtensionFieldVector(GF2mField gF2mField) {
        int n = this.length;
        int n2 = gF2mField.getDegree();
        if (n % n2 == 0) {
            int[] nArray = new int[n / n2];
            n = 0;
            for (int k = (v921031) - 1; k >= 0; --k) {
                for (int i2 = gF2mField.getDegree() - 1; i2 >= 0; --i2) {
                    int n3 = n;
                    int n4 = n3 >>> 5;
                    int n5 = n3 & 0x1F;
                    if ((this.v[n4] >>> n5 & 1) == 1) {
                        nArray[k] = nArray[k] ^ 1 << i2;
                    }
                    ++n;
                }
            }
            return new GF2mVector(gF2mField, nArray);
        }
        throw new ArithmeticException("conversion is impossible");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GF2Vector)) {
            return false;
        }
        object = (GF2Vector)object;
        return this.length == ((Vector)object).length && IntUtils.equals(this.v, ((GF2Vector)object).v);
    }

    @Override
    public int hashCode() {
        GF2Vector gF2Vector = this;
        int n = gF2Vector.length * 31;
        return Arrays.hashCode(gF2Vector.v) + n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int k = 0; k < this.length; ++k) {
            if (k != 0 && (k & 0x1F) == 0) {
                stringBuffer2.append(' ');
            }
            int n = k;
            int n2 = n >> 5;
            int n3 = n & 0x1F;
            if ((this.v[n2] & 1 << n3) == 0) {
                stringBuffer2.append('0');
                continue;
            }
            stringBuffer2.append('1');
        }
        return stringBuffer2.toString();
    }
}

