/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public final class IntegerFunctions {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger FOUR = BigInteger.valueOf(4L);
    private static final int[] SMALL_PRIMES = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41};
    private static final long SMALL_PRIME_PRODUCT = 152125131763605L;
    private static SecureRandom sr = null;
    private static final int[] jacobiTable = new int[]{0, 1, 0, -1, 0, -1, 0, 1};

    private IntegerFunctions() {
    }

    public static int jacobi(BigInteger bigInteger, BigInteger bigInteger2) {
        long l = 1L;
        BigInteger bigInteger3 = ZERO;
        if (bigInteger2.equals(bigInteger3)) {
            return bigInteger.abs().equals(ONE) ? 1 : 0;
        }
        if (!bigInteger.testBit(0) && !bigInteger2.testBit(0)) {
            return 0;
        }
        if (bigInteger2.signum() == -1) {
            bigInteger2 = bigInteger2.negate();
            if (bigInteger.signum() == -1) {
                l = -1L;
            }
        }
        while (!bigInteger2.testBit(0)) {
            bigInteger3 = bigInteger3.add(ONE);
            bigInteger2 = bigInteger2.divide(TWO);
        }
        if (bigInteger3.testBit(0)) {
            l *= (long)jacobiTable[bigInteger.intValue() & 7];
        }
        if (bigInteger.signum() < 0) {
            if (bigInteger2.testBit(1)) {
                l = -l;
            }
            bigInteger = bigInteger.negate();
        }
        while (bigInteger.signum() != 0) {
            bigInteger3 = ZERO;
            while (!bigInteger.testBit(0)) {
                bigInteger3 = bigInteger3.add(ONE);
                bigInteger = bigInteger.divide(TWO);
            }
            if (bigInteger3.testBit(0)) {
                l *= (long)jacobiTable[bigInteger2.intValue() & 7];
            }
            if (bigInteger.compareTo(bigInteger2) < 0) {
                if (bigInteger2.testBit(1) && bigInteger.testBit(1)) {
                    l = -l;
                }
            } else {
                BigInteger bigInteger4 = bigInteger;
                bigInteger = bigInteger2;
                bigInteger2 = bigInteger4;
            }
            BigInteger bigInteger5 = bigInteger2 = bigInteger2.subtract(bigInteger);
            bigInteger2 = bigInteger;
            bigInteger = bigInteger5;
        }
        return bigInteger2.equals(ONE) ? (int)l : 0;
    }

    public static BigInteger ressol(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = ZERO;
        if (bigInteger.compareTo(bigInteger3) < 0) {
            bigInteger = bigInteger.add(bigInteger2);
        }
        if (bigInteger.equals(bigInteger3)) {
            return bigInteger3;
        }
        if (bigInteger2.equals(TWO)) {
            return bigInteger;
        }
        if (bigInteger2.testBit(0) && bigInteger2.testBit(1)) {
            if (IntegerFunctions.jacobi(bigInteger, bigInteger2) == 1) {
                return bigInteger.modPow(bigInteger2.add(ONE).shiftRight(2), bigInteger2);
            }
            throw new IllegalArgumentException("No quadratic residue: " + bigInteger + ", " + bigInteger2);
        }
        bigInteger3 = bigInteger2.subtract(ONE);
        long l = 0L;
        while (!bigInteger3.testBit(0)) {
            ++l;
            bigInteger3 = bigInteger3.shiftRight(1);
        }
        BigInteger bigInteger4 = bigInteger3;
        bigInteger3 = ONE;
        BigInteger bigInteger5 = bigInteger4.subtract(bigInteger3).shiftRight(1);
        BigInteger bigInteger6 = bigInteger.modPow(bigInteger5, bigInteger2);
        BigInteger bigInteger7 = bigInteger6.multiply(bigInteger6).remainder(bigInteger2).multiply(bigInteger).remainder(bigInteger2);
        BigInteger bigInteger8 = bigInteger3;
        bigInteger3 = bigInteger6.multiply(bigInteger).remainder(bigInteger2);
        if (bigInteger7.equals(bigInteger8)) {
            return bigInteger3;
        }
        bigInteger6 = TWO;
        while (IntegerFunctions.jacobi(bigInteger6, bigInteger2) == 1) {
            bigInteger6 = bigInteger6.add(ONE);
        }
        bigInteger5 = bigInteger6.modPow(bigInteger5.multiply(TWO).add(ONE), bigInteger2);
        while (bigInteger7.compareTo(ONE) == 1) {
            BigInteger bigInteger9;
            long l2 = 0L;
            bigInteger6 = bigInteger7;
            while (!bigInteger6.equals(bigInteger9 = ONE)) {
                BigInteger bigInteger10 = bigInteger6;
                bigInteger6 = bigInteger10.multiply(bigInteger10).mod(bigInteger2);
                ++l2;
            }
            if ((l -= l2) != 0L) {
                for (long k = 0L; k < l - 1L; ++k) {
                    bigInteger9 = bigInteger9.shiftLeft(1);
                }
                BigInteger bigInteger11 = bigInteger5.modPow(bigInteger9, bigInteger2);
                bigInteger3 = bigInteger3.multiply(bigInteger11).remainder(bigInteger2);
                bigInteger5 = bigInteger11.multiply(bigInteger11).remainder(bigInteger2);
                bigInteger7 = bigInteger7.multiply(bigInteger5).mod(bigInteger2);
                l = l2;
                continue;
            }
            throw new IllegalArgumentException("No quadratic residue: " + bigInteger + ", " + bigInteger2);
        }
        return bigInteger3;
    }

    public static int gcd(int n, int n2) {
        return BigInteger.valueOf(n).gcd(BigInteger.valueOf(n2)).intValue();
    }

    public static int[] extGCD(int n, int n2) {
        BigInteger[] bigIntegerArray = IntegerFunctions.extgcd(BigInteger.valueOf(n), BigInteger.valueOf(n2));
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray2[0] = bigIntegerArray[0].intValue();
        nArray2[1] = bigIntegerArray[1].intValue();
        nArray[2] = bigIntegerArray[2].intValue();
        return nArray;
    }

    public static BigInteger divideAndRound(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.signum() < 0) {
            return IntegerFunctions.divideAndRound(bigInteger.negate(), bigInteger2).negate();
        }
        if (bigInteger2.signum() < 0) {
            return IntegerFunctions.divideAndRound(bigInteger, bigInteger2.negate()).negate();
        }
        return bigInteger.shiftLeft(1).add(bigInteger2).divide(bigInteger2.shiftLeft(1));
    }

    public static BigInteger[] divideAndRound(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        BigInteger[] bigIntegerArray2 = new BigInteger[bigIntegerArray.length];
        for (int k = 0; k < bigIntegerArray.length; ++k) {
            bigIntegerArray2[k] = IntegerFunctions.divideAndRound(bigIntegerArray[k], bigInteger);
        }
        return bigIntegerArray2;
    }

    public static int ceilLog(BigInteger bigInteger) {
        int n = 0;
        BigInteger bigInteger2 = ONE;
        while (bigInteger2.compareTo(bigInteger) < 0) {
            ++n;
            bigInteger2 = bigInteger2.shiftLeft(1);
        }
        return n;
    }

    public static int ceilLog(int n) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }

    public static int ceilLog256(int n) {
        if (n == 0) {
            return 1;
        }
        if (n < 0) {
            n = -n;
        }
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n >>>= 8;
        }
        return n2;
    }

    public static int ceilLog256(long l) {
        long l2 = l - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (l3 == false) {
            return 1;
        }
        if (l3 < 0) {
            l = -l;
        }
        l3 = 0;
        while (l > 0L) {
            ++l3;
            l >>>= 8;
        }
        return (int)l3;
    }

    public static int floorLog(BigInteger bigInteger) {
        int n = -1;
        BigInteger bigInteger2 = ONE;
        while (bigInteger2.compareTo(bigInteger) <= 0) {
            ++n;
            bigInteger2 = bigInteger2.shiftLeft(1);
        }
        return n;
    }

    public static int floorLog(int n) {
        int n2 = 0;
        if (n <= 0) {
            return -1;
        }
        n >>>= 1;
        while (n > 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    public static int maxPower(int n) {
        int n2 = 0;
        if (n != 0) {
            int n3 = 1;
            while ((n & n3) == 0) {
                ++n2;
                n3 <<= 1;
            }
        }
        return n2;
    }

    public static int bitCount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += n & 1;
            n >>>= 1;
        }
        return n2;
    }

    public static int order(int n, int n2) {
        int n3 = n % n2;
        int n4 = 1;
        if (n3 != 0) {
            while (n3 != 1) {
                if ((n3 = n3 * n % n2) < 0) {
                    n3 += n2;
                }
                ++n4;
            }
            return n4;
        }
        throw new IllegalArgumentException(n + " is not an element of Z/(" + n2 + "Z)^*; it is not meaningful to compute its order.");
    }

    public static BigInteger reduceInto(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.subtract(bigInteger2).mod(bigInteger3.subtract(bigInteger2)).add(bigInteger2);
    }

    public static int pow(int n, int n2) {
        int n3 = 1;
        while (n2 > 0) {
            if ((n2 & 1) == 1) {
                n3 *= n;
            }
            int n4 = n;
            n = n4 * n4;
            n2 >>>= 1;
        }
        return n3;
    }

    public static long pow(long l, int n) {
        long l2 = 1L;
        while (n > 0) {
            if ((n & 1) == 1) {
                l2 *= l;
            }
            long l3 = l;
            l = l3 * l3;
            n >>>= 1;
        }
        return l2;
    }

    public static int modPow(int n, int n2, int n3) {
        if (n3 > 0) {
            int n4 = n3;
            if (n4 * n4 <= Integer.MAX_VALUE && n2 >= 0) {
                int n5 = n;
                n = 1;
                int n6 = (n5 % n3 + n3) % n3;
                while (n2 > 0) {
                    if ((n2 & 1) == 1) {
                        n = n * n6 % n3;
                    }
                    int n7 = n6;
                    n6 = n7 * n7 % n3;
                    n2 >>>= 1;
                }
                return n;
            }
        }
        return 0;
    }

    public static BigInteger[] extgcd(BigInteger bigInteger, BigInteger object) {
        Object object2 = ONE;
        BigInteger bigInteger2 = ZERO;
        if (object.signum() != 0) {
            BigInteger bigInteger3 = bigInteger;
            Object object3 = object;
            while (object3.signum() != 0) {
                BigInteger[] bigIntegerArray = object2;
                BigInteger[] bigIntegerArray2 = bigInteger3.divideAndRemainder((BigInteger)object3);
                object2 = bigIntegerArray2;
                object2 = object2[1];
                bigInteger3 = bigIntegerArray.subtract(bigIntegerArray2[0].multiply(bigInteger2));
                Object object4 = object2;
                BigInteger bigInteger4 = bigInteger2;
                bigInteger2 = bigInteger3;
                object2 = bigInteger4;
                bigInteger3 = object3;
                object3 = object4;
            }
            bigInteger2 = bigInteger3.subtract(bigInteger.multiply((BigInteger)object2)).divide((BigInteger)object);
            bigInteger = bigInteger3;
        }
        return new BigInteger[]{bigInteger, object2, bigInteger2};
    }

    public static BigInteger leastCommonMultiple(BigInteger[] bigIntegerArray) {
        int n = bigIntegerArray.length;
        BigInteger bigInteger = bigIntegerArray[0];
        for (int k = 1; k < n; ++k) {
            BigInteger bigInteger2 = bigInteger;
            bigInteger = bigInteger.gcd(bigIntegerArray[k]);
            bigInteger = bigInteger2.multiply(bigIntegerArray[k]).divide(bigInteger);
        }
        return bigInteger;
    }

    public static long mod(long l, long l2) {
        if ((l %= l2) < 0L) {
            l += l2;
        }
        return l;
    }

    public static int modInverse(int n, int n2) {
        return BigInteger.valueOf(n).modInverse(BigInteger.valueOf(n2)).intValue();
    }

    public static long modInverse(long l, long l2) {
        return BigInteger.valueOf(l).modInverse(BigInteger.valueOf(l2)).longValue();
    }

    public static int isPower(int n, int n2) {
        if (n <= 0) {
            return -1;
        }
        int n3 = 0;
        while (n > 1) {
            if (n % n2 != 0) {
                return -1;
            }
            n /= n2;
            ++n3;
        }
        return n3;
    }

    public static int leastDiv(int n) {
        if (n < 0) {
            n = -n;
        }
        if (n == 0) {
            return 1;
        }
        if ((n & 1) == 0) {
            return 2;
        }
        for (int k = 3; k <= n / k; k += 2) {
            if (n % k != 0) continue;
            return k;
        }
        return n;
    }

    public static boolean isPrime(int n) {
        if (n < 2) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        if ((n & 1) == 0) {
            return false;
        }
        if (n < 42) {
            int n2 = 0;
            while (true) {
                int[] nArray = SMALL_PRIMES;
                if (n2 >= SMALL_PRIMES.length) break;
                if (n == nArray[n2]) {
                    return true;
                }
                ++n2;
            }
        }
        if (n % 3 != 0 && n % 5 != 0 && n % 7 != 0 && n % 11 != 0 && n % 13 != 0 && n % 17 != 0 && n % 19 != 0 && n % 23 != 0 && n % 29 != 0 && n % 31 != 0 && n % 37 != 0 && n % 41 != 0) {
            return BigInteger.valueOf(n).isProbablePrime(20);
        }
        return false;
    }

    public static boolean passesSmallPrimeTest(BigInteger bigInteger) {
        int n = 239;
        int[] nArray = new int[239];
        int[] nArray2 = nArray;
        nArray[0] = 2;
        nArray[1] = 3;
        nArray[2] = 5;
        nArray[3] = 7;
        nArray[4] = 11;
        nArray[5] = 13;
        nArray[6] = 17;
        nArray[7] = 19;
        nArray[8] = 23;
        nArray[9] = 29;
        nArray[10] = 31;
        nArray[11] = 37;
        nArray[12] = 41;
        nArray[13] = 43;
        nArray[14] = 47;
        nArray[15] = 53;
        nArray[16] = 59;
        nArray[17] = 61;
        nArray[18] = 67;
        nArray[19] = 71;
        nArray[20] = 73;
        nArray[21] = 79;
        nArray[22] = 83;
        nArray[23] = 89;
        nArray[24] = 97;
        nArray[25] = 101;
        nArray[26] = 103;
        nArray[27] = 107;
        nArray[28] = 109;
        nArray[29] = 113;
        nArray[30] = 127;
        nArray[31] = 131;
        nArray[32] = 137;
        nArray[33] = 139;
        nArray[34] = 149;
        nArray[35] = 151;
        nArray[36] = 157;
        nArray[37] = 163;
        nArray[38] = 167;
        nArray[39] = 173;
        nArray[40] = 179;
        nArray[41] = 181;
        nArray[42] = 191;
        nArray[43] = 193;
        nArray[44] = 197;
        nArray[45] = 199;
        nArray[46] = 211;
        nArray[47] = 223;
        nArray[48] = 227;
        nArray[49] = 229;
        nArray[50] = 233;
        nArray[51] = 239;
        nArray[52] = 241;
        nArray[53] = 251;
        nArray[54] = 257;
        nArray[55] = 263;
        nArray[56] = 269;
        nArray[57] = 271;
        nArray[58] = 277;
        nArray[59] = 281;
        nArray[60] = 283;
        nArray[61] = 293;
        nArray[62] = 307;
        nArray[63] = 311;
        nArray[64] = 313;
        nArray[65] = 317;
        nArray[66] = 331;
        nArray[67] = 337;
        nArray[68] = 347;
        nArray[69] = 349;
        nArray[70] = 353;
        nArray[71] = 359;
        nArray[72] = 367;
        nArray[73] = 373;
        nArray[74] = 379;
        nArray[75] = 383;
        nArray[76] = 389;
        nArray[77] = 397;
        nArray[78] = 401;
        nArray[79] = 409;
        nArray[80] = 419;
        nArray[81] = 421;
        nArray[82] = 431;
        nArray[83] = 433;
        nArray[84] = 439;
        nArray[85] = 443;
        nArray[86] = 449;
        nArray[87] = 457;
        nArray[88] = 461;
        nArray[89] = 463;
        nArray[90] = 467;
        nArray[91] = 479;
        nArray[92] = 487;
        nArray[93] = 491;
        nArray[94] = 499;
        nArray[95] = 503;
        nArray[96] = 509;
        nArray[97] = 521;
        nArray[98] = 523;
        nArray[99] = 541;
        nArray[100] = 547;
        nArray[101] = 557;
        nArray[102] = 563;
        nArray[103] = 569;
        nArray[104] = 571;
        nArray[105] = 577;
        nArray[106] = 587;
        nArray[107] = 593;
        nArray[108] = 599;
        nArray[109] = 601;
        nArray[110] = 607;
        nArray[111] = 613;
        nArray[112] = 617;
        nArray[113] = 619;
        nArray[114] = 631;
        nArray[115] = 641;
        nArray[116] = 643;
        nArray[117] = 647;
        nArray[118] = 653;
        nArray[119] = 659;
        nArray[120] = 661;
        nArray[121] = 673;
        nArray[122] = 677;
        nArray[123] = 683;
        nArray[124] = 691;
        nArray[125] = 701;
        nArray[126] = 709;
        nArray[127] = 719;
        nArray[128] = 727;
        nArray[129] = 733;
        nArray[130] = 739;
        nArray[131] = 743;
        nArray[132] = 751;
        nArray[133] = 757;
        nArray[134] = 761;
        nArray[135] = 769;
        nArray[136] = 773;
        nArray[137] = 787;
        nArray[138] = 797;
        nArray[139] = 809;
        nArray[140] = 811;
        nArray[141] = 821;
        nArray[142] = 823;
        nArray[143] = 827;
        nArray[144] = 829;
        nArray[145] = 839;
        nArray[146] = 853;
        nArray[147] = 857;
        nArray[148] = 859;
        nArray[149] = 863;
        nArray[150] = 877;
        nArray[151] = 881;
        nArray[152] = 883;
        nArray[153] = 887;
        nArray[154] = 907;
        nArray[155] = 911;
        nArray[156] = 919;
        nArray[157] = 929;
        nArray[158] = 937;
        nArray[159] = 941;
        nArray[160] = 947;
        nArray[161] = 953;
        nArray[162] = 967;
        nArray[163] = 971;
        nArray[164] = 977;
        nArray[165] = 983;
        nArray[166] = 991;
        nArray[167] = 997;
        nArray[168] = 1009;
        nArray[169] = 1013;
        nArray[170] = 1019;
        nArray[171] = 1021;
        nArray[172] = 1031;
        nArray[173] = 1033;
        nArray[174] = 1039;
        nArray[175] = 1049;
        nArray[176] = 1051;
        nArray[177] = 1061;
        nArray[178] = 1063;
        nArray[179] = 1069;
        nArray[180] = 1087;
        nArray[181] = 1091;
        nArray[182] = 1093;
        nArray[183] = 1097;
        nArray[184] = 1103;
        nArray[185] = 1109;
        nArray[186] = 1117;
        nArray[187] = 1123;
        nArray[188] = 1129;
        nArray[189] = 1151;
        nArray[190] = 1153;
        nArray[191] = 1163;
        nArray[192] = 1171;
        nArray[193] = 1181;
        nArray[194] = 1187;
        nArray[195] = 1193;
        nArray[196] = 1201;
        nArray[197] = 1213;
        nArray[198] = 1217;
        nArray[199] = 1223;
        nArray[200] = 1229;
        nArray[201] = 1231;
        nArray[202] = 1237;
        nArray[203] = 1249;
        nArray[204] = 1259;
        nArray[205] = 1277;
        nArray[206] = 1279;
        nArray[207] = 1283;
        nArray[208] = 1289;
        nArray[209] = 1291;
        nArray[210] = 1297;
        nArray[211] = 1301;
        nArray[212] = 1303;
        nArray[213] = 1307;
        nArray[214] = 1319;
        nArray[215] = 1321;
        nArray[216] = 1327;
        nArray[217] = 1361;
        nArray[218] = 1367;
        nArray[219] = 1373;
        nArray[220] = 1381;
        nArray[221] = 1399;
        nArray[222] = 1409;
        nArray[223] = 1423;
        nArray[224] = 1427;
        nArray[225] = 1429;
        nArray[226] = 1433;
        nArray[227] = 1439;
        nArray[228] = 1447;
        nArray[229] = 1451;
        nArray[230] = 1453;
        nArray[231] = 1459;
        nArray[232] = 1471;
        nArray[233] = 1481;
        nArray[234] = 1483;
        nArray[235] = 1487;
        nArray[236] = 1489;
        nArray[237] = 1493;
        nArray[238] = 1499;
        for (int k = 0; k < n; ++k) {
            if (!bigInteger.mod(BigInteger.valueOf(nArray2[k])).equals(ZERO)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static int nextSmallerPrime(int var0) {
        if (var0 <= 2) {
            return 1;
        }
        if (var0 == 3) {
            return 2;
        }
        if ((var0 & 1) != 0) ** GOTO lbl-1000
        --var0;
        while (var0 > 3 && !IntegerFunctions.isPrime(var0)) lbl-1000:
        // 2 sources

        {
            var0 -= 2;
        }
        return var0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BigInteger nextProbablePrime(BigInteger bigInteger, int n) {
        if (bigInteger.signum() < 0) return TWO;
        if (bigInteger.signum() == 0) return TWO;
        BigInteger bigInteger2 = ONE;
        if (bigInteger.equals(bigInteger2)) {
            return TWO;
        }
        if (!(bigInteger = bigInteger.add(bigInteger2)).testBit(0)) {
            bigInteger = bigInteger.add(bigInteger2);
        }
        while (true) {
            long l;
            if (bigInteger.bitLength() <= 6 || (l = bigInteger.remainder(BigInteger.valueOf(152125131763605L)).longValue()) % 3L != 0L && l % 5L != 0L && l % 7L != 0L && l % 11L != 0L && l % 13L != 0L && l % 17L != 0L && l % 19L != 0L && l % 23L != 0L && l % 29L != 0L && l % 31L != 0L && l % 37L != 0L && l % 41L != 0L) {
                if (bigInteger.bitLength() < 4) {
                    return bigInteger;
                }
                if (bigInteger.isProbablePrime(n)) {
                    return bigInteger;
                }
            }
            bigInteger = bigInteger.add(TWO);
        }
    }

    public static BigInteger nextProbablePrime(BigInteger bigInteger) {
        return IntegerFunctions.nextProbablePrime(bigInteger, 20);
    }

    public static BigInteger nextPrime(long l) {
        boolean bl = false;
        long l2 = 0L;
        if (l <= 1L) {
            return BigInteger.valueOf(2L);
        }
        if (l == 2L) {
            return BigInteger.valueOf(3L);
        }
        for (long k = l + 1L + (l & 1L); k <= l << 1 && !bl; bl ^= true, k += 2L) {
            for (long i2 = 3L; i2 <= k >> 1 && !bl; i2 += 2L) {
                if (k % i2 != 0L) continue;
                bl = true;
            }
            if (bl) continue;
            l2 = k;
        }
        return BigInteger.valueOf(l2);
    }

    public static BigInteger binomial(int n, int n2) {
        BigInteger bigInteger = ONE;
        if (n == 0) {
            if (n2 == 0) {
                return bigInteger;
            }
            return ZERO;
        }
        if (n2 > n >>> 1) {
            n2 = n - n2;
        }
        for (int k = 1; k <= n2; ++k) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(n - (k - 1))).divide(BigInteger.valueOf(k));
        }
        return bigInteger;
    }

    public static BigInteger randomize(BigInteger bigInteger) {
        if (sr == null) {
            sr = CryptoServicesRegistrar.getSecureRandom();
        }
        return IntegerFunctions.randomize(bigInteger, sr);
    }

    public static BigInteger randomize(BigInteger bigInteger, SecureRandom secureRandom) {
        int n = bigInteger.bitLength();
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        if (secureRandom == null && (secureRandom = sr) == null) {
            secureRandom = CryptoServicesRegistrar.getSecureRandom();
        }
        for (int k = 0; k < 20; ++k) {
            bigInteger2 = BigIntegers.createRandomBigInteger(n, secureRandom);
            if (bigInteger2.compareTo(bigInteger) >= 0) continue;
            return bigInteger2;
        }
        return bigInteger2.mod(bigInteger);
    }

    public static BigInteger squareRoot(BigInteger bigInteger) {
        BigInteger bigInteger2 = ZERO;
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            int n;
            BigInteger bigInteger3;
            int n2 = bigInteger.bitLength();
            if ((n2 & 1) != 0) {
                BigInteger bigInteger4 = bigInteger2.add(ONE);
                bigInteger3 = bigInteger2;
                bigInteger2 = bigInteger4;
                n = --n2;
            } else {
                bigInteger3 = bigInteger2;
                n = n2;
            }
            while (n > 0) {
                BigInteger bigInteger5 = bigInteger3;
                bigInteger3 = FOUR;
                BigInteger bigInteger6 = bigInteger5.multiply(bigInteger3);
                int n3 = bigInteger.testBit(n += -1) ? 2 : 0;
                bigInteger6 = bigInteger6.add(BigInteger.valueOf(bigInteger.testBit(n += -1) + n3));
                BigInteger bigInteger7 = bigInteger2;
                bigInteger2 = ONE;
                bigInteger3 = bigInteger7.multiply(bigInteger3).add(bigInteger2);
                BigInteger bigInteger8 = bigInteger7.multiply(TWO);
                if (bigInteger6.compareTo(bigInteger3) != -1) {
                    bigInteger2 = bigInteger8.add(bigInteger2);
                    bigInteger3 = bigInteger6.subtract(bigInteger3);
                    continue;
                }
                bigInteger3 = bigInteger6;
                bigInteger2 = bigInteger8;
            }
            return bigInteger2;
        }
        throw new ArithmeticException("cannot extract root of negative number" + bigInteger + ".");
    }

    public static float intRoot(int n, int n2) {
        float f2 = n / n2;
        float f3 = 0.0f;
        while ((double)Math.abs(f3 - f2) > 1.0E-4) {
            float f4 = IntegerFunctions.floatPow(f2, n2);
            while (Float.isInfinite(f4)) {
                f2 = (f2 + f3) / 2.0f;
                f4 = IntegerFunctions.floatPow(f2, n2);
            }
            int n3 = n2;
            f3 = n3;
            f3 = f2 - (f4 - (float)n) / (IntegerFunctions.floatPow(f2, n3 - 1) * f3);
            float f5 = f2;
            f2 = f3;
            f3 = f5;
        }
        return f2;
    }

    public static float floatPow(float f2, int n) {
        float f3 = 1.0f;
        while (n > 0) {
            f3 *= f2;
            --n;
        }
        return f3;
    }

    public static double log(double d2) {
        if (d2 > 0.0 && d2 < 1.0) {
            return -IntegerFunctions.log(1.0 / d2);
        }
        int n = 0;
        double d3 = 1.0;
        double d4 = d2;
        while (d4 > 2.0) {
            double d5 = d3;
            d3 = d4 / 2.0;
            ++n;
            d4 = d5 * 2.0;
            double d6 = d3;
            d3 = d4;
            d4 = d6;
        }
        d2 = IntegerFunctions.logBKM(d2 / d3);
        return (double)n + d2;
    }

    public static double log(long l) {
        int n = IntegerFunctions.floorLog(BigInteger.valueOf(l));
        long l2 = l;
        l = 1 << n;
        double d2 = IntegerFunctions.logBKM((double)l2 / (double)l);
        return (double)n + d2;
    }

    private static double logBKM(double d2) {
        double[] dArray = new double[100];
        double[] dArray2 = dArray;
        dArray[0] = 1.0;
        dArray[1] = 0.5849625007211562;
        dArray[2] = 0.32192809488736235;
        dArray[3] = 0.16992500144231237;
        dArray[4] = 0.0874628412503394;
        dArray[5] = 0.044394119358453436;
        dArray[6] = 0.02236781302845451;
        dArray[7] = 0.01122725542325412;
        dArray[8] = 0.005624549193878107;
        dArray[9] = 0.0028150156070540383;
        dArray[10] = 0.0014081943928083889;
        dArray[11] = 7.042690112466433E-4;
        dArray[12] = 3.5217748030102726E-4;
        dArray[13] = 1.7609948644250602E-4;
        dArray[14] = 8.80524301221769E-5;
        dArray[15] = 4.4026886827316716E-5;
        dArray[16] = 2.2013611360340496E-5;
        dArray[17] = 1.1006847667481442E-5;
        dArray[18] = 5.503434330648604E-6;
        dArray[19] = 2.751719789561283E-6;
        dArray[20] = 1.375860550841138E-6;
        dArray[21] = 6.879304394358497E-7;
        dArray[22] = 3.4396526072176454E-7;
        dArray[23] = 1.7198264061184464E-7;
        dArray[24] = 8.599132286866321E-8;
        dArray[25] = 4.299566207501687E-8;
        dArray[26] = 2.1497831197679756E-8;
        dArray[27] = 1.0748915638882709E-8;
        dArray[28] = 5.374457829452062E-9;
        dArray[29] = 2.687228917228708E-9;
        dArray[30] = 1.3436144592400231E-9;
        dArray[31] = 6.718072297764289E-10;
        dArray[32] = 3.3590361492731876E-10;
        dArray[33] = 1.6795180747343547E-10;
        dArray[34] = 8.397590373916176E-11;
        dArray[35] = 4.1987951870191886E-11;
        dArray[36] = 2.0993975935248694E-11;
        dArray[37] = 1.0496987967662534E-11;
        dArray[38] = 5.2484939838408146E-12;
        dArray[39] = 2.624246991922794E-12;
        dArray[40] = 1.3121234959619935E-12;
        dArray[41] = 6.56061747981146E-13;
        dArray[42] = 3.2803087399061026E-13;
        dArray[43] = 1.6401543699531447E-13;
        dArray[44] = 8.200771849765956E-14;
        dArray[45] = 4.1003859248830365E-14;
        dArray[46] = 2.0501929624415328E-14;
        dArray[47] = 1.02509648122077E-14;
        dArray[48] = 5.1254824061038595E-15;
        dArray[49] = 2.5627412030519317E-15;
        dArray[50] = 1.2813706015259665E-15;
        dArray[51] = 6.406853007629834E-16;
        dArray[52] = 3.203426503814917E-16;
        dArray[53] = 1.6017132519074588E-16;
        dArray[54] = 8.008566259537294E-17;
        dArray[55] = 4.004283129768647E-17;
        dArray[56] = 2.0021415648843235E-17;
        dArray[57] = 1.0010707824421618E-17;
        dArray[58] = 5.005353912210809E-18;
        dArray[59] = 2.5026769561054044E-18;
        dArray[60] = 1.2513384780527022E-18;
        dArray[61] = 6.256692390263511E-19;
        dArray[62] = 3.1283461951317555E-19;
        dArray[63] = 1.5641730975658778E-19;
        dArray[64] = 7.820865487829389E-20;
        dArray[65] = 3.9104327439146944E-20;
        dArray[66] = 1.9552163719573472E-20;
        dArray[67] = 9.776081859786736E-21;
        dArray[68] = 4.888040929893368E-21;
        dArray[69] = 2.444020464946684E-21;
        dArray[70] = 1.222010232473342E-21;
        dArray[71] = 6.11005116236671E-22;
        dArray[72] = 3.055025581183355E-22;
        dArray[73] = 1.5275127905916775E-22;
        dArray[74] = 7.637563952958387E-23;
        dArray[75] = 3.818781976479194E-23;
        dArray[76] = 1.909390988239597E-23;
        dArray[77] = 9.546954941197984E-24;
        dArray[78] = 4.773477470598992E-24;
        dArray[79] = 2.386738735299496E-24;
        dArray[80] = 1.193369367649748E-24;
        dArray[81] = 5.96684683824874E-25;
        dArray[82] = 2.98342341912437E-25;
        dArray[83] = 1.491711709562185E-25;
        dArray[84] = 7.458558547810925E-26;
        dArray[85] = 3.7292792739054626E-26;
        dArray[86] = 1.8646396369527313E-26;
        dArray[87] = 9.323198184763657E-27;
        dArray[88] = 4.661599092381828E-27;
        dArray[89] = 2.330799546190914E-27;
        dArray[90] = 1.165399773095457E-27;
        dArray[91] = 5.826998865477285E-28;
        dArray[92] = 2.9134994327386427E-28;
        dArray[93] = 1.4567497163693213E-28;
        dArray[94] = 7.283748581846607E-29;
        dArray[95] = 3.6418742909233034E-29;
        dArray[96] = 1.8209371454616517E-29;
        dArray[97] = 9.104685727308258E-30;
        dArray[98] = 4.552342863654129E-30;
        dArray[99] = 2.2761714318270646E-30;
        int n = 53;
        double d3 = 1.0;
        double d4 = 0.0;
        double d5 = 1.0;
        for (int k = 0; k < n; ++k) {
            double d6;
            double d7 = d3 * d5 + d3;
            if (d6 <= d2) {
                d4 = d3 = d4 + dArray2[k];
                d3 = d7;
            }
            d5 *= 0.5;
        }
        return d4;
    }

    public static boolean isIncreasing(int[] nArray) {
        for (int k = 1; k < nArray.length; ++k) {
            int n = k - 1;
            if (nArray[n] < nArray[k]) continue;
            System.out.println("a[" + n + "] = " + nArray[n] + " >= " + nArray[k] + " = a[" + k + "]");
            return false;
        }
        return true;
    }

    public static byte[] integerToOctets(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        byte[] byArray = bigInteger2.abs().toByteArray();
        if ((bigInteger2.bitLength() & 7) != 0) {
            return byArray;
        }
        int n = bigInteger.bitLength() >> 3;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 1, byArray2, 0, n);
        return byArray2;
    }

    public static BigInteger octetsToInteger(byte[] byArray, int n, int n2) {
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[n2 + 1];
        byArray = byArray3;
        byArray3[0] = 0;
        System.arraycopy(byArray2, n, byArray, 1, n2);
        return new BigInteger(byArray);
    }

    public static BigInteger octetsToInteger(byte[] byArray) {
        return IntegerFunctions.octetsToInteger(byArray, 0, byArray.length);
    }
}

