/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.RandUtils;
import java.security.SecureRandom;

public class PolynomialGF2mSmallM {
    public static final char RANDOM_IRREDUCIBLE_POLYNOMIAL = 'I';
    private GF2mField field;
    private int degree;
    private int[] coefficients;

    public PolynomialGF2mSmallM(GF2mField gF2mField) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        polynomialGF2mSmallM.field = gF2mField;
        polynomialGF2mSmallM.degree = -1;
        polynomialGF2mSmallM.coefficients = new int[1];
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, int n, char c2, SecureRandom secureRandom) {
        this.field = gF2mField;
        if (c2 == 'I') {
            PolynomialGF2mSmallM polynomialGF2mSmallM = this;
            polynomialGF2mSmallM.coefficients = polynomialGF2mSmallM.createRandomIrreduciblePolynomial(n, secureRandom);
            polynomialGF2mSmallM.computeDegree();
            return;
        }
        throw new IllegalArgumentException(" Error: type " + c2 + " is not defined for GF2smallmPolynomial");
    }

    private int[] createRandomIrreduciblePolynomial(int n, SecureRandom secureRandom) {
        int n2;
        int[] nArray = new int[n + 1];
        int[] nArray2 = nArray;
        nArray2[n] = 1;
        nArray[0] = this.field.getRandomNonZeroElement(secureRandom);
        for (n2 = 1; n2 < n; ++n2) {
            nArray2[n2] = this.field.getRandomElement(secureRandom);
        }
        while (!this.isIrreducible(nArray2)) {
            n2 = RandUtils.nextInt(secureRandom, n);
            if (n2 == 0) {
                nArray2[0] = this.field.getRandomNonZeroElement(secureRandom);
                continue;
            }
            nArray2[n2] = this.field.getRandomElement(secureRandom);
        }
        return nArray2;
    }

    public PolynomialGF2mSmallM(GF2mField object, int n) {
        this.field = object;
        this.degree = n;
        int[] nArray = new int[n + 1];
        object = nArray;
        this.coefficients = (int[])object;
        nArray[n] = 1;
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, int[] nArray) {
        this.field = gF2mField;
        this.coefficients = PolynomialGF2mSmallM.normalForm(nArray);
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, byte[] byArray) {
        int n;
        this.field = gF2mField;
        int n2 = 1;
        for (n = 8; gF2mField.getDegree() > n; n += 8) {
            ++n2;
        }
        if (byArray.length % n2 == 0) {
            int[] nArray;
            block5: {
                this.coefficients = new int[byArray.length / n2];
                int n3 = 0;
                n2 = 0;
                while (true) {
                    nArray = this.coefficients;
                    if (n2 >= this.coefficients.length) break block5;
                    for (int k = 0; k < n; k += 8) {
                        this.coefficients[n2] = this.coefficients[n2] ^ (byArray[n3++] & 0xFF) << k;
                    }
                    if (!this.field.isElementOfThisField(this.coefficients[n2])) break;
                    ++n2;
                }
                throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
            }
            if (nArray.length != 1 && nArray[nArray.length - 1] == 0) {
                throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
            }
            this.computeDegree();
            return;
        }
        throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
    }

    public PolynomialGF2mSmallM(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.field = polynomialGF2mSmallM.field;
        this.degree = polynomialGF2mSmallM.degree;
        this.coefficients = IntUtils.clone(polynomialGF2mSmallM.coefficients);
    }

    public PolynomialGF2mSmallM(GF2mVector gF2mVector) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = gF2mField;
        GF2mVector gF2mVector2 = gF2mVector;
        GF2mField gF2mField = gF2mVector2.getField();
        polynomialGF2mSmallM(gF2mField, gF2mVector2.getIntArrayForm());
    }

    private static int headCoefficient(int[] nArray) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n == -1) {
            return 0;
        }
        return nArray[n];
    }

    private int[] add(int[] nArray, int[] nArray2) {
        int n;
        if (nArray.length < nArray2.length) {
            nArray2 = new int[nArray2.length];
            n = nArray2.length;
            System.arraycopy(nArray2, 0, nArray2, 0, n);
        } else {
            nArray = new int[nArray.length];
            n = nArray.length;
            System.arraycopy(nArray, 0, nArray, 0, n);
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            int n2 = nArray2[n];
            nArray2[n] = this.field.add(n2, nArray[n]);
        }
        return nArray2;
    }

    private int[] multWithElement(int[] nArray, int n) {
        int n2 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n2 != -1 && n != 0) {
            if (n == 1) {
                return IntUtils.clone(nArray);
            }
            int[] nArray2 = new int[n2 + 1];
            while (n2 >= 0) {
                nArray2[n2] = this.field.mult(nArray[n2], n);
                --n2;
            }
            return nArray2;
        }
        return new int[1];
    }

    private static int[] multWithMonomial(int[] nArray, int n) {
        int n2 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n2 == -1) {
            return new int[1];
        }
        int[] nArray2 = new int[n2 + n + 1];
        int n3 = n2 + 1;
        System.arraycopy(nArray, 0, nArray2, n, n3);
        return nArray2;
    }

    private int[][] div(int[] object, int[] nArray) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        int n2 = PolynomialGF2mSmallM.computeDegree(object) + 1;
        if (n != -1) {
            int[] nArray2 = object;
            int[][] nArrayArray = new int[2][];
            object = nArrayArray;
            object[0] = (int)new int[1];
            object[1] = (int)new int[n2];
            n2 = PolynomialGF2mSmallM.headCoefficient(nArray);
            n2 = this.field.inverse(n2);
            nArrayArray[0][0] = 0;
            int[] nArray3 = nArrayArray[1];
            int n3 = nArray3.length;
            System.arraycopy(nArray2, 0, nArray3, 0, n3);
            while (n <= PolynomialGF2mSmallM.computeDegree((int[])object[1])) {
                int n4 = this.field.mult(PolynomialGF2mSmallM.headCoefficient((int[])object[1]), n2);
                nArray3 = new int[]{n4};
                int[] nArray4 = this.multWithElement(nArray, n4);
                n4 = PolynomialGF2mSmallM.computeDegree((int[])object[1]) - n;
                int[] nArray5 = PolynomialGF2mSmallM.multWithMonomial(nArray4, n4);
                nArray3 = PolynomialGF2mSmallM.multWithMonomial(nArray3, n4);
                object[0] = (int)this.add(nArray3, (int[])object[0]);
                object[1] = (int)this.add(nArray5, (int[])object[1]);
            }
            return object;
        }
        throw new ArithmeticException("Division by zero.");
    }

    private int[] gcd(int[] nArray, int[] nArray2) {
        if (PolynomialGF2mSmallM.computeDegree(nArray) == -1) {
            return nArray2;
        }
        while (PolynomialGF2mSmallM.computeDegree(nArray2) != -1) {
            int[] nArray3 = this.mod(nArray, nArray2);
            int n = nArray2.length;
            nArray2 = new int[n];
            System.arraycopy(nArray2, 0, nArray2, 0, n);
            n = nArray3.length;
            int[] nArray4 = new int[n];
            System.arraycopy(nArray3, 0, nArray4, 0, n);
            nArray = nArray2;
            nArray2 = nArray4;
        }
        return this.multWithElement(nArray, this.field.inverse(PolynomialGF2mSmallM.headCoefficient(nArray)));
    }

    private int[] multiply(int[] nArray, int[] nArray2) {
        int[] nArray3;
        Object object;
        if (PolynomialGF2mSmallM.computeDegree(nArray) < PolynomialGF2mSmallM.computeDegree(nArray2)) {
            int[] nArray4 = nArray2;
            nArray2 = nArray;
            nArray = nArray4;
        }
        nArray = PolynomialGF2mSmallM.normalForm(nArray);
        if ((nArray2 = PolynomialGF2mSmallM.normalForm(nArray2)).length == 1) {
            return ((PolynomialGF2mSmallM)object).multWithElement(nArray, nArray2[0]);
        }
        int n = nArray.length;
        int n2 = nArray2.length;
        int n3 = n;
        int[] cfr_ignored_0 = new int[n3 + n2 - 1];
        if (n2 != n3) {
            PolynomialGF2mSmallM polynomialGF2mSmallM = object;
            int n4 = n2;
            object = new int[n4];
            int n5 = n - n4;
            int[] nArray5 = new int[n5];
            System.arraycopy(nArray, 0, object, 0, n2);
            System.arraycopy(nArray, n2, nArray5, 0, n5);
            object = polynomialGF2mSmallM.multiply((int[])object, nArray2);
            nArray3 = polynomialGF2mSmallM.add((int[])object, PolynomialGF2mSmallM.multWithMonomial(polynomialGF2mSmallM.multiply(nArray5, nArray2), n2));
        } else {
            PolynomialGF2mSmallM polynomialGF2mSmallM = object;
            int n6 = n;
            int n7 = n6 + 1 >>> 1;
            int n8 = n6 - n7;
            int n9 = n7;
            int[] nArray6 = new int[n9];
            int[] nArray7 = new int[n9];
            int[] nArray8 = new int[n8];
            int[] nArray9 = new int[n8];
            System.arraycopy(nArray, 0, nArray6, 0, n7);
            System.arraycopy(nArray, n7, nArray8, 0, n8);
            System.arraycopy(nArray2, 0, nArray7, 0, n7);
            System.arraycopy(nArray2, n7, nArray9, 0, n8);
            int[] nArray10 = polynomialGF2mSmallM.add(nArray6, nArray8);
            int[] nArray11 = polynomialGF2mSmallM.add(nArray7, nArray9);
            nArray6 = polynomialGF2mSmallM.multiply(nArray6, nArray7);
            nArray10 = polynomialGF2mSmallM.multiply(nArray10, nArray11);
            nArray7 = polynomialGF2mSmallM.multiply(nArray8, nArray9);
            Object object2 = object;
            object = super.add(super.add(nArray10, nArray6), nArray7);
            nArray3 = polynomialGF2mSmallM.add(PolynomialGF2mSmallM.multWithMonomial(polynomialGF2mSmallM.add((int[])object, PolynomialGF2mSmallM.multWithMonomial(nArray7, n7)), n7), nArray6);
        }
        return nArray3;
    }

    private boolean isIrreducible(int[] nArray) {
        if (nArray[0] == 0) {
            return false;
        }
        int n = PolynomialGF2mSmallM.computeDegree(nArray) >> 1;
        int[] nArray2 = new int[2];
        int[] nArray3 = nArray2;
        nArray2[0] = 0;
        nArray2[1] = 1;
        int[] nArray4 = new int[2];
        int[] nArray5 = nArray4;
        nArray4[0] = 0;
        nArray4[1] = 1;
        int n2 = this.field.getDegree();
        for (int k = 0; k < n; ++k) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                nArray3 = this.modMultiply(nArray3, nArray3, nArray);
            }
            PolynomialGF2mSmallM polynomialGF2mSmallM = this;
            if (PolynomialGF2mSmallM.computeDegree(polynomialGF2mSmallM.gcd(polynomialGF2mSmallM.add(nArray3 = PolynomialGF2mSmallM.normalForm(nArray3), nArray5), nArray)) == 0) continue;
            return false;
        }
        return true;
    }

    private int[] mod(int[] nArray, int[] nArray2) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray2);
        if (n != -1) {
            int n2 = nArray.length;
            int[] nArray3 = new int[n2];
            int n3 = PolynomialGF2mSmallM.headCoefficient(nArray2);
            n3 = this.field.inverse(n3);
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            while (n <= PolynomialGF2mSmallM.computeDegree(nArray3)) {
                PolynomialGF2mSmallM polynomialGF2mSmallM = this;
                n2 = this.field.mult(PolynomialGF2mSmallM.headCoefficient(nArray3), n3);
                nArray3 = polynomialGF2mSmallM.add(polynomialGF2mSmallM.multWithElement(PolynomialGF2mSmallM.multWithMonomial(nArray2, PolynomialGF2mSmallM.computeDegree(nArray3) - n), n2), nArray3);
            }
            return nArray3;
        }
        throw new ArithmeticException("Division by zero");
    }

    private int[] modMultiply(int[] nArray, int[] nArray2, int[] nArray3) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        return polynomialGF2mSmallM.mod(polynomialGF2mSmallM.multiply(nArray, nArray2), nArray3);
    }

    private int[] modDiv(int[] nArray, int[] nArray2, int[] nArray3) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        int[] nArray4 = PolynomialGF2mSmallM.normalForm(nArray3);
        nArray2 = polynomialGF2mSmallM.mod(nArray2, nArray3);
        int[] nArray5 = new int[1];
        int[] nArray6 = nArray5;
        nArray5[0] = 0;
        nArray = polynomialGF2mSmallM.mod(nArray, nArray3);
        while (PolynomialGF2mSmallM.computeDegree(nArray2) != -1) {
            PolynomialGF2mSmallM polynomialGF2mSmallM2 = this;
            int[][] nArray7 = polynomialGF2mSmallM2.div(nArray4, nArray2);
            nArray4 = PolynomialGF2mSmallM.normalForm(nArray2);
            nArray2 = PolynomialGF2mSmallM.normalForm(nArray7[1]);
            int[] nArray8 = this.add(nArray6, polynomialGF2mSmallM2.modMultiply(nArray7[0], nArray, nArray3));
            nArray6 = PolynomialGF2mSmallM.normalForm(nArray);
            nArray = PolynomialGF2mSmallM.normalForm(nArray8);
        }
        int n = PolynomialGF2mSmallM.headCoefficient(nArray4);
        return this.multWithElement(nArray6, this.field.inverse(n));
    }

    private static boolean isEqual(int[] nArray, int[] nArray2) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n != PolynomialGF2mSmallM.computeDegree(nArray2)) {
            return false;
        }
        for (int k = 0; k <= n; ++k) {
            if (nArray[k] == nArray2[k]) continue;
            return false;
        }
        return true;
    }

    private void computeDegree() {
        int n;
        this.degree = this.coefficients.length - 1;
        while ((n = this.degree) >= 0 && this.coefficients[n] == 0) {
            this.degree = n - 1;
        }
    }

    private static int computeDegree(int[] nArray) {
        int n;
        for (n = nArray.length - 1; n >= 0 && nArray[n] == 0; --n) {
        }
        return n;
    }

    private static int[] normalForm(int[] nArray) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n == -1) {
            return new int[1];
        }
        if (nArray.length == ++n) {
            return IntUtils.clone(nArray);
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public int getDegree() {
        int n = this.coefficients.length - 1;
        if (this.coefficients[n] == 0) {
            return -1;
        }
        return n;
    }

    public int getHeadCoefficient() {
        int n = this.degree;
        if (n == -1) {
            return 0;
        }
        return this.coefficients[n];
    }

    public int getCoefficient(int n) {
        if (n >= 0 && n <= this.degree) {
            return this.coefficients[n];
        }
        return 0;
    }

    public byte[] getEncoded() {
        int n;
        int n2 = 1;
        for (n = 8; this.field.getDegree() > n; n += 8) {
            ++n2;
        }
        byte[] byArray = new byte[this.coefficients.length * n2];
        int n3 = 0;
        for (int k = 0; k < this.coefficients.length; ++k) {
            for (int i2 = 0; i2 < n; i2 += 8) {
                byArray[n3++] = (byte)(this.coefficients[k] >>> i2);
            }
        }
        return byArray;
    }

    public int evaluateAt(int n) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        int[] nArray = polynomialGF2mSmallM.coefficients;
        int n2 = nArray[polynomialGF2mSmallM.degree];
        for (int k = (v938627) - 1; k >= 0; --k) {
            n2 = this.field.mult(n2, n) ^ this.coefficients[k];
        }
        return n2;
    }

    public PolynomialGF2mSmallM add(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        object = this.coefficients;
        object = this.add((int[])object, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public void addToThis(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = object;
        Object object = ((PolynomialGF2mSmallM)object).coefficients;
        polynomialGF2mSmallM2.coefficients = polynomialGF2mSmallM2.add((int[])object, polynomialGF2mSmallM.coefficients);
        polynomialGF2mSmallM2.computeDegree();
    }

    public PolynomialGF2mSmallM addMonomial(int n) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        int[] nArray = new int[n + 1];
        int[] nArray2 = nArray;
        nArray[n] = 1;
        int[] nArray3 = polynomialGF2mSmallM.add(polynomialGF2mSmallM.coefficients, nArray2);
        return new PolynomialGF2mSmallM(this.field, nArray3);
    }

    public PolynomialGF2mSmallM multWithElement(int n) {
        if (this.field.isElementOfThisField(n)) {
            PolynomialGF2mSmallM polynomialGF2mSmallM = this;
            int[] nArray = polynomialGF2mSmallM.multWithElement(polynomialGF2mSmallM.coefficients, n);
            return new PolynomialGF2mSmallM(this.field, nArray);
        }
        throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
    }

    public void multThisWithElement(int n) {
        if (this.field.isElementOfThisField(n)) {
            PolynomialGF2mSmallM polynomialGF2mSmallM = this;
            polynomialGF2mSmallM.coefficients = polynomialGF2mSmallM.multWithElement(polynomialGF2mSmallM.coefficients, n);
            polynomialGF2mSmallM.computeDegree();
            return;
        }
        throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
    }

    public PolynomialGF2mSmallM multWithMonomial(int n) {
        int[] nArray = PolynomialGF2mSmallM.multWithMonomial(this.coefficients, n);
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public PolynomialGF2mSmallM[] div(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM;
        PolynomialGF2mSmallM polynomialGF2mSmallM2;
        PolynomialGF2mSmallM polynomialGF2mSmallM3 = object;
        object = ((PolynomialGF2mSmallM)((Object)gF2mField2)).coefficients;
        object = ((PolynomialGF2mSmallM)((Object)gF2mField2)).div((int[])object, polynomialGF2mSmallM3.coefficients);
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[2];
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM2;
        GF2mField gF2mField = ((PolynomialGF2mSmallM)((Object)gF2mField2)).field;
        polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(gF2mField, (int[])object[0]);
        polynomialGF2mSmallMArray[0] = polynomialGF2mSmallM4;
        polynomialGF2mSmallM4 = polynomialGF2mSmallM;
        GF2mField gF2mField2 = ((PolynomialGF2mSmallM)((Object)gF2mField2)).field;
        polynomialGF2mSmallM = new PolynomialGF2mSmallM(gF2mField2, (int[])object[1]);
        polynomialGF2mSmallMArray[1] = polynomialGF2mSmallM4;
        return polynomialGF2mSmallMArray;
    }

    public PolynomialGF2mSmallM gcd(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        object = this.coefficients;
        object = this.gcd((int[])object, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM multiply(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        object = this.coefficients;
        object = this.multiply((int[])object, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM mod(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        object = this.coefficients;
        object = this.mod((int[])object, polynomialGF2mSmallM.coefficients);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM modMultiply(PolynomialGF2mSmallM object, PolynomialGF2mSmallM object2) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object2;
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = object;
        object = this.coefficients;
        object2 = polynomialGF2mSmallM2.coefficients;
        int[] nArray = polynomialGF2mSmallM.coefficients;
        object = this.modMultiply((int[])object, (int[])object2, nArray);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM modSquareMatrix(PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        int n = polynomialGF2mSmallMArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (true) {
            int[] nArray3 = this.coefficients;
            if (n2 >= this.coefficients.length) break;
            int n3 = nArray3[n2];
            nArray2[n2] = this.field.mult(n3, n3);
            ++n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int k = 0; k < n; ++k) {
                int[] nArray4 = polynomialGF2mSmallMArray[k].coefficients;
                if (n2 >= polynomialGF2mSmallMArray[k].coefficients.length) continue;
                PolynomialGF2mSmallM polynomialGF2mSmallM = this;
                int n4 = nArray4[n2];
                n4 = polynomialGF2mSmallM.field.mult(n4, nArray2[k]);
                nArray[n2] = polynomialGF2mSmallM.field.add(nArray[n2], n4);
            }
        }
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public PolynomialGF2mSmallM modSquareRoot(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        int[] nArray = IntUtils.clone(this.coefficients);
        int[] nArray2 = polynomialGF2mSmallM.coefficients;
        nArray2 = this.modMultiply(nArray, nArray, nArray2);
        while (!PolynomialGF2mSmallM.isEqual(nArray2, this.coefficients)) {
            nArray = PolynomialGF2mSmallM.normalForm(nArray2);
            nArray2 = polynomialGF2mSmallM.coefficients;
            nArray2 = this.modMultiply(nArray, nArray, nArray2);
        }
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public PolynomialGF2mSmallM modSquareRootMatrix(PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        int n = polynomialGF2mSmallMArray.length;
        int[] nArray = new int[n];
        for (int k = 0; k < n; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                int[] nArray2 = polynomialGF2mSmallMArray[i2].coefficients;
                if (k >= polynomialGF2mSmallMArray[i2].coefficients.length) continue;
                int[] nArray3 = this.coefficients;
                if (i2 >= this.coefficients.length) continue;
                PolynomialGF2mSmallM polynomialGF2mSmallM = this;
                int n2 = nArray2[k];
                n2 = polynomialGF2mSmallM.field.mult(n2, nArray3[i2]);
                nArray[k] = polynomialGF2mSmallM.field.add(nArray[k], n2);
            }
        }
        for (int k = 0; k < n; ++k) {
            nArray[k] = this.field.sqRoot(nArray[k]);
        }
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public PolynomialGF2mSmallM modDiv(PolynomialGF2mSmallM object, PolynomialGF2mSmallM object2) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object2;
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = object;
        object = this.coefficients;
        object2 = polynomialGF2mSmallM2.coefficients;
        int[] nArray = polynomialGF2mSmallM.coefficients;
        object = this.modDiv((int[])object, (int[])object2, nArray);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM modInverse(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = object;
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = 1;
        int[] nArray2 = this.coefficients;
        int[] nArray3 = polynomialGF2mSmallM.coefficients;
        object = this.modDiv((int[])object, nArray2, nArray3);
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public PolynomialGF2mSmallM[] modPolynomialToFracton(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        PolynomialGF2mSmallM polynomialGF2mSmallM2;
        PolynomialGF2mSmallM polynomialGF2mSmallM3;
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM;
        int n = polynomialGF2mSmallM4.degree >> 1;
        int[] nArray = PolynomialGF2mSmallM.normalForm(polynomialGF2mSmallM4.coefficients);
        int[] nArray2 = this.coefficients;
        nArray2 = this.mod(nArray2, polynomialGF2mSmallM.coefficients);
        int[] nArray3 = new int[1];
        int[] nArray4 = nArray3;
        nArray3[0] = 0;
        int[] nArray5 = new int[1];
        int[] nArray6 = nArray5;
        nArray5[0] = 1;
        int[] nArray7 = nArray2;
        int[] nArray8 = nArray6;
        nArray6 = nArray4;
        nArray2 = nArray;
        nArray4 = nArray8;
        nArray = nArray7;
        while (PolynomialGF2mSmallM.computeDegree(nArray) > n) {
            PolynomialGF2mSmallM polynomialGF2mSmallM5 = this;
            int[][] nArray9 = this.div(nArray2, nArray);
            nArray2 = nArray9[1];
            int[] nArray10 = nArray9[0];
            int[] nArray11 = polynomialGF2mSmallM.coefficients;
            nArray6 = polynomialGF2mSmallM5.add(nArray6, polynomialGF2mSmallM5.modMultiply(nArray10, nArray4, nArray11));
            int[] nArray12 = nArray2;
            int[] nArray13 = nArray6;
            nArray6 = nArray4;
            nArray2 = nArray;
            nArray4 = nArray13;
            nArray = nArray12;
        }
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[2];
        polynomialGF2mSmallM = polynomialGF2mSmallM3;
        polynomialGF2mSmallM3 = new PolynomialGF2mSmallM(this.field, nArray);
        polynomialGF2mSmallMArray[0] = polynomialGF2mSmallM;
        polynomialGF2mSmallM = polynomialGF2mSmallM2;
        polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(this.field, nArray4);
        polynomialGF2mSmallMArray[1] = polynomialGF2mSmallM;
        return polynomialGF2mSmallMArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PolynomialGF2mSmallM) {
            object = (PolynomialGF2mSmallM)object;
            return this.field.equals(((PolynomialGF2mSmallM)object).field) && this.degree == ((PolynomialGF2mSmallM)object).degree && PolynomialGF2mSmallM.isEqual(this.coefficients, ((PolynomialGF2mSmallM)object).coefficients);
        }
        return false;
    }

    public int hashCode() {
        int n = this.field.hashCode();
        int n2 = 0;
        while (true) {
            int[] nArray = this.coefficients;
            if (n2 >= this.coefficients.length) break;
            n = n * 31 + nArray[n2];
            ++n2;
        }
        return n;
    }

    public String toString() {
        String string = b.a(" Polynomial over ").append(this.field.toString()).append(": \n").toString();
        for (int k = 0; k < this.coefficients.length; ++k) {
            string = b.a(string).append(this.field.elementToStr(this.coefficients[k])).append("Y^").append(k).append("+").toString();
        }
        return i.a(string, ";");
    }
}

