/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class PolynomialRingGF2m {
    private GF2mField field;
    private PolynomialGF2mSmallM p;
    public PolynomialGF2mSmallM[] sqMatrix;
    public PolynomialGF2mSmallM[] sqRootMatrix;

    public PolynomialRingGF2m(GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM) {
        PolynomialRingGF2m polynomialRingGF2m = this;
        polynomialRingGF2m.field = gF2mField;
        polynomialRingGF2m.p = polynomialGF2mSmallM;
        polynomialRingGF2m.computeSquaringMatrix();
        polynomialRingGF2m.computeSquareRootMatrix();
    }

    private void computeSquaringMatrix() {
        int[] nArray;
        int n;
        int n2;
        int n3 = this.p.getDegree();
        this.sqMatrix = new PolynomialGF2mSmallM[n3];
        for (n2 = 0; n2 < (n = n3 >> 1); ++n2) {
            PolynomialGF2mSmallM polynomialGF2mSmallM;
            n = n2 << 1;
            int[] nArray2 = new int[n + 1];
            nArray = nArray2;
            nArray2[n] = 1;
            PolynomialGF2mSmallM polynomialGF2mSmallM2 = polynomialGF2mSmallM;
            polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, nArray);
            this.sqMatrix[n2] = polynomialGF2mSmallM2;
        }
        while (n < n3) {
            PolynomialGF2mSmallM polynomialGF2mSmallM;
            n2 = n << 1;
            int[] nArray3 = new int[n2 + 1];
            nArray = nArray3;
            nArray3[n2] = 1;
            PolynomialGF2mSmallM polynomialGF2mSmallM3 = polynomialGF2mSmallM;
            polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, nArray);
            this.sqMatrix[n] = polynomialGF2mSmallM3.mod(this.p);
            ++n;
        }
    }

    private void computeSquareRootMatrix() {
        int n;
        int n2;
        int n3 = this.p.getDegree();
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[n3];
        for (n2 = n = n3 - 1; n2 >= 0; --n2) {
            PolynomialGF2mSmallM polynomialGF2mSmallM;
            PolynomialGF2mSmallM polynomialGF2mSmallM2 = polynomialGF2mSmallM;
            polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.sqMatrix[n2]);
            polynomialGF2mSmallMArray[n2] = polynomialGF2mSmallM2;
        }
        this.sqRootMatrix = new PolynomialGF2mSmallM[n3];
        while (n >= 0) {
            PolynomialGF2mSmallM polynomialGF2mSmallM;
            PolynomialGF2mSmallM polynomialGF2mSmallM3 = polynomialGF2mSmallM;
            polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, n);
            this.sqRootMatrix[n] = polynomialGF2mSmallM3;
            --n;
        }
        for (n = 0; n < n3; ++n) {
            if (polynomialGF2mSmallMArray[n].getCoefficient(n) == 0) {
                n2 = 0;
                for (int k = n + 1; k < n3; ++k) {
                    if (polynomialGF2mSmallMArray[k].getCoefficient(n) == 0) continue;
                    n2 = 1;
                    PolynomialRingGF2m.swapColumns(polynomialGF2mSmallMArray, n, k);
                    PolynomialRingGF2m.swapColumns(this.sqRootMatrix, n, k);
                    k = n3;
                }
                if (n2 == 0) {
                    throw new ArithmeticException("Squaring matrix is not invertible.");
                }
            }
            n2 = polynomialGF2mSmallMArray[n].getCoefficient(n);
            n2 = this.field.inverse(n2);
            polynomialGF2mSmallMArray[n].multThisWithElement(n2);
            this.sqRootMatrix[n].multThisWithElement(n2);
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                if (n2 == n || (n4 = polynomialGF2mSmallMArray[n2].getCoefficient(n)) == 0) continue;
                PolynomialGF2mSmallM polynomialGF2mSmallM = polynomialGF2mSmallMArray[n].multWithElement(n4);
                PolynomialGF2mSmallM polynomialGF2mSmallM4 = this.sqRootMatrix[n].multWithElement(n4);
                polynomialGF2mSmallMArray[n2].addToThis(polynomialGF2mSmallM);
                this.sqRootMatrix[n2].addToThis(polynomialGF2mSmallM4);
            }
        }
    }

    private static void swapColumns(PolynomialGF2mSmallM[] object, int n, int n2) {
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = object;
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray2 = object;
        object = polynomialGF2mSmallMArray[n];
        polynomialGF2mSmallMArray[n] = polynomialGF2mSmallMArray2[n2];
        polynomialGF2mSmallMArray2[n2] = object;
    }

    public PolynomialGF2mSmallM[] getSquaringMatrix() {
        return this.sqMatrix;
    }

    public PolynomialGF2mSmallM[] getSquareRootMatrix() {
        return this.sqRootMatrix;
    }
}

