/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.StringList;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.UTF8;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Vector;

public final class Strings {
    private static String LINE_SEPARATOR;

    public static String fromUTF8ByteArray(byte[] objectArray) {
        char[] cArray = new char[objectArray.length];
        objectArray = cArray;
        int n = UTF8.transcodeToUTF16(objectArray, cArray);
        if (n >= 0) {
            return new String((char[])objectArray, 0, n);
        }
        throw new IllegalArgumentException("Invalid UTF-8 input");
    }

    public static byte[] toUTF8ByteArray(String string) {
        return Strings.toUTF8ByteArray(string.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] object) {
        ByteArrayOutputStream byteArrayOutputStream;
        char[] cArray = object;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Strings.toUTF8ByteArray(cArray, byteArrayOutputStream);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
    }

    public static void toUTF8ByteArray(char[] cArray, OutputStream outputStream) {
        for (int k = 0; k < cArray.length; ++k) {
            int n = cArray[k];
            if (n < 128) {
                outputStream.write(n);
                continue;
            }
            if (n < 2048) {
                outputStream.write(n >> 6 | 0xC0);
                outputStream.write(n & 0x3F | 0x80);
                continue;
            }
            if (n >= 55296 && n <= 57343) {
                if (++k < cArray.length) {
                    char c2 = cArray[k];
                    if (n <= 56319) {
                        n = ((n & 0x3FF) << 10 | c2 & 0x3FF) + 65536;
                        outputStream.write(n >> 18 | 0xF0);
                        outputStream.write(n >> 12 & 0x3F | 0x80);
                        outputStream.write(n >> 6 & 0x3F | 0x80);
                        outputStream.write(n & 0x3F | 0x80);
                        continue;
                    }
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                throw new IllegalStateException("invalid UTF-16 codepoint");
            }
            outputStream.write(n >> 12 | 0xE0);
            outputStream.write(n >> 6 & 0x3F | 0x80);
            outputStream.write(n & 0x3F | 0x80);
        }
    }

    public static String toUpperCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int k = 0; k != cArray.length; ++k) {
            char c2 = cArray[k];
            if ('a' > c2 || 'z' < c2) continue;
            bl = true;
            cArray[k] = (char)(c2 - 97 + 65);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static String toLowerCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int k = 0; k != cArray.length; ++k) {
            char c2 = cArray[k];
            if ('A' > c2 || 'Z' < c2) continue;
            bl = true;
            cArray[k] = (char)(c2 - 65 + 97);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static byte[] toByteArray(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int k = 0; k != n; ++k) {
            byArray[k] = (byte)cArray[k];
        }
        return byArray;
    }

    public static byte[] toByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int k = 0; k != n; ++k) {
            byArray[k] = (byte)string.charAt(k);
        }
        return byArray;
    }

    public static int toByteArray(String string, byte[] byArray, int n) {
        int n2 = string.length();
        for (int k = 0; k < n2; ++k) {
            int n3 = n + k;
            byArray[n3] = (byte)string.charAt(k);
        }
        return n2;
    }

    public static String fromByteArray(byte[] byArray) {
        return new String(Strings.asCharArray(byArray));
    }

    public static char[] asCharArray(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        for (int k = 0; k != n; ++k) {
            cArray[k] = (char)(byArray[k] & 0xFF);
        }
        return cArray;
    }

    public static String[] split(String string, char c2) {
        Vector<String> vector;
        Vector<String> vector2 = vector;
        vector = new Vector<String>();
        int n = 1;
        while (n != 0) {
            int n2 = string.indexOf(c2);
            if (n2 > 0) {
                vector2.addElement(string.substring(0, n2));
                string = string.substring(n2 + 1);
                continue;
            }
            n = 0;
            vector2.addElement(string);
        }
        int n3 = vector2.size();
        String[] stringArray = new String[n3];
        for (n = 0; n != n3; ++n) {
            stringArray[n] = (String)vector2.elementAt(n);
        }
        return stringArray;
    }

    public static StringList newList() {
        return new StringListImpl(null);
    }

    public static String lineSeparator() {
        return LINE_SEPARATOR;
    }

    static {
        try {
            LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        catch (Exception exception) {
            try {
                LINE_SEPARATOR = String.format("%n", new Object[0]);
            }
            catch (Exception exception2) {
                LINE_SEPARATOR = "\n";
            }
        }
    }

    public static class StringListImpl
    extends ArrayList<String>
    implements StringList {
        private StringListImpl() {
        }

        public /* synthetic */ StringListImpl(1 var1_1) {
            this();
        }

        @Override
        public boolean add(String string) {
            return super.add(string);
        }

        @Override
        public String set(int n, String string) {
            return super.set(n, string);
        }

        @Override
        public void add(int n, String string) {
            super.add(n, string);
        }

        @Override
        public String[] toStringArray() {
            int n = ((AbstractCollection)this).size();
            String[] stringArray = new String[n];
            for (int k = 0; k != n; ++k) {
                stringArray[k] = (String)((AbstractList)this).get(k);
            }
            return stringArray;
        }

        @Override
        public String[] toStringArray(int n, int n2) {
            String[] stringArray = new String[n2 - n];
            int n3 = n;
            while (n3 != ((AbstractCollection)this).size() && n3 != n2) {
                int n4 = n3++;
                int n5 = n4 - n;
                stringArray[n5] = (String)((AbstractList)this).get(n4);
            }
            return stringArray;
        }
    }
}

