/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.util.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.OutputStream;

public class BufferingOutputStream
extends OutputStream {
    private final OutputStream other;
    private final byte[] buf;
    private int bufOff;

    public BufferingOutputStream(OutputStream outputStream) {
        BufferingOutputStream bufferingOutputStream = this;
        bufferingOutputStream.other = outputStream;
        bufferingOutputStream.buf = new byte[4096];
    }

    public BufferingOutputStream(OutputStream outputStream, int n) {
        this.other = outputStream;
        this.buf = new byte[n];
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.buf;
        int n3 = this.bufOff;
        if (n2 < this.buf.length - n3) {
            System.arraycopy(byArray, n, byArray2, n3, n2);
            this.bufOff += n2;
        } else {
            int n4 = n2;
            int n5 = n;
            BufferingOutputStream bufferingOutputStream = this;
            int n6 = n;
            n = byArray2.length - n3;
            System.arraycopy(byArray, n6, byArray2, n3, n);
            bufferingOutputStream.bufOff += n;
            bufferingOutputStream.flush();
            n2 = n5 + n;
            n = n4 - n;
            while (true) {
                byArray2 = this.buf;
                if (n < this.buf.length) break;
                BufferingOutputStream bufferingOutputStream2 = this;
                bufferingOutputStream2.other.write(byArray, n2, byArray2.length);
                byte[] byArray3 = bufferingOutputStream2.buf;
                n2 += bufferingOutputStream2.buf.length;
                n -= byArray3.length;
            }
            if (n > 0) {
                System.arraycopy(byArray, n2, byArray2, this.bufOff, n);
                this.bufOff += n;
            }
        }
    }

    @Override
    public void write(int n) {
        int n2;
        BufferingOutputStream bufferingOutputStream = this;
        byte[] byArray = bufferingOutputStream.buf;
        int n3 = bufferingOutputStream.bufOff;
        this.bufOff = n2 = n3 + 1;
        byArray[n3] = (byte)n;
        if (n2 == byArray.length) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        BufferingOutputStream bufferingOutputStream = object;
        BufferingOutputStream bufferingOutputStream2 = object;
        Object object = bufferingOutputStream2.buf;
        int n = bufferingOutputStream2.bufOff;
        bufferingOutputStream.other.write((byte[])object, 0, n);
        bufferingOutputStream.bufOff = 0;
        Arrays.fill(bufferingOutputStream.buf, (byte)0);
    }

    @Override
    public void close() {
        BufferingOutputStream bufferingOutputStream = this;
        bufferingOutputStream.flush();
        bufferingOutputStream.other.close();
    }
}

