/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.i18n.ErrorBundle;
import com.fis.ekyc.nfc.build_in.bouncycastle.i18n.LocalizedException;
import java.security.cert.CertPath;

public class CertPathReviewerException
extends LocalizedException {
    private int index = -1;
    private CertPath certPath = null;

    public CertPathReviewerException(ErrorBundle errorBundle, Throwable throwable) {
        super(errorBundle, throwable);
    }

    public CertPathReviewerException(ErrorBundle errorBundle) {
        super(errorBundle);
    }

    public CertPathReviewerException(ErrorBundle errorBundle, Throwable throwable, CertPath certPath, int n) {
        super(errorBundle, throwable);
        if (certPath != null && n != -1) {
            if (n >= -1 && n < certPath.getCertificates().size()) {
                CertPathReviewerException certPathReviewerException = this;
                certPathReviewerException.certPath = certPath;
                certPathReviewerException.index = n;
                return;
            }
            throw new IndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public CertPathReviewerException(ErrorBundle errorBundle, CertPath certPath, int n) {
        super(errorBundle);
        if (certPath != null && n != -1) {
            if (n >= -1 && n < certPath.getCertificates().size()) {
                CertPathReviewerException certPathReviewerException = this;
                certPathReviewerException.certPath = certPath;
                certPathReviewerException.index = n;
                return;
            }
            throw new IndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getIndex() {
        return this.index;
    }
}

