/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Time;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.X509Principal;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.ExtCertificateEncodingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.extension.X509ExtensionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public class X509V3CertificateGenerator {
    private final JcaJceHelper bcHelper;
    private final CertificateFactory certificateFactory;
    private V3TBSCertificateGenerator tbsGen;
    private ASN1ObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator;

    public X509V3CertificateGenerator() {
        X509ExtensionsGenerator x509ExtensionsGenerator;
        V3TBSCertificateGenerator v3TBSCertificateGenerator;
        CertificateFactory certificateFactory;
        BCJcaJceHelper bCJcaJceHelper;
        Object object = bCJcaJceHelper;
        bCJcaJceHelper = new BCJcaJceHelper();
        v1.bcHelper = object;
        object = certificateFactory;
        certificateFactory = new CertificateFactory();
        v1.certificateFactory = object;
        object = v3TBSCertificateGenerator;
        v3TBSCertificateGenerator = new V3TBSCertificateGenerator();
        v1.tbsGen = object;
        object = x509ExtensionsGenerator;
        x509ExtensionsGenerator = new X509ExtensionsGenerator();
        v1.extGenerator = object;
    }

    private DERBitString booleanToBitString(boolean[] blArray) {
        Object object = new byte[(blArray.length + 7) / 8];
        for (int k = 0; k != blArray.length; ++k) {
            int n = k / 8;
            Object object2 = object[n];
            int n2 = blArray[k] ? 1 << 7 - k % 8 : 0;
            object[n] = (byte)(object2 | n2);
        }
        int n = blArray.length % 8;
        if (n == 0) {
            return new DERBitString((byte[])object);
        }
        return new DERBitString((byte[])object, 8 - n);
    }

    private TBSCertificate generateTbsCert() {
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return this.tbsGen.generateTBSCertificate();
    }

    private X509Certificate generateJcaObject(TBSCertificate tBSCertificate, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2();
        aSN1EncodableVector2.add(tBSCertificate);
        aSN1EncodableVector.add(this.sigAlgId);
        aSN1EncodableVector.add(new DERBitString(byArray));
        return (X509Certificate)this.certificateFactory.engineGenerateCertificate(new ByteArrayInputStream(new DERSequence(aSN1EncodableVector2).getEncoded("DER")));
    }

    public void reset() {
        this.tbsGen = new V3TBSCertificateGenerator();
        this.extGenerator.reset();
    }

    public void setSerialNumber(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) > 0) {
            this.tbsGen.setSerialNumber(new ASN1Integer(bigInteger));
            return;
        }
        throw new IllegalArgumentException("serial number must be a positive integer");
    }

    public void setIssuerDN(X500Principal x500Principal) {
        try {
            this.tbsGen.setIssuer(new X509Principal(x500Principal.getEncoded()));
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(j.a("can't process principal: ", iOException));
        }
    }

    public void setIssuerDN(X509Name x509Name) {
        this.tbsGen.setIssuer(x509Name);
    }

    public void setNotBefore(Date date) {
        this.tbsGen.setStartDate(new Time(date));
    }

    public void setNotAfter(Date date) {
        this.tbsGen.setEndDate(new Time(date));
    }

    public void setSubjectDN(X500Principal x500Principal) {
        try {
            this.tbsGen.setSubject(new X509Principal(x500Principal.getEncoded()));
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(j.a("can't process principal: ", iOException));
        }
    }

    public void setSubjectDN(X509Name x509Name) {
        this.tbsGen.setSubject(x509Name);
    }

    public void setPublicKey(PublicKey publicKey) {
        try {
            this.tbsGen.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(publicKey.getEncoded()).readObject()));
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(d.a(exception, b.a("unable to process key - ")));
        }
    }

    public void setSignatureAlgorithm(String string) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X509V3CertificateGenerator x509V3CertificateGenerator = algorithmIdentifier;
        ((X509V3CertificateGenerator)((Object)algorithmIdentifier)).signatureAlgorithm = string;
        try {
            aSN1ObjectIdentifier = X509Util.getAlgorithmOID(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(i.a("Unknown signature type requested: ", string));
        }
        ((X509V3CertificateGenerator)((Object)algorithmIdentifier)).sigOID = aSN1ObjectIdentifier;
        AlgorithmIdentifier algorithmIdentifier = X509Util.getSigAlgID(aSN1ObjectIdentifier, string);
        x509V3CertificateGenerator.sigAlgId = algorithmIdentifier;
        x509V3CertificateGenerator.tbsGen.setSignature(algorithmIdentifier);
    }

    public void setSubjectUniqueID(boolean[] blArray) {
        this.tbsGen.setSubjectUniqueID(this.booleanToBitString(blArray));
    }

    public void setIssuerUniqueID(boolean[] blArray) {
        this.tbsGen.setIssuerUniqueID(this.booleanToBitString(blArray));
    }

    public void addExtension(String string, boolean bl, ASN1Encodable aSN1Encodable) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X509V3CertificateGenerator x509V3CertificateGenerator = aSN1ObjectIdentifier2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        x509V3CertificateGenerator.addExtension(aSN1ObjectIdentifier2, bl, aSN1Encodable);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(aSN1ObjectIdentifier.getId()), bl, aSN1Encodable);
    }

    public void addExtension(String string, boolean bl, byte[] byArray) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X509V3CertificateGenerator x509V3CertificateGenerator = aSN1ObjectIdentifier2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        x509V3CertificateGenerator.addExtension(aSN1ObjectIdentifier2, bl, byArray);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, byte[] byArray) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(aSN1ObjectIdentifier.getId()), bl, byArray);
    }

    public void copyAndAddExtension(String string, boolean bl, X509Certificate object) {
        byte[] byArray = object.getExtensionValue(string);
        object = byArray;
        if (byArray != null) {
            X509V3CertificateGenerator x509V3CertificateGenerator;
            try {
                x509V3CertificateGenerator = aSN1Primitive;
                ASN1Primitive aSN1Primitive = X509ExtensionUtil.fromExtensionValue((byte[])object);
            }
            catch (IOException iOException) {
                throw new CertificateParsingException(((Object)iOException).toString());
            }
            x509V3CertificateGenerator.addExtension(string, bl, (ASN1Encodable)aSN1Primitive);
            return;
        }
        throw new CertificateParsingException(g.a("extension ", string, " not present"));
    }

    public void copyAndAddExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, X509Certificate x509Certificate) {
        this.copyAndAddExtension(aSN1ObjectIdentifier.getId(), bl, x509Certificate);
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey) {
        try {
            return this.generateX509Certificate(privateKey, "BC", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, SecureRandom secureRandom) {
        try {
            return this.generateX509Certificate(privateKey, "BC", secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, String string) {
        return this.generateX509Certificate(privateKey, string, null);
    }

    public X509Certificate generateX509Certificate(PrivateKey privateKey, String string, SecureRandom secureRandom) {
        try {
            return this.generate(privateKey, string, secureRandom);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("exception: " + generalSecurityException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
    }

    public X509Certificate generate(PrivateKey privateKey) {
        return this.generate(privateKey, (SecureRandom)null);
    }

    public X509Certificate generate(PrivateKey privateKey, SecureRandom secureRandom) {
        byte[] byArray;
        X509V3CertificateGenerator x509V3CertificateGenerator = this;
        TBSCertificate tBSCertificate = x509V3CertificateGenerator.generateTbsCert();
        try {
            byArray = X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, privateKey, secureRandom, tBSCertificate);
        }
        catch (IOException iOException) {
            throw new ExtCertificateEncodingException("exception encoding TBS cert", iOException);
        }
        try {
            return x509V3CertificateGenerator.generateJcaObject(tBSCertificate, byArray);
        }
        catch (Exception exception) {
            throw new ExtCertificateEncodingException("exception producing certificate object", exception);
        }
    }

    public X509Certificate generate(PrivateKey privateKey, String string) {
        return this.generate(privateKey, string, null);
    }

    public X509Certificate generate(PrivateKey privateKey, String string, SecureRandom secureRandom) {
        byte[] byArray;
        X509V3CertificateGenerator x509V3CertificateGenerator = this;
        TBSCertificate tBSCertificate = x509V3CertificateGenerator.generateTbsCert();
        try {
            byArray = X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, string, privateKey, secureRandom, tBSCertificate);
        }
        catch (IOException iOException) {
            throw new ExtCertificateEncodingException("exception encoding TBS cert", iOException);
        }
        try {
            return x509V3CertificateGenerator.generateJcaObject(tBSCertificate, byArray);
        }
        catch (Exception exception) {
            throw new ExtCertificateEncodingException("exception producing certificate object", exception);
        }
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }
}

