/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.cvc.AbstractSequence;
import com.fis.ekyc.nfc.build_in.cvc.AlgorithmUtil;
import com.fis.ekyc.nfc.build_in.cvc.ByteField;
import com.fis.ekyc.nfc.build_in.cvc.CVCPublicKey;
import com.fis.ekyc.nfc.build_in.cvc.CVCTagEnum;
import com.fis.ekyc.nfc.build_in.cvc.CVCertificateBody;
import com.fis.ekyc.nfc.build_in.cvc.OIDField;
import com.fis.ekyc.nfc.build_in.cvc.Signable;
import com.fis.ekyc.nfc.build_in.cvc.exception.ConstructionException;
import com.fis.ekyc.nfc.build_in.cvc.util.BCECUtil;
import java.io.IOException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;

public class CVCertificate
extends AbstractSequence
implements Signable {
    private static final long serialVersionUID = 1L;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.CERTIFICATE_BODY, CVCTagEnum.SIGNATURE};

    public CVCertificate() {
        super(CVCTagEnum.CV_CERTIFICATE);
    }

    public CVCertificate(CVCertificateBody cVCertificateBody) {
        this();
        if (cVCertificateBody != null) {
            this.addSubfield(cVCertificateBody);
            return;
        }
        throw new IllegalArgumentException("body is null");
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    public void setSignature(byte[] byArray) {
        this.addSubfield(new ByteField(CVCTagEnum.SIGNATURE, byArray));
    }

    public CVCertificateBody getCertificateBody() {
        return (CVCertificateBody)this.getSubfield(CVCTagEnum.CERTIFICATE_BODY);
    }

    public byte[] getSignature() {
        return ((ByteField)this.getSubfield(CVCTagEnum.SIGNATURE)).getData();
    }

    @Override
    public byte[] getTBS() {
        try {
            return this.getCertificateBody().getDEREncoded();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ConstructionException(noSuchFieldException);
        }
        catch (IOException iOException) {
            throw new ConstructionException(iOException);
        }
    }

    public String toString() {
        return this.getAsText("");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verify(PublicKey publicKey, String object) {
        Object object2;
        try {
            object2 = (publicKey instanceof CVCPublicKey ? (CVCPublicKey)publicKey : this.getCertificateBody().getPublicKey()).getObjectIdentifier();
            object2 = AlgorithmUtil.getAlgorithmName((OIDField)object2);
        }
        catch (ConstructionException constructionException) {
            throw new CertificateException("CV-Certificate is corrupt", constructionException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("CV-Certificate is corrupt", noSuchFieldException);
        }
        {
            object = Signature.getInstance((String)object2, (String)object);
        }
        {
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(this.getTBS());
            if (((Signature)object).verify(BCECUtil.convertCVCSigToX962((String)object2, this.getSignature()))) {
                return;
            }
            throw new SignatureException("Signature verification failed!");
        }
    }
}

