/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.cvc;

import com.fis.ekyc.nfc.build_in.cvc.CVCertificate;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public class CardVerifiableCertificate
extends Certificate {
    private CVCertificate cvc;

    public CardVerifiableCertificate(CVCertificate cVCertificate) {
        super("CVC");
        this.cvc = cVCertificate;
    }

    public CVCertificate getCVCertificate() {
        return this.cvc;
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.cvc.getDEREncoded();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return this.cvc.getCertificateBody().getPublicKey();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            return null;
        }
    }

    @Override
    public void verify(PublicKey publicKey) {
        this.verify(publicKey, "BC");
    }

    @Override
    public void verify(PublicKey publicKey, String string) {
        this.cvc.verify(publicKey, string);
    }

    @Override
    public String toString() {
        return this.cvc.toString();
    }
}

