/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.AccessKeySpec;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import com.fis.ekyc.nfc.build_in.scuba.util.Hex;
import d.a;
import java.util.Arrays;

public class PACEKeySpec
implements AccessKeySpec {
    private static final long serialVersionUID = -7113246293247012560L;
    private byte[] key;
    private byte keyReference;

    public PACEKeySpec(String string2, byte by) {
        this(Util.getBytes(string2), by);
    }

    public PACEKeySpec(byte[] byArray, byte by) {
        this.keyReference = by;
        this.key = byArray;
    }

    public static PACEKeySpec createCANKey(String string2) {
        return new PACEKeySpec(string2, 2);
    }

    public static PACEKeySpec createPINKey(String string2) {
        return new PACEKeySpec(string2, 3);
    }

    public static PACEKeySpec createPUKKey(String string2) {
        return new PACEKeySpec(string2, 4);
    }

    private static String keyReferenceToString(byte by) {
        switch (by) {
            default: {
                return Integer.toString(by);
            }
            case 4: {
                return "PUK";
            }
            case 3: {
                return "PIN";
            }
            case 2: {
                return "CAN";
            }
            case 1: {
                return "MRZ";
            }
            case 0: 
        }
        return "NO";
    }

    @Override
    public String getAlgorithm() {
        return "PACE";
    }

    public byte getKeyReference() {
        return this.keyReference;
    }

    @Override
    public byte[] getKey() {
        return this.key;
    }

    public int hashCode() {
        return (Arrays.hashCode(this.key) + 31) * 31 + this.keyReference;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (PACEKeySpec)object;
        if (!Arrays.equals(this.key, ((PACEKeySpec)object).key)) {
            return false;
        }
        return this.keyReference == ((PACEKeySpec)object).keyReference;
    }

    public String toString() {
        return a.a(b.a("PACEKeySpec [key: ").append(Hex.bytesToHexString(this.key)).append(", keyReference: "), PACEKeySpec.keyReferenceToString(this.keyReference), "]");
    }
}

