/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.cert;

import com.fis.ekyc.nfc.build_in.cvc.AccessRightEnum;
import com.fis.ekyc.nfc.build_in.cvc.AlgorithmUtil;
import com.fis.ekyc.nfc.build_in.cvc.AuthorizationRoleEnum;
import com.fis.ekyc.nfc.build_in.cvc.CAReferenceField;
import com.fis.ekyc.nfc.build_in.cvc.CVCPublicKey;
import com.fis.ekyc.nfc.build_in.cvc.CVCertificate;
import com.fis.ekyc.nfc.build_in.cvc.CVCertificateBody;
import com.fis.ekyc.nfc.build_in.cvc.HolderReferenceField;
import com.fis.ekyc.nfc.build_in.cvc.ReferenceField;
import com.fis.ekyc.nfc.build_in.cvc.exception.ConstructionException;
import com.fis.ekyc.nfc.build_in.eidparser.cert.CVCAuthorizationTemplate;
import com.fis.ekyc.nfc.build_in.eidparser.cert.CVCPrincipal;
import com.fis.ekyc.nfc.build_in.scuba.data.Country;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CardVerifiableCertificate
extends Certificate {
    private static final long serialVersionUID = -3585440601605666288L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private CVCertificate cvCertificate;
    private transient KeyFactory rsaKeyFactory;

    public CardVerifiableCertificate(CVCertificate cVCertificate) {
        super("CVC");
        try {
            this.rsaKeyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.WARNING, "Exception", noSuchAlgorithmException);
        }
        this.cvCertificate = cVCertificate;
    }

    public CardVerifiableCertificate(CVCPrincipal object, CVCPrincipal object2, PublicKey publicKey, String string2, Date date, Date date2, CVCAuthorizationTemplate.Role object3, CVCAuthorizationTemplate.Permission object4, byte[] byArray) {
        CVCertificate cVCertificate;
        CVCertificateBody cVCertificateBody;
        HolderReferenceField holderReferenceField;
        CVCPrincipal cVCPrincipal;
        CVCPrincipal cVCPrincipal2;
        CAReferenceField cAReferenceField;
        CVCAuthorizationTemplate.Permission permission = object4;
        CVCAuthorizationTemplate.Role role = object3;
        this((CVCertificate)null);
        object3 = cAReferenceField;
        try {
            CVCPrincipal cVCPrincipal3 = object;
            cVCPrincipal2 = cVCPrincipal3;
            cVCPrincipal = cVCPrincipal3;
            object = cVCPrincipal3.getCountry().toAlpha2Code();
        }
        catch (ConstructionException constructionException) {
            throw new IllegalArgumentException(constructionException);
        }
        object4 = cVCPrincipal.getMnemonic();
        Object object5 = cVCPrincipal2.getSeqNumber();
        cAReferenceField = new CAReferenceField((String)object, (String)object4, (String)object5);
        object = holderReferenceField;
        CVCPrincipal cVCPrincipal4 = object2;
        CVCPrincipal cVCPrincipal5 = cVCPrincipal4;
        CVCPrincipal cVCPrincipal6 = cVCPrincipal4;
        object2 = cVCPrincipal4.getCountry().toAlpha2Code();
        object4 = cVCPrincipal6.getMnemonic();
        object5 = cVCPrincipal5.getSeqNumber();
        holderReferenceField = new HolderReferenceField((String)object2, (String)object4, (String)object5);
        object2 = CVCAuthorizationTemplate.fromRole(role);
        object4 = CVCAuthorizationTemplate.fromPermission(permission);
        object5 = cVCertificateBody;
        cVCertificateBody = new CVCertificateBody((CAReferenceField)object3, com.fis.ekyc.nfc.build_in.cvc.KeyFactory.createInstance(publicKey, string2, (AuthorizationRoleEnum)object2), (HolderReferenceField)object, (AuthorizationRoleEnum)object2, (AccessRightEnum)object4, date, date2);
        object = cVCertificate;
        Object object6 = object;
        ((CVCertificate)object6)((CVCertificateBody)object5);
        this.cvCertificate = object6;
        cVCertificate.setSignature(byArray);
        this.cvCertificate.getTBS();
    }

    public String getSigAlgName() {
        try {
            return AlgorithmUtil.getAlgorithmName(this.cvCertificate.getCertificateBody().getPublicKey().getObjectIdentifier());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOGGER.log(Level.WARNING, "No such field", noSuchFieldException);
            return null;
        }
    }

    public String getSigAlgOID() {
        try {
            return this.cvCertificate.getCertificateBody().getPublicKey().getObjectIdentifier().getAsText();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOGGER.log(Level.WARNING, "No such field", noSuchFieldException);
            return null;
        }
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.cvCertificate.getDEREncoded();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicKey getPublicKey() {
        try {
            Serializable serializable;
            CVCPublicKey cVCPublicKey = ((CardVerifiableCertificate)serializable).cvCertificate.getCertificateBody().getPublicKey();
            if (!"RSA".equals(cVCPublicKey.getAlgorithm())) {
                return cVCPublicKey;
            }
            CardVerifiableCertificate cardVerifiableCertificate = serializable;
            serializable = (RSAPublicKey)((Object)cVCPublicKey);
            try {
                Serializable serializable2 = serializable;
                serializable = serializable2.getModulus();
                return cardVerifiableCertificate.rsaKeyFactory.generatePublic(new RSAPublicKeySpec((BigInteger)serializable, serializable2.getPublicExponent()));
            }
            catch (GeneralSecurityException generalSecurityException) {
                LOGGER.log(Level.WARNING, "Exception", generalSecurityException);
                return cVCPublicKey;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOGGER.log(Level.WARNING, "No such field", noSuchFieldException);
            return null;
        }
    }

    @Override
    public String toString() {
        return this.cvCertificate.toString();
    }

    @Override
    public void verify(PublicKey publicKey) {
        Provider[] providerArray = Security.getProviders();
        boolean bl = false;
        for (Provider provider : providerArray) {
            try {
                this.cvCertificate.verify(publicKey, provider.getName());
                bl = true;
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOGGER.log(Level.FINE, "Trying next provider", noSuchAlgorithmException);
            }
        }
        if (bl) {
            return;
        }
        throw new NoSuchAlgorithmException("Tried all security providers: None was able to provide this signature algorithm.");
    }

    @Override
    public void verify(PublicKey publicKey, String string2) {
        this.cvCertificate.verify(publicKey, string2);
    }

    public byte[] getCertBodyData() {
        try {
            return this.cvCertificate.getCertificateBody().getDEREncoded();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
    }

    public Date getNotBefore() {
        try {
            return this.cvCertificate.getCertificateBody().getValidFrom();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
    }

    public Date getNotAfter() {
        try {
            return this.cvCertificate.getCertificateBody().getValidTo();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
    }

    public CVCPrincipal getAuthorityReference() {
        CVCPrincipal cVCPrincipal;
        Object object;
        try {
            object = ((CardVerifiableCertificate)object).cvCertificate.getCertificateBody().getAuthorityReference();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
        Country country = Country.getInstance(((ReferenceField)object).getCountry().toUpperCase());
        CVCPrincipal cVCPrincipal2 = cVCPrincipal;
        CVCPrincipal cVCPrincipal3 = cVCPrincipal;
        Country country2 = country;
        Serializable serializable = object;
        Serializable serializable2 = serializable;
        object = ((ReferenceField)serializable).getMnemonic();
        cVCPrincipal2(country2, (String)object, ((ReferenceField)serializable2).getSequence());
        return cVCPrincipal3;
    }

    public CVCPrincipal getHolderReference() {
        CVCPrincipal cVCPrincipal;
        Object object;
        try {
            object = ((CardVerifiableCertificate)object).cvCertificate.getCertificateBody().getHolderReference();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
        CVCPrincipal cVCPrincipal2 = cVCPrincipal;
        CVCPrincipal cVCPrincipal3 = cVCPrincipal;
        Serializable serializable = object;
        Serializable serializable2 = serializable;
        Serializable serializable3 = serializable;
        object = Country.getInstance(((ReferenceField)serializable).getCountry().toUpperCase());
        String string2 = ((ReferenceField)serializable3).getMnemonic();
        String string3 = ((ReferenceField)serializable2).getSequence();
        cVCPrincipal2((Country)object, string2, string3);
        return cVCPrincipal3;
    }

    public CVCAuthorizationTemplate getAuthorizationTemplate() {
        try {
            Serializable serializable = serializable.cvCertificate.getCertificateBody().getAuthorizationTemplate();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
        return new CVCAuthorizationTemplate((com.fis.ekyc.nfc.build_in.cvc.CVCAuthorizationTemplate)serializable);
    }

    public byte[] getSignature() {
        try {
            return this.cvCertificate.getSignature();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return !this.getClass().equals(object.getClass()) ? false : this.cvCertificate.equals(((CardVerifiableCertificate)object).cvCertificate);
    }

    @Override
    public int hashCode() {
        return this.cvCertificate.hashCode() * 2 - 1030507011;
    }
}

