/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.eidparser.lds.DataGroup;
import com.fis.ekyc.nfc.build_in.eidparser.lds.DisplayedImageInfo;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVInputStream;
import com.fis.ekyc.nfc.build_in.scuba.tlv.TLVOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public abstract class DisplayedImageDataGroup
extends DataGroup {
    private static final long serialVersionUID = 5994136177872308962L;
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    private static final int DISPLAYED_IMAGE_COUNT_TAG = 2;
    private int displayedImageTagToUse;
    private List<DisplayedImageInfo> imageInfos;

    public DisplayedImageDataGroup(int n, List<DisplayedImageInfo> list, int n2) {
        super(n);
        if (list != null) {
            DisplayedImageDataGroup displayedImageDataGroup;
            ArrayList<DisplayedImageInfo> arrayList;
            serializable.displayedImageTagToUse = n2;
            Serializable serializable = arrayList;
            arrayList = new ArrayList<DisplayedImageInfo>(list);
            displayedImageDataGroup.imageInfos = serializable;
            displayedImageDataGroup.checkTypesConsistentWithTag();
            return;
        }
        throw new IllegalArgumentException("imageInfos cannot be null");
    }

    public DisplayedImageDataGroup(int n, InputStream inputStream) {
        DisplayedImageDataGroup displayedImageDataGroup = this;
        super(n, inputStream);
        if (displayedImageDataGroup.imageInfos == null) {
            ArrayList<DisplayedImageInfo> arrayList;
            ArrayList<DisplayedImageInfo> arrayList2 = arrayList;
            arrayList = new ArrayList<DisplayedImageInfo>();
            this.imageInfos = arrayList2;
        }
        this.checkTypesConsistentWithTag();
    }

    private void add(DisplayedImageInfo displayedImageInfo) {
        if (this.imageInfos == null) {
            ArrayList<DisplayedImageInfo> arrayList;
            ArrayList<DisplayedImageInfo> arrayList2 = arrayList;
            arrayList = new ArrayList<DisplayedImageInfo>();
            this.imageInfos = arrayList2;
        }
        this.imageInfos.add(displayedImageInfo);
    }

    private void checkTypesConsistentWithTag() {
        for (DisplayedImageInfo displayedImageInfo : this.imageInfos) {
            if (displayedImageInfo != null) {
                int n = displayedImageInfo.getType();
                if (n != 0) {
                    if (n != 1) {
                        LOGGER.warning("Unsupported image type");
                        continue;
                    }
                    if (this.displayedImageTagToUse == 24387) continue;
                    throw new IllegalArgumentException("'Portrait' image cannot be part of a 'Signature or usual mark' displayed image datagroup");
                }
                if (this.displayedImageTagToUse == 24384) continue;
                throw new IllegalArgumentException("'Signature or usual mark' image cannot be part of a 'Portrait' displayed image datagroup");
            }
            throw new IllegalArgumentException("Found a null image info");
        }
    }

    @Override
    public void readContent(InputStream inputStream) {
        int n;
        block6: {
            block7: {
                if (inputStream instanceof TLVInputStream) {
                    inputStream = (TLVInputStream)inputStream;
                } else {
                    TLVInputStream tLVInputStream;
                    TLVInputStream tLVInputStream2 = tLVInputStream;
                    tLVInputStream = new TLVInputStream(inputStream);
                    inputStream = tLVInputStream2;
                }
                n = ((TLVInputStream)inputStream).readTag();
                if (n != 2) break block6;
                if (((TLVInputStream)inputStream).readLength() != 1) break block7;
                n = ((TLVInputStream)inputStream).readValue()[0] & 0xFF;
                for (int k = 0; k < n; ++k) {
                    block10: {
                        DisplayedImageInfo displayedImageInfo;
                        block9: {
                            block8: {
                                DisplayedImageInfo displayedImageInfo2;
                                displayedImageInfo = displayedImageInfo2;
                                displayedImageInfo2 = new DisplayedImageInfo(inputStream);
                                if (k != 0) break block8;
                                this.displayedImageTagToUse = displayedImageInfo.getDisplayedImageTag();
                                break block9;
                            }
                            if (displayedImageInfo.getDisplayedImageTag() != this.displayedImageTagToUse) break block10;
                        }
                        this.add(displayedImageInfo);
                        continue;
                    }
                    throw new IOException("Found images with different displayed image tags inside displayed image datagroup");
                }
                return;
            }
            throw new IllegalArgumentException("DISPLAYED_IMAGE_COUNT should have length 1");
        }
        throw new IllegalArgumentException(h.a(n, b.a("Expected tag 0x02 in displayed image structure, found ")));
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            TLVOutputStream tLVOutputStream2 = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
            outputStream = tLVOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        ((TLVOutputStream)outputStream2).writeTag(2);
        ((TLVOutputStream)outputStream2).writeValue(new byte[]{(byte)((DisplayedImageDataGroup)((Object)iterator)).imageInfos.size()});
        Iterator<DisplayedImageInfo> iterator = ((DisplayedImageDataGroup)((Object)iterator)).imageInfos.iterator();
        while (iterator.hasNext()) {
            ((DisplayedImageInfo)iterator.next()).writeObject(outputStream);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        boolean bl = true;
        Object object = this.imageInfos;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                DisplayedImageInfo displayedImageInfo = (DisplayedImageInfo)object.next();
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(displayedImageInfo.toString());
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append("]");
            return stringBuilder3.toString();
        }
        throw new IllegalStateException("imageInfos cannot be null");
    }

    public int hashCode() {
        int n = 1337;
        List<DisplayedImageInfo> list = this.imageInfos;
        return (list == null ? 1 : list.hashCode()) + n + 31337;
    }

    public boolean equals(Object list) {
        if (list == null) {
            return false;
        }
        if (list == list2) {
            return true;
        }
        if (!list2.getClass().equals(list.getClass())) {
            return false;
        }
        DisplayedImageDataGroup displayedImageDataGroup = list2;
        List<DisplayedImageInfo> list2 = (DisplayedImageDataGroup)((Object)list);
        list = displayedImageDataGroup.imageInfos;
        list2 = ((DisplayedImageDataGroup)((Object)list2)).imageInfos;
        return list == list2 || list != null && list.equals(list2);
    }

    public List<DisplayedImageInfo> getImages() {
        return new ArrayList<DisplayedImageInfo>(this.imageInfos);
    }
}

